// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef QC_CACHE_INC
#define QC_CACHE_INC

#include "Object.h"

namespace Torch {

/** "Cache" used by the Quadratic Constrained Trainer (#QCTrainer#).
    This class provides the Q (symetric) matrix of the
    quadratic problem.

    @author Ronan Collobert (collober@iro.umontreal.ca)
    @see QCTrainer
*/
class QCCache : public Object
{
  public:

    //-----

    ///
    QCCache();

    /// Returns the adress of the row/column #index# for the Q matrix.
    virtual real *adressCache(int index) = 0;

    /// Allocate the cache.
    virtual void allocate() = 0;

    /// Erase the cache (but don't destroy it).
    virtual void clear() = 0;

    /// Destroy the cache.
    virtual void destroy() = 0;

    /** The index of the active variables will be those
        contained in #active_var#, and the number of active
        variable will be #*n_active_var_#.

        (It's usefull for some problems)
        
        @see QCMachine
        @see QCTrainer
    */
    virtual void setBoosterMode(int *n_active_var_, int *active_var_) = 0;

    //-----

    virtual ~QCCache();
};


}

#endif
