// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef MSE_MEASURER_INC
#define MSE_MEASURER_INC

#include "Measurer.h"
#include "DataSet.h"

namespace Torch {

/** Mean Squared Error measurer.
    Compute the MSE between its inputs,
    and the targets of its associated #DataSet#.

    #measure# = { <[real] previous MSE> <[real] current sum for computing MSE> }

    @author Ronan Collobert (collober@iro.umontreal.ca)
*/
class MseMeasurer : public Measurer
{
  public:
    real *erreur;
    real *erreur_c;
    List *inputs;

    //-----

    ///
    MseMeasurer(List *inputs_, DataSet *data_, FILE *file_);

    ///
    MseMeasurer(List *inputs_, DataSet *data_, const char *filename);

    //-----

    virtual void init();
    virtual void reset();
    virtual void measureEx();
    virtual void measureIter();

    virtual ~MseMeasurer();
};


}

#endif
