// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "Mixer.h"

namespace Torch {

Mixer::Mixer(int n_experts_, int n_outputs_per_expert)
{
  n_experts = n_experts_;
  n_inputs = n_experts*(n_outputs_per_expert+1);
  n_outputs = n_outputs_per_expert;
}

int Mixer::numberOfParams()
{
  return(0);
}

void Mixer::forward(List *inputs)
{
  real *ptr_out = (real *)outputs->ptr;
  for(int j = 0; j < n_outputs; j++)
    *ptr_out++ = 0;
  
  real *x = (real *)inputs->ptr;
  List *out_experts = inputs->next;
  int k = out_experts->n;
  real *y = (real *)out_experts->ptr;
  for(int i = 0; i < n_experts; i++)
  {
    real *ptr_out = (real *)outputs->ptr;
    for(int j = 0; j < n_outputs; j++)
    {
      if(k == 0)
      {
        out_experts = out_experts->next;
        k = out_experts->n;
        y = (real *)out_experts->ptr;        
      }
      *ptr_out++ += *x * *y++;
      k--;
    }
    x++;
  }
}

void Mixer::backward(List *inputs, real *alpha)
{
  real *ptr_beta = beta;
  for(int i = 0; i < n_experts; i++)
    *ptr_beta++ = 0;
    
  ptr_beta = beta;
  List *out_experts = inputs->next;
  int k = out_experts->n;
  real *y = (real *)out_experts->ptr;
  for(int i = 0; i < n_experts; i++)
  {
    real *ptr_alpha = alpha;
    for(int j = 0; j < n_outputs; j++)
    {
      if(k == 0)
      {
        out_experts = out_experts->next;
        k = out_experts->n;
        y = (real *)out_experts->ptr;        
      }
      *ptr_beta += *ptr_alpha++ * *y++;
      k--;
    }
    ptr_beta++;
  }

  real *x = (real *)inputs->ptr;
  for(int i = 0; i < n_experts; i++)
  {
    real *ptr_alpha = alpha;
    for(int j = 0; j < n_outputs; j++)
      *ptr_beta++ = *ptr_alpha++ * *x;

    x++;
  }
}

Mixer::~Mixer()
{
}

}

