// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "InputsSelect.h"

namespace Torch {

InputsSelect::InputsSelect(int n_inputs_, int offset_, int n_selected_)
{
  n_inputs = n_inputs_;
  offset = offset_;
  n_outputs = n_selected_;
}

int InputsSelect::numberOfParams()
{
  return(0);
}

void InputsSelect::init()
{
  GradientMachine::init();

  for(int i = 0; i < offset; i++)
    beta[i]  = 0;

  for(int i = offset+n_outputs; i < n_inputs; i++)
    beta[i]  = 0;
}

void InputsSelect::forward(List *inputs)
{
  real *ptr_out = (real *)outputs->ptr;
  int k = 0;
  while(inputs)
  {
    if(k+inputs->n < offset)
      k += inputs->n;
    else
    {
      real *x = (real *)inputs->ptr;
      for(int i = 0; i < inputs->n; i++)
      {
        if(k >= offset)
        {
          *ptr_out++ = *x;
          if(k >= offset+n_outputs-1)
            break;
        }
        x++;
        k++;
      }
    }

    if(k >= offset+n_outputs)
      break;

    inputs = inputs->next;
  }
}

void InputsSelect::backward(List *inputs, real *alpha)
{
  real *ptr_beta = beta + offset;
  for(int i = 0; i < n_outputs; i++)
    *ptr_beta++ = *alpha++;
}

InputsSelect::~InputsSelect()
{
}

}

