// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef FILE_SPARSE_DATA_SET_INC
#define FILE_SPARSE_DATA_SET_INC

#include "SparseDataSet.h"
#include "IOTorch.h"

namespace Torch {

/** Create a #DataSet# from a \emph{sparse} disk file.

    @author Ronan Collobert (collober@iro.umontreal.ca)
 */
class FileSparseDataSet : public SparseDataSet
{
  public:
    IOTorch melanie;

    //-----

    /** Load #file# in memory.
        \begin{itemize}
          \item #n_inputs_# is the input dimension of each example.
          \item #n_targets# is the target dimension of each example.
          \item #bin# is #true# if the file is in binary format.
          \item if #max_load# > 0, it loads only the first #max_load# examples.
        \end{itemize}
    */
    FileSparseDataSet(const char *file, int n_inputs_, int n_targets, bool bin=false, int max_load=-1);

    //-----

    virtual ~FileSparseDataSet();
};


}

#endif

