// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef EUCLIDEAN_DATA_SET_INC
#define EUCLIDEAN_DATA_SET_INC

#include "DataSet.h"

namespace Torch {

/** #DataSet# with dot-products.

    @author Ronan Collobert (collober@iro.umontreal.ca)
 */
class EuclideanDataSet : public DataSet
{
  public:

    ///
    EuclideanDataSet();

    /// Dot product functions
    /** Dot products between two examples. Not that
        if a parameter is a #List#, this one \emph{must} have
        the same format as the format generated by the #DataSet#
        class for #inputs#.
    */
    /// Between #selected_examples[i]# and #selected_examples[j]#.
    real dotProduct(int i, int j);

    /// Between #selected_examples[i]# and #y#.
    real dotProduct(int i, List *y);

    /// Between #i# and #selected_examples[j]#
    real realDotProduct(int i, int j);

    /// Between #i# and #j#
    virtual real realRealDotProduct(int i, int j) = 0;

    /// Between #i# and #y#
    virtual real realDotProduct(int i, List *y) = 0;

    /// Between #x# and #y#
    virtual real dotProduct(List *x, List *y) = 0;

    virtual ~EuclideanDataSet();
};


}

#endif
