// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef TABLE_LOOKUP_DISTRIBUTION_INC
#define TABLE_LOOKUP_DISTRIBUTION_INC

#include "Distribution.h"

namespace Torch {

/** This class outputs one of the observations as the logProbability. It
    can eventually apply a log transformation and/or normalize by a given
    prior. It can therefore
    be used in conjunction with HMMs to implement the HMM/ANN hybrid model...

    @author Samy Bengio (bengio@idiap.ch)
*/
class TableLookupDistribution : public Distribution
{
  public:

    /** The column in the observation vector that corresponds to the
        logProbability.
    */
    int column;

    /// do we apply a log transformation
    bool apply_log;

    /// do we normalize by a given prior
    real prior;

    /** The column number corresponds to the logProbability which can
        be normalized by an eventual prior.
    */
    TableLookupDistribution(int column_ = 0, bool apply_log_ = true, real prior_ = 1.);

    virtual int numberOfParams();

    virtual real frameLogProbability(real *observations, real *inputs, int t);

    virtual ~TableLookupDistribution();
};


}

#endif
