namespace eval whois {
    variable whois

    # Define the whois array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set whois {
        dialog ""
        list.reset ""
	list.clear ""
        entry.domain ""
	entry.server ""
	server whois.internic.net
    }
}

# whois::create --
#
#   Method to create the dialog box for the whois command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::create { } {
    global tkWorld
    variable whois

    # Put the focus on the whois dialog if it is already open.
    if [winfo exists $whois(dialog)] {
        switch -- [wm state $whois(dialog)] {
            normal {
                raise $whois(dialog)
            }
            withdrawn -
            iconic {
                wm deiconify $whois(dialog)
            }
        }
        focus $whois(dialog)
        return
    } else {
        set whois(dialog) [dialog::create .whois Whois]
    }
   
    # Set the server list for the ddlistbox.
    set server_list {"whois.nic.af   " "whois.nic.am   " "whois.nic.at   " \
             "whois.aunic.net   " "joshua.ripe.net   " "whois.nic.bt   " \
	     "joshua.ripe.net   " "whois.ripe.net   " "whois.cdnnet.ca   " \
	     "whois.cnnic.cn   " "whois.khnic.net.hk   " \
	     "whois.ncst.ernet.in   " "whois.isi.edu   " \
	     "whois.nic-se.se   " "whois.twnic.net   " "whois.nic.ch   "}
    # There is only one tab. 
    set tab1 [tabnotebook::page [dialog::interior \
            $whois(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
            -class TabnotebookFrame]
    label $f1.label_domain \
            -text "Domain name" \
            -width 15 \
            -anchor e
    set whois(entry.domain) [entry $f1.entry_domain \
            -width 20 \
            -textvariable whois::whois(domain)]
    grid $f1.label_domain $f1.entry_domain \
            -padx 2 \
            -pady 2 \
            -sticky w
    # Build the frame which allows the user to chage the server.
    set f2 [frame $tab1.f2 \
            -class TabnotebookFrame]

    label $f2.label_server \
            -text "Server name" \
	    -width 10
    set whois(entry.server) [ddlistbox::create \
            $f2 whois::whois(server) $server_list "20"]
    grid $f2.label_server $whois(entry.server) \
            -sticky w \
	    -padx 2 \
	    -pady 2

    # Create all of the tabs at once.
    pack $f1 $f2 \
            -side top \
            -fill x \
            -padx 5 \
            -pady 5 \
            -ipadx 5 \
            -ipady 5

    focus $whois(entry.domain)
    
    # Define the lists for the reset and clear methods
    set whois(list.reset) ""
    set whois(list.clear) "domain server"
}

# whois::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::ok { } {
    global tkWorld
    variable whois       

    # Insert the Tcl command list in the Command Center with the
    # proper formatting of a space between each argument on the
    # command line.  If there are no options given by the user,
    # then don't display it in the CC.

    $tkWorld(cmd_center) insert insert "whois "

    # Build the command line argument.
    set cmd_arg ""
    if {$whois(server) != "whois.internic.net"} {
        append cmd_arg [string trimright $whois(server)]
    }
    if [string length $cmd_arg] {
        $tkWorld(cmd_center) insert insert "-h $cmd_arg "
    }
    # Insert the users selected domains.
    if [string length $whois(domain)] {
        $tkWorld(cmd_center) insert insert "$whois(domain) "
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}          

# whois::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::reset { } {
    variable whois

    # Reset all of the list elements.
    foreach x $whois(list.reset) {
        set whois($x) ""
    }

}

# whois::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::clear { } {
    variable whois

    # Reset the data structure elements and bg/fg.
    foreach x $whois(list.clear) {
        set whois($x) ""
	switch $x {
	    server {
	        set whois($x) whois.internic.net
            }
	    default {
                $whois(entry.$x) configure -bg #ffffff -fg #000000
	    }
	}
    }

   focus $whois(entry.domain)
}

# whois::help --
#
#   Method to invoke the whois Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::help { } {
    global tkWorld

        help::create "help/whois.html" "Whois Command Help"
}        

# whois::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::close { } {
    variable whois 

    balloonhelp::cancel
    destroy $whois(dialog)
}

# whois::open --
#
#   Method to add a file to the file entry and move the cursor
#   index of the entry to the end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc whois::open { } {
    variable whois

     regsub { } [file::select] {} whois(host)
    $whois(host_entry) icursor end
}            

