#! /bin/sh
## thylog2combined.sh -- Convert thy request logs from syslog to NCSA combined format
## (C) 2002, 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
##
## This file is part of Thy.
##
## Thy is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; version 2 dated June, 1991.
##
## Thy is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
## or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
## License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

# Set up defaults
SOURCE=/var/log/syslog
DEST=/var/log/thy--common.log

# Parse command-line
if [ "$1" = "-h" ] || [ "$1" = "--help" ] || [ "$1" = "-help" ]; then
	echo "thylog2combined.sh -- convert thy logs to NCSA combined format"
	echo
	echo "Usage: thylog2combined.sh [source [destination]]"
	exit 0
fi

[ ! -z "$1" ] && SOURCE=$1
[ ! -z "$2" ] && DEST=$2

# Do our job
sed -e "s,^[^ ]\+ \+[0-9]\+ [0-9:]\+ [^ ]\+ thy\[[0-9]\+\]: ,,g" ${SOURCE} | \
	grep "^[^ ]\+ [0-9\-a-f:]\+\." | grep -v "^Client" >${DEST}
