/* -*- mode: c; c-file-style: "gnu" -*-
 * lru.h -- lru routines, prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of BoneHunter Libs.
 *
 * BoneHunter Libs is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 dated June,
 * 1991.
 *
 * BoneHunter Libs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file lru.h
 * LRU cache routines, prototypes.
 */

#ifndef _BHL_LRU_H
#define _BHL_LRU_H 1 /**< lru.h multi-inclusion guard. */

#include "system.h"
#include "list.h"

#include <stddef.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

/** Prototype for any LRU element-finder function.
 * The role of an LRU element-finder is to signal when an element
 * matches certain criteria.
 *
 * @param ptr is a pointer to the LRU element being checked.
 * @param size is the size of the element.
 * @param fdata is the data to search for.
 * @param fsize is the size of it.
 *
 * @returns Zero when the element does not match, non-zero otherwise.
 */
typedef int (*bhl_lru_finder_f) (const void *ptr, size_t size,
				 const void *fdata, size_t fsize);

void *bhl_lru_new (size_t max, bhl_list_free_f efree);
void bhl_lru_add (void *lru, const void *data, size_t size);
void *bhl_lru_find (void *lru, bhl_lru_finder_f finder,
		    const void *fdata, size_t fsize);
void bhl_lru_delete (void *lru, const void *data);

#endif

/* arch-tag: 78817191-2ff1-417a-91fe-6f9bb46247e1 */
