/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#include <gtk--/main.h>

#include "thoughttracker.h"
#include "filedlg.h"

#ifdef ENABLE_DEBUG
#undef DMSG 
#define DMSG cerr << "TTFileDialog::" << __FUNCTION__ << "(): "
#endif  /* ENABLE_DEBUG */

using SigC::slot;

using namespace Gtk;

//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
TTFileDialog::TTFileDialog(Gtk::Window *transient, const string &title)
  : FileSelection(title), done(0)
{
  set_transient_for(*transient);
  set_position(GTK_WIN_POS_MOUSE);

  get_ok_button()->clicked.connect(slot(this, &TTFileDialog::btn_ok));
  get_cancel_button()->clicked.connect(slot(this, &TTFileDialog::btn_cancel));
}

//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
string
TTFileDialog::run()
{
  show();
  set_modal(true);

  while (!done) Main::iteration();

  return done == 1 ? get_filename() : string("");
}

