/*
 * dev.h - a header file for dev.c
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

extern void       do_exit(void);

extern int   DEV_poll(DVI_DEVICE,DVI,int);
extern void  DEV_put_bitmap(DVI_DEVICE,DVI,DVI_BITMAP,int,long,long,long,long);
extern void  DEV_put_pixmap_rgb(DVI_DEVICE,DVI,DVI_PIXMAP_RGB,
				int,long,long,long,long);
extern void  DEV_put_graymap(DVI_DEVICE,DVI,DVI_GRAYMAP,
			     int,long,long,long,long);
extern void  DEV_put_rectangle(DVI_DEVICE,DVI,long,long,long,long);
extern void  DEV_color_rgb(DVI_DEVICE,DVI,int,double,double,double);
extern void  DEV_bgcolor_rgb(DVI_DEVICE,DVI,int,double,double,double);
extern void  DEV_color_gray(DVI_DEVICE,DVI,int,double);
extern void  DEV_bgcolor_gray(DVI_DEVICE,DVI,int,double);
extern int   DEV_draw_ps_figures(DVI_DEVICE,DVI);
extern int   DEV_before_ps_figure(DVI_DEVICE,DVI,char*,long,long,long);
extern void  DEV_after_ps_figure(DVI_DEVICE,DVI,char*,long,long,long);
extern int   DEV_special_command_undef(DVI_DEVICE,DVI,char*,long,long,long);
extern char* DEV_gs_program_path(DVI_DEVICE,DVI);
extern int   DEV_gs_timeout_value(DVI_DEVICE,DVI);
extern int   DEV_gs_timeout_giveup(DVI_DEVICE,DVI);
extern void  DEV_message_advice(DVI_DEVICE,DVI,char*,...);
extern void  DEV_message_warning(DVI_DEVICE,DVI,char*,...);
extern void  DEV_message_error(DVI_DEVICE,DVI,char*,...);
extern void  DEV_message_fatal(DVI_DEVICE,DVI,char*,...);

extern DVI_DEVICE  dvi_device_create(int,char**,int);
extern void        dvi_device_dispose(DVI_DEVICE);
extern void        dvi_device_change_visual_text(DVI_DEVICE,int);
extern void        dvi_device_change_visual_eps(DVI_DEVICE,int);


#define  RES(dev,elem)     ((RESOURCE)(dev->private1))->elem
#define  SET_RES(dev,res)              dev->private1 = (res)
#define  GET_RES(dev)       (RESOURCE)(dev->private1)

#define  XVAR(dev,elem)       ((XSTAT)(dev->private2))->elem
#define  SET_XVAR(dev,res)             dev->private2 = (res)
#define  GET_XVAR(dev)         (XSTAT)(dev->private2)

/*EOF*/
