/*  strstream.h
 *  Copyright (C) 1999-2000  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __STR_STREAM_H__
#define __STR_STREAM_H__

struct _str_stream {
  char **list;
  int    list_size;
  int    nitems;
};
typedef struct _str_stream   str_stream;

str_stream  *str_stream_open(void);

int          str_stream_add(str_stream*,char*);
int          str_stream_add_char(str_stream*,char);
int          str_stream_add_int(str_stream*,int);
char        *str_stream_compose(str_stream*);
int          str_stream_length(str_stream*);

void         str_stream_clear(str_stream*);

char        *str_stream_compose_and_close(str_stream*);
void         str_stream_close(str_stream*);

#endif /*__STR_STREAM_H__*/
