/*
 * private.h
 */

/*
 * Copyright (C) 1996-1999  Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This file is part of the DVIlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef  __DVILIB_PRIVATE_H__
#define  __DVILIB_PRIVATE_H__

#include "../config.h"
#include "spc_ps.h"
#include "spc_grf.h"


/*
 * STACK for DVI code interpreter
 */
struct stack_frame {
  long h, v, w, x, y, z, d;
};

#define VV      PD(dvi,stack)[PD(dvi,stackp)].v
#define HH      PD(dvi,stack)[PD(dvi,stackp)].h
#define WW      PD(dvi,stack)[PD(dvi,stackp)].w
#define XX      PD(dvi,stack)[PD(dvi,stackp)].x
#define YY      PD(dvi,stack)[PD(dvi,stackp)].y
#define ZZ      PD(dvi,stack)[PD(dvi,stackp)].z
#define DD      PD(dvi,stack)[PD(dvi,stackp)].d


/* 
 * Font Tabel 
 */
typedef struct s_font  *FONT;
struct s_font {
  int            opened;  /* 0: to be opened in future (lazy open), 
			     1: opened */
  char          *fname;   /* font name */
  unsigned long  fnt;     /* font ID in DVI file */
  int            fid;     /* font ID by VFlib */
  INT4           ds;      /* design size */
  INT4           ds_s;    /* scaled design size */
  double         mag;     /* magnification, = ds_s / ds */
  double         bm_mag;  /* scalling factor for bitmap */
  double         res;     /* resolution */
  FONT           prev, next;   /* links for hash table */
};

#define  FONT_OPENED_FUTURE  0
#define  FONT_OPENED         1


/*
 * Color
 */
#define COLOR_MODEL_NONE   -1
#define COLOR_MODEL_RGB     0
#define COLOR_MODEL_CMYK    1
#define COLOR_MODEL_GRAY    2
#define COLOR_MODEL_NAMED   3
extern int        dvi_color_init(DVI,DVI_DEVICE);
extern void       dvi_color_deinit(DVI,DVI_DEVICE);
extern int        dvi_color_reset_page(DVI,DVI_DEVICE,char*);
extern void       dvi_color_stack_save_page(DVI,DVI_DEVICE,int);
extern void       dvi_color_stack_restore_page(DVI,DVI_DEVICE,int);
extern void       dvi_color_stack_print(DVI,DVI_DEVICE,DVI_COLOR);
extern int        dvi_color_stack_empty(DVI dvi, DVI_DEVICE dev);
extern void       dvi_color_stack_free(DVI,DVI_DEVICE);
extern DVI_COLOR  dvi_color_stack_copy(DVI,DVI_DEVICE);
extern int        dvi_color_stack_resume(DVI,DVI_DEVICE,DVI_COLOR,char*);
extern void       dvi_color_stack_release(DVI,DVI_DEVICE,DVI_COLOR);
extern void       dvi_color_stack_elem_free(DVI,DVI_DEVICE,DVI_COLOR);
extern DVI_COLOR  dvi_color_stack_elem_copy(DVI,DVI_DEVICE,DVI_COLOR);
extern DVI_COLOR  dvi_color_stack_elem_alloc(DVI,DVI_DEVICE,char*);


/*
 * Private Data in DVI 
 */
struct private_data {
  /* Object state */
  BOOL          alive;
  /* Property */
  DVI_PROPERTY  property;
  /* User Info */
  double        shrink;
  /* DVI file */
  FILE         *dvi_file;
  char         *file_name;
  /* Info in DVI file */
  long          num, den, mag;
  double        dimen_m;    /* m  */
  double        dimen_cm;   /* cm */
  double        dimen_pt;   /* pt */
  double        dimen_in;   /* in */
  long          offset_first_page, offset_last_page;
  long          offset_fontdef;
  long          max_height, max_width;
  int           max_stack;
  /* Page table */
  long         *page_index;
  /* File Timestamp */
  long          file_timestamp1;
  long          file_timestamp2;
  /* Font */
  BOOL          font_opened;
  FONT         *font_table;
  FONT          font_lru_list;
  FONT          font;
  /* Font Cache */
  CACHE         font_cache;
  /* Context */
  unsigned long        current_fnt;
  int                  current_fid;
  struct stack_frame  *stack;
  int                  stackp;
  /* Color Stack */
  DVI_COLOR      color_stack;
  char          *color_background;
  DVI_COLOR     *color_page_stack_fg;  /* stack at the beginning of page */
  char         **color_page_bg; 
  char         **color_page_bg_hint; 
  /* graphics state (scale/rotate) */
  DVI_GSTATE_STACK   gstate_stack[DVI_GSTATE_STACK_SIZE];
  int                gstate_stack_ptr;
  int                gstate_transformed;
  double             gstate_scale_h;
  double             gstate_scale_v;
  int                gstate_angle;
  /* GhostScript interface */
  struct ps      ps_info;
  long           special_pos;  /* file position for 'special' */
};

typedef struct private_data*  PDATA;

#define PD(dvi,elem)   ((struct private_data*)dvi->privates)->elem

#endif /*__DVILIB_PRIVATE_H__*/

/*EOF*/
