/*
 * paper.c - a module for paper size
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdlib.h>
#include <stdio.h>
#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "defs.h"
#include "dev.h"
#include "resource.h"
#include "paper.h"


Public int
paper_name2id(char *name, char *ori)
{
  int  paper_id;

  paper_id = -1;
  if (strcmp(name, "B7") == 0){
    paper_id = B7_PAPER;
  } else if (strcmp(name, "B6") == 0){
    paper_id = B6_PAPER;
  } else if (strcmp(name, "B5") == 0){
    paper_id = B5_PAPER;
  } else if (strcmp(name, "B4") == 0){
    paper_id = B4_PAPER;
  } else if (strcmp(name, "B3") == 0){
    paper_id = B3_PAPER;
  } else if (strcmp(name, "B2") == 0){
    paper_id = B2_PAPER;
  } else if (strcmp(name, "B1") == 0){
    paper_id = B1_PAPER;
  } else if (strcmp(name, "A7") == 0){
    paper_id = A7_PAPER;
  } else if (strcmp(name, "A6") == 0){
    paper_id = A6_PAPER;
  } else if (strcmp(name, "A5") == 0){
    paper_id = A5_PAPER;
  } else if (strcmp(name, "A4") == 0){
    paper_id = A4_PAPER;
  } else if (strcmp(name, "A3") == 0){
    paper_id = A3_PAPER;
  } else if (strcmp(name, "A2") == 0){
    paper_id = A2_PAPER;
  } else if (strcmp(name, "A1") == 0){
    paper_id = A1_PAPER;
  } else if (strcmp(name, "LETTER") == 0){
    paper_id = LETTER_PAPER;
  } else if (strcmp(name, "US") == 0){
    paper_id = US_PAPER;
  } else if (strcmp(name, "LEGAL") == 0){
    paper_id = LEGAL_PAPER;
  } 
  if (paper_id == -1)
    return -1;

  if ((ori != NULL)
      && (   (strcmp(ori, "landscape") == 0)
	  || (strcmp(ori, "Landscape") == 0)
	  || (strcmp(ori, "LANDSCAPE") == 0)))
    paper_id = LANDSCAPE_PAPER(paper_id);

  return paper_id;
}

Public int
paper_pixel_size(int paper_id, int *wp, int *hp, double shrink)
{
  double  w, h;

  switch(paper_id){
  case A1_PAPER:   w = A1_WIDTH;  h = A1_HEIGHT; break;
  case A1L_PAPER:  w = A1_HEIGHT; h = A1_WIDTH;  break;
  case A2_PAPER:   w = A2_WIDTH;  h = A2_HEIGHT; break;
  case A2L_PAPER:  w = A2_HEIGHT; h = A2_WIDTH;  break;
  case A3_PAPER:   w = A3_WIDTH;  h = A3_HEIGHT; break;
  case A3L_PAPER:  w = A3_HEIGHT; h = A3_WIDTH;  break;
  case A4_PAPER:   w = A4_WIDTH;  h = A4_HEIGHT; break;
  case A4L_PAPER:  w = A4_HEIGHT; h = A4_WIDTH;  break;
  case A5_PAPER:   w = A5_WIDTH;  h = A5_HEIGHT; break;
  case A5L_PAPER:  w = A5_HEIGHT; h = A5_WIDTH;  break;
  case A6_PAPER:   w = A6_WIDTH;  h = A6_HEIGHT; break;
  case A6L_PAPER:  w = A6_HEIGHT; h = A6_WIDTH;  break;
  case A7_PAPER:   w = A7_WIDTH;  h = A7_HEIGHT; break;
  case A7L_PAPER:  w = A7_HEIGHT; h = A7_WIDTH;  break;
  case B1_PAPER:   w = B1_WIDTH;  h = B1_HEIGHT; break;
  case B1L_PAPER:  w = B1_HEIGHT; h = B1_WIDTH;  break;
  case B2_PAPER:   w = B2_WIDTH;  h = B2_HEIGHT; break;
  case B2L_PAPER:  w = B2_HEIGHT; h = B2_WIDTH;  break;
  case B3_PAPER:   w = B3_WIDTH;  h = B3_HEIGHT; break;
  case B3L_PAPER:  w = B3_HEIGHT; h = B3_WIDTH;  break;
  case B4_PAPER:   w = B4_WIDTH;  h = B4_HEIGHT; break;
  case B4L_PAPER:  w = B4_HEIGHT; h = B4_WIDTH;  break;
  case B5_PAPER:   w = B5_WIDTH;  h = B5_HEIGHT; break;
  case B5L_PAPER:  w = B5_HEIGHT; h = B5_WIDTH;  break;
  case B6_PAPER:   w = B6_WIDTH;  h = B6_HEIGHT; break;
  case B6L_PAPER:  w = B6_HEIGHT; h = B6_WIDTH;  break;
  case B7_PAPER:   w = B7_WIDTH;  h = B7_HEIGHT; break;
  case B7L_PAPER:  w = B7_HEIGHT; h = B7_WIDTH;  break;
  case LETTER_PAPER:  w = LETTER_WIDTH;  h = LETTER_HEIGHT; break;
  case LETTERL_PAPER: w = LETTER_HEIGHT; h = LETTER_WIDTH;  break;
  case LEGAL_PAPER:   w = LEGAL_WIDTH;   h = LEGAL_HEIGHT;  break;
  case LEGALL_PAPER:  w = LEGAL_HEIGHT;  h = LEGAL_WIDTH;   break;
  case US_PAPER:      w = US_WIDTH;      h = US_HEIGHT;     break;
  case USL_PAPER:     w = US_HEIGHT;     h = US_WIDTH;      break;
  default:
    return -1;
  }

  if ((wp == NULL) || (hp == NULL)){
    *wp = 0;
    *hp = 0;
  } else {
    *wp = w * RES(DviDev,dpi)/shrink;
    *hp = h * RES(DviDev,dpi)/shrink;
  }

  return 0;
}

/*EOF*/
