/*  strstream.c
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif
#include "strstream.h"


#define BLOCK  16

str_stream*
str_stream_open(void)
{
  str_stream *z;

  if ((z = (str_stream*)malloc(sizeof(struct _str_stream))) == NULL)
    return NULL;
  z->list = NULL;
  z->list_size = 0;
  z->nitems = 0;
  return  z;
}

void
str_stream_close(str_stream *z)
{
  int  i;

  if ((z == NULL) || (z->list == NULL))
    return;
  for (i = 0; i < z->nitems; i++)
    free(z->list[i]);
  free(z->list);
  free(z);
}

void
str_stream_clear(str_stream *z)
{
  int  i;

  if ((z == NULL) || (z->list == NULL))
    return;
  for (i = 0; i < z->nitems; i++)
    free(z->list[i]);
  free(z->list);
  z->list = NULL;
  z->list_size = 0;
  z->nitems = 0;
}

char*
str_stream_compose_and_close(str_stream *z)
{
  char *s;

  s = str_stream_compose(z);
  str_stream_close(z);
  return s;  
}

int
str_stream_add(str_stream *z, char *s)
{
  int  n;

  n = BLOCK + z->list_size;
  if (z->nitems >= z->list_size){
    z->list = realloc(z->list, sizeof(char*) * n);
    if (z->list == NULL){
      z->list_size = 0;
      return -1;
    }
    z->list_size = n;
  }
  if ((z->list[z->nitems] = (char*)malloc(strlen(s)+1)) == NULL)
    return -1;
  strcpy(z->list[z->nitems], s);
  z->nitems++;
  return 0;
}


int
str_stream_add_char(str_stream *z, char ch)
{
  char s[2];

  s[0] = ch;
  s[1] = '\0';
  return str_stream_add(z, s);
}

int
str_stream_add_int(str_stream *z, int i)
{
  char s[BUFSIZ];

  sprintf(s, "%d", i);
  return str_stream_add(z, s);
}

char*
str_stream_compose(str_stream *z)
{
  int  len, h, i;
  char  *s;

  len = str_stream_length(z);
  if ((s = (char*)malloc(len + 1)) == NULL)
    return NULL;
  h = 0;
  for (i = 0; i < z->nitems; i++){
    strcpy(&s[h], z->list[i]);
    h += strlen(z->list[i]);
  }
  return s;
}

int
str_stream_length(str_stream *z)
{
  int  len, i;

  len = 0;
  for (i = 0; i < z->nitems; i++)
    len += strlen(z->list[i]);
  return len;
}

#ifdef DEBUG
int
main(int argc, char **argv)
{
  str_stream  *z;

  z = str_stream_open();
  argc--; argv++;
  while (argc > 0){
    str_stream_add(z, *argv);
    argc--; argv++;
  }
  printf("%d %s\n", str_stream_length(z), str_stream_compose(z));
  str_stream_close(z);
  return 0;
}
#endif
