/************************************************************************/
/*									*/
/*  Manage a menu to contol the font encoding in a font selection tool.	*/
/*									*/
/************************************************************************/

#   include	"appFrameConfig.h"

#   include	<psFont.h>
#   include	<utilFontEncoding.h>

#   include	<appGuiBase.h>
#   include	<appFrame.h>

typedef struct AppEncodingMenu
    {
    AppOptionmenu	aemEncodingOptionmenu;
    APP_WIDGET		aemFontEncodingOptions[ENCODINGps_COUNT];

    int			aemFontEncodingSet;
    int			aemFontEncodingChosen;
    } AppEncodingMenu;

/************************************************************************/
/*									*/
/*  Declarations.							*/
/*									*/
/************************************************************************/

extern void appEncodingMenuSetOptionmenu(
				AppEncodingMenu *		aem,
				const SupportedCharset *	sc,
				int				enc );

extern int appEncodingMenuEncodingFromWidget(
				int *				pEnc,
				const AppEncodingMenu *		aem,
				APP_WIDGET			w );

extern void appEncodingMenuFillOptionmenu(
				char **				opts,
				APP_BUTTON_CALLBACK		callBack,
				void *				through,
				AppEncodingMenu *		aem );

extern void appEncodingMenuGetOptionTexts(
				char **				opts,
				EditApplication *		ea );

extern void appEncodingMenuAdaptToFamilyEncodings(
				AppEncodingMenu *		aem,
				const AppFontFamily *		aff );

