/************************************************************************/
/*									*/
/*  Manage paragraph properties.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>

#   include	"docParaProperties.h"

/************************************************************************/
/*									*/
/*  Initialise a tab stop.						*/
/*									*/
/************************************************************************/

void docInitTabStop(	TabStop *	ts )
    {
    ts->tsTwips= 0;
    ts->tsPixels= 0;
    ts->tsAlignment= DOCtaLEFT;
    ts->tsLeader= DOCtlNONE;
    }

/************************************************************************/
/*									*/
/*  Set a tab stop in a paragraph.					*/
/*									*/
/************************************************************************/

int docParaAddTab(		ParagraphProperties *	pp,
				const TabStop *		tsNew )
    {
    TabStop *		ts;
    int			newSize;
    int			i;

    if  ( pp->ppTabCount % 10 )
	{ newSize= pp->ppTabCount+  1; }
    else{ newSize= pp->ppTabCount+ 11; }

    newSize *= sizeof(TabStop);

    ts= (TabStop *)realloc( pp->ppTabStops, newSize );
    if  ( ! ts )
	{ LXDEB(newSize,ts); return -1; }
    pp->ppTabStops= ts;

    i= pp->ppTabCount; ts= pp->ppTabStops+ pp->ppTabCount;
    while( i > 0 && ts[-1].tsTwips > tsNew->tsTwips )
	{ ts[0]= ts[-1]; i--; ts--;	}

    *ts= *tsNew;
    pp->ppTabCount++;

    return i;
    }

/************************************************************************/
/*									*/
/*  Remove a tab stop from the ruler of a paragraph.			*/
/*									*/
/************************************************************************/

void docParaDeleteTab(	ParagraphProperties *		pp,
			int				n )
    {
    TabStop *		ts;

    if  ( n < 0 || n >= pp->ppTabCount )
	{ LLDEB(n,pp->ppTabCount); return;	}

    pp->ppTabCount--;

    ts= pp->ppTabStops+ n;
    while( n < pp->ppTabCount )
	{ ts[0]= ts[1]; ts++; n++;	}

    return;
    }

/************************************************************************/
/*									*/
/*  Manage paragraph properties.					*/
/*									*/
/************************************************************************/

void docCleanParagraphProperties(	ParagraphProperties *	pp )
    {
    if  ( pp->ppTabStops )
	{ free( pp->ppTabStops );	}
    }

void docInitParagraphProperties(	ParagraphProperties *	pp )
    {
    pp->ppTabCount= 0;
    pp->ppTabStops= (TabStop *)0;

    pp->ppFirstIndentTwips= 0;
    pp->ppLeftIndentTwips= 0;
    pp->ppRightIndentTwips= 0;

    pp->ppSpaceBeforeTwips= 0;
    pp->ppSpaceAfterTwips= 0;
    pp->ppLineSpacingTwips= 0;

    pp->ppStyle= 0;

    docInitBorderProperties( &(pp->ppTopBorder) );
    docInitBorderProperties( &(pp->ppLeftBorder) );
    docInitBorderProperties( &(pp->ppRightBorder) );
    docInitBorderProperties( &(pp->ppBottomBorder) );
    docInitBorderProperties( &(pp->ppBoxBorder) );
    docInitBorderProperties( &(pp->ppBetweenBorder) );
    docInitBorderProperties( &(pp->ppBar) );

    pp->ppOutlineLevel= 9;

    pp->ppShadingLevel= 0;
    pp->ppShadingPattern= DOCspSOLID;

    pp->ppAlignment= DOCiaLEFT;

    pp->ppStartsOnNewPage= 0;
    pp->ppInTable= 0;
    pp->ppLineSpacingIsMultiple= 0;

    pp->ppKeepOnPage= 0;
    pp->ppKeepWithNext= 0;
    pp->ppWidowControl= 0;
    pp->ppHyphenateParagraph= 0;

    pp->ppShadingForeground= 0;
    pp->ppShadingBackground= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Change paragraph properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdParaProperties(	PropertyMask *			pPpChgPask,
				ParagraphProperties *		pp,
				const PropertyMask *		ppUpdMask,
				const ParagraphProperties *	ppNew )
    {
    PropertyMask		ppChgMask;

    PROPmaskCLEAR( &ppChgMask );

    if  ( PROPmaskISSET( ppUpdMask, PPpropSTYLE ) )
	{
	if  ( pp->ppStyle != ppNew->ppStyle )
	    {
	    pp->ppStyle= ppNew->ppStyle;
	    PROPmaskADD( &ppChgMask, PPpropSTYLE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropIN_TABLE ) )
	{
	if  ( pp->ppInTable != ppNew->ppInTable )
	    {
	    pp->ppInTable= ppNew->ppInTable;
	    PROPmaskADD( &ppChgMask, PPpropIN_TABLE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropFIRST_INDENT ) )
	{
	if  ( pp->ppFirstIndentTwips != ppNew->ppFirstIndentTwips )
	    {
	    pp->ppFirstIndentTwips= ppNew->ppFirstIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropFIRST_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLEFT_INDENT ) )
	{
	if  ( pp->ppLeftIndentTwips != ppNew->ppLeftIndentTwips )
	    {
	    pp->ppLeftIndentTwips= ppNew->ppLeftIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropLEFT_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropRIGHT_INDENT ) )
	{
	if  ( pp->ppRightIndentTwips != ppNew->ppRightIndentTwips )
	    {
	    pp->ppRightIndentTwips= ppNew->ppRightIndentTwips;
	    PROPmaskADD( &ppChgMask, PPpropRIGHT_INDENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropALIGNMENT ) )
	{
	if  ( pp->ppAlignment != ppNew->ppAlignment )
	    {
	    pp->ppAlignment= ppNew->ppAlignment;
	    PROPmaskADD( &ppChgMask, PPpropALIGNMENT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropTAB_STOPS ) )
	{
	if  ( pp->ppTabCount > 0 || ppNew->ppTabCount > 0 )
	    {
	    if  ( pp->ppTabCount != ppNew->ppTabCount )
		{ PROPmaskADD( &ppChgMask, PPpropTAB_STOPS );	}

	    if  ( ppNew->ppTabCount == 0 )
		{ pp->ppTabCount= 0;	}
	    else{
		TabStop *			ts;
		TabStop *			ots;
		TabStop *			nts;
		int				tab;

		ts= (TabStop *)malloc( ppNew->ppTabCount* sizeof(TabStop) );
		if  ( ! ts )
		    { LXDEB(ppNew->ppTabCount,ts); return -1;	}

		ots= pp->ppTabStops;
		nts= ppNew->ppTabStops;
		for ( tab= 0; tab < ppNew->ppTabCount; ots++, nts++, tab++ )
		    {
		    if  ( pp->ppTabCount == ppNew->ppTabCount )
			{
			if  ( nts->tsTwips != ots->tsTwips		||
			      nts->tsAlignment != ots->tsAlignment	||
			      nts->tsLeader != ots->tsLeader		)
			    {
			    PROPmaskADD( &ppChgMask, PPpropTAB_STOPS );
			    ts[tab]= *nts;
			    }
			else{ ts[tab]= *ots;	}
			}
		    else{ ts[tab]= *nts;		}
		    }

		pp->ppTabCount= ppNew->ppTabCount;
		if  ( pp->ppTabStops )
		    { free( pp->ppTabStops );	}

		pp->ppTabStops= ts;
		}
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropNEWPAGE ) )
	{
	if  ( pp->ppStartsOnNewPage != ppNew->ppStartsOnNewPage )
	    {
	    pp->ppStartsOnNewPage= ppNew->ppStartsOnNewPage;
	    PROPmaskADD( &ppChgMask, PPpropNEWPAGE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp->ppWidowControl != ppNew->ppWidowControl )
	    {
	    pp->ppWidowControl= ppNew->ppWidowControl;
	    PROPmaskADD( &ppChgMask, PPpropWIDCTLPAR );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropKEEPN ) )
	{
	if  ( pp->ppKeepWithNext != ppNew->ppKeepWithNext )
	    {
	    pp->ppKeepWithNext= ppNew->ppKeepWithNext;
	    PROPmaskADD( &ppChgMask, PPpropKEEPN );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropKEEP ) )
	{
	if  ( pp->ppKeepOnPage != ppNew->ppKeepOnPage )
	    {
	    pp->ppKeepOnPage= ppNew->ppKeepOnPage;
	    PROPmaskADD( &ppChgMask, PPpropKEEP );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSPACE_BEFORE ) )
	{
	if  ( pp->ppSpaceBeforeTwips != ppNew->ppSpaceBeforeTwips )
	    {
	    pp->ppSpaceBeforeTwips= ppNew->ppSpaceBeforeTwips;
	    PROPmaskADD( &ppChgMask, PPpropSPACE_BEFORE );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSPACE_AFTER ) )
	{
	if  ( pp->ppSpaceAfterTwips != ppNew->ppSpaceAfterTwips )
	    {
	    pp->ppSpaceAfterTwips= ppNew->ppSpaceAfterTwips;
	    PROPmaskADD( &ppChgMask, PPpropSPACE_AFTER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLINE_SPACING_DIST ) )
	{
	if  ( pp->ppLineSpacingTwips != ppNew->ppLineSpacingTwips )
	    {
	    pp->ppLineSpacingTwips= ppNew->ppLineSpacingTwips;
	    PROPmaskADD( &ppChgMask, PPpropLINE_SPACING_DIST );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropLINE_SPACING_MULT ) )
	{
	if  ( pp->ppLineSpacingIsMultiple != ppNew->ppLineSpacingIsMultiple )
	    {
	    pp->ppLineSpacingIsMultiple= ppNew->ppLineSpacingIsMultiple;
	    PROPmaskADD( &ppChgMask, PPpropLINE_SPACING_MULT );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropTOP_BORDER ) )
	{
	if  ( docBordersDiffer( &(pp->ppTopBorder), &(ppNew->ppTopBorder) ) )
	    {
	    docCopyBorderProperties( &(pp->ppTopBorder),
						&(ppNew->ppTopBorder) );
	    PROPmaskADD( &ppChgMask, PPpropTOP_BORDER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropBOTTOM_BORDER ) )
	{
	PropertyMask	bpUpdMask;
	PropertyMask	bpChgMask;

	PROPmaskCLEAR( &bpChgMask );
	PROPmaskCLEAR( &bpUpdMask );
	PROPmaskFILL( &bpUpdMask, BRDRprop_COUNT );

	if  ( docBordersDiffer( &(pp->ppBottomBorder),
						&(ppNew->ppBottomBorder) ) )
	    {
	    docCopyBorderProperties( &(pp->ppBottomBorder),
						&(ppNew->ppBottomBorder) );
	    PROPmaskADD( &ppChgMask, PPpropBOTTOM_BORDER );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropOUTLINELEVEL ) )
	{
	if  ( pp->ppOutlineLevel != ppNew->ppOutlineLevel )
	    {
	    pp->ppOutlineLevel= ppNew->ppOutlineLevel;
	    PROPmaskADD( &ppChgMask, PPpropOUTLINELEVEL );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropHYPHPAR ) )
	{
	if  ( pp->ppHyphenateParagraph != ppNew->ppHyphenateParagraph )
	    {
	    pp->ppHyphenateParagraph= ppNew->ppHyphenateParagraph;
	    PROPmaskADD( &ppChgMask, PPpropHYPHPAR );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_LEVEL ) )
	{
	if  ( pp->ppShadingLevel != ppNew->ppShadingLevel )
	    {
	    pp->ppShadingLevel= ppNew->ppShadingLevel;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_LEVEL );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_PATTERN ) )
	{
	if  ( pp->ppShadingPattern != ppNew->ppShadingPattern )
	    {
	    pp->ppShadingPattern= ppNew->ppShadingPattern;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_PATTERN );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_FOREGROUND ) )
	{
	if  ( pp->ppShadingForeground != ppNew->ppShadingForeground )
	    {
	    pp->ppShadingForeground= ppNew->ppShadingForeground;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_FOREGROUND );
	    }
	}

    if  ( PROPmaskISSET( ppUpdMask, PPpropSHADING_BACKGROUND ) )
	{
	if  ( pp->ppShadingBackground != ppNew->ppShadingBackground )
	    {
	    pp->ppShadingBackground= ppNew->ppShadingBackground;
	    PROPmaskADD( &ppChgMask, PPpropSHADING_BACKGROUND );
	    }
	}

    *pPpChgPask= ppChgMask; return 0;
    }

/************************************************************************/
/*									*/
/*  Compare paragraph properties.					*/
/*									*/
/************************************************************************/

void docParaPropertyDifference(	PropertyMask *			pChgMask,
				const ParagraphProperties *	pp1,
				const ParagraphProperties *	pp2,
				const PropertyMask *		updMask)
    {
    PropertyMask		changedMask;

    PROPmaskCLEAR( &changedMask );

    if  ( PROPmaskISSET( updMask, PPpropSTYLE ) )
	{
	if  ( pp1->ppStyle != pp2->ppStyle )
	    { PROPmaskADD( &changedMask, PPpropSTYLE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropFIRST_INDENT ) )
	{
	if  ( pp1->ppFirstIndentTwips != pp2->ppFirstIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropFIRST_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropLEFT_INDENT ) )
	{
	if  ( pp1->ppLeftIndentTwips != pp2->ppLeftIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropLEFT_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropRIGHT_INDENT ) )
	{
	if  ( pp1->ppRightIndentTwips != pp2->ppRightIndentTwips )
	    { PROPmaskADD( &changedMask, PPpropRIGHT_INDENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropALIGNMENT ) )
	{
	if  ( pp1->ppAlignment != pp2->ppAlignment )
	    { PROPmaskADD( &changedMask, PPpropALIGNMENT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropTAB_STOPS ) )
	{
	if  ( pp1->ppTabCount > 0 || pp2->ppTabCount > 0 )
	    {
	    if  ( pp1->ppTabCount != pp2->ppTabCount )
		{ PROPmaskADD( &changedMask, PPpropTAB_STOPS );	}
	    else{
		TabStop *			ts1;
		TabStop *			ts2;
		int				tab;

		ts1= pp1->ppTabStops;
		ts2= pp2->ppTabStops;
		for ( tab= 0; tab < pp2->ppTabCount; ts1++, ts2++, tab++ )
		    {
		    if  ( ts1->tsTwips != ts2->tsTwips			||
			  ts1->tsAlignment != ts2->tsAlignment		||
			  ts1->tsLeader != ts2->tsLeader		)
			{ PROPmaskADD( &changedMask, PPpropTAB_STOPS ); }
		    }
		}
	    }
	}

    if  ( PROPmaskISSET( updMask, PPpropNEWPAGE ) )
	{
	if  ( pp1->ppStartsOnNewPage != pp2->ppStartsOnNewPage )
	    { PROPmaskADD( &changedMask, PPpropNEWPAGE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropWIDCTLPAR ) )
	{
	if  ( pp1->ppWidowControl != pp2->ppWidowControl )
	    { PROPmaskADD( &changedMask, PPpropWIDCTLPAR ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEPN ) )
	{
	if  ( pp1->ppKeepWithNext != pp2->ppKeepWithNext )
	    { PROPmaskADD( &changedMask, PPpropKEEPN ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropKEEP ) )
	{
	if  ( pp1->ppKeepOnPage != pp2->ppKeepOnPage )
	    { PROPmaskADD( &changedMask, PPpropKEEP ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSPACE_BEFORE ) )
	{
	if  ( pp1->ppSpaceBeforeTwips != pp2->ppSpaceBeforeTwips )
	    { PROPmaskADD( &changedMask, PPpropSPACE_BEFORE ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSPACE_AFTER ) )
	{
	if  ( pp1->ppSpaceAfterTwips != pp2->ppSpaceAfterTwips )
	    { PROPmaskADD( &changedMask, PPpropSPACE_AFTER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_DIST ) )
	{
	if  ( pp1->ppLineSpacingTwips != pp2->ppLineSpacingTwips )
	    { PROPmaskADD( &changedMask, PPpropLINE_SPACING_DIST ); }
	}
    if  ( PROPmaskISSET( updMask, PPpropLINE_SPACING_MULT ) )
	{
	if  ( pp1->ppLineSpacingIsMultiple != pp2->ppLineSpacingIsMultiple )
	    { PROPmaskADD( &changedMask, PPpropLINE_SPACING_MULT ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropTOP_BORDER ) )
	{
	if  ( docBordersDiffer( &(pp1->ppTopBorder), &(pp2->ppTopBorder) ) )
	    { PROPmaskADD( &changedMask, PPpropTOP_BORDER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropBOTTOM_BORDER ) )
	{
	if  ( docBordersDiffer( &(pp1->ppBottomBorder),
						&(pp2->ppBottomBorder) ) )
	    { PROPmaskADD( &changedMask, PPpropBOTTOM_BORDER ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropOUTLINELEVEL ) )
	{
	if  ( pp1->ppOutlineLevel != pp2->ppOutlineLevel )
	    { PROPmaskADD( &changedMask, PPpropOUTLINELEVEL );	}
	}

    if  ( PROPmaskISSET( updMask, PPpropHYPHPAR ) )
	{
	if  ( pp1->ppHyphenateParagraph != pp2->ppHyphenateParagraph )
	    { PROPmaskADD( &changedMask, PPpropHYPHPAR ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_LEVEL ) )
	{
	if  ( pp1->ppShadingLevel != pp2->ppShadingLevel )
	    { PROPmaskADD( &changedMask, PPpropSHADING_LEVEL ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_PATTERN ) )
	{
	if  ( pp1->ppShadingPattern != pp2->ppShadingPattern )
	    { PROPmaskADD( &changedMask, PPpropSHADING_PATTERN ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_FOREGROUND ) )
	{
	if  ( pp1->ppShadingForeground != pp2->ppShadingForeground )
	    { PROPmaskADD( &changedMask, PPpropSHADING_FOREGROUND ); }
	}

    if  ( PROPmaskISSET( updMask, PPpropSHADING_BACKGROUND ) )
	{
	if  ( pp1->ppShadingBackground != pp2->ppShadingBackground )
	    { PROPmaskADD( &changedMask, PPpropSHADING_BACKGROUND ); }
	}

    *pChgMask= changedMask;
    return;
    }

