/************************************************************************/
/*									*/
/*  Management of Border Properties.					*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	"docBorderProperties.h"

/************************************************************************/
/*									*/
/*  Initialise Border Properties.					*/
/*									*/
/************************************************************************/

void docInitBorderProperties(	BorderProperties *	bp )
    {
    bp->bpColor= 0;
    bp->bpSpacingTwips= 0;
    bp->bpPenWideTwips= 15;
    bp->bpStyle= DOCbsNONE;
    }

/************************************************************************/
/*									*/
/*  1) Are the columns in two RowProperties 'the same' (Do they align?)	*/
/*  2) All column properties identical?					*/
/*									*/
/************************************************************************/

void docBorderPropertyDifference(
				PropertyMask *			pBpUpdMask,
				const BorderProperties *	bp1,
				const BorderProperties *	bp2,
				const PropertyMask *		bpUpdMask )
    {
    PropertyMask		bpChgMask;

    PROPmaskCLEAR( &bpChgMask );

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropCOLOR ) )
	{
	if  ( bp1->bpColor != bp2->bpColor )
	    { PROPmaskADD( &bpChgMask, BRDRpropCOLOR ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropSPACING ) )
	{
	if  ( bp1->bpSpacingTwips != bp2->bpSpacingTwips )
	    { PROPmaskADD( &bpChgMask, BRDRpropSPACING ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropPEN_WIDE ) )
	{
	if  ( bp1->bpPenWideTwips != bp2->bpPenWideTwips )
	    { PROPmaskADD( &bpChgMask, BRDRpropPEN_WIDE ); }
	}

    if  ( PROPmaskISSET( bpUpdMask, BRDRpropSTYLE ) )
	{
	if  ( bp1->bpStyle != bp2->bpStyle )
	    { PROPmaskADD( &bpChgMask, BRDRpropSTYLE ); }
	}

    *pBpUpdMask= bpChgMask;
    return;
    }

int docBordersDiffer(		const BorderProperties *	bp1,
				const BorderProperties *	bp2 )
    {
    PropertyMask	bpUpdMask;
    PropertyMask	bpChgMask;

    PROPmaskCLEAR( &bpChgMask );
    PROPmaskCLEAR( &bpUpdMask );
    PROPmaskFILL( &bpUpdMask, BRDRprop_COUNT );

    docBorderPropertyDifference( &bpChgMask, bp1, bp2, &bpUpdMask );

    if  ( ! PROPmaskISEMPTY( &bpChgMask ) )
	{ return 1;	}

    return 0;
    }
