#
# dupdevs.sh
# this script takes the output of 'ls -lR' and duplicates
# all block special, character special, and soft link files
#
# Usage:  dupdevs.sh [target directory] < [output of ls -lR]
# where [target directory] is the directory in which you
# want to create nods & symlinks, and [output of ls -lR]
# is created by running 'ls -lR' in the source directory
#
# Copyright 2001 by dann frazier <dannf@dannf.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

if [ $# != 1 ]; then
    echo "Usage:  $0 <target directory>"
    exit 1
fi

base=$1
targetdir=$base

while /bin/true; do
    # excuse:  field[] is a pretty indescriptive name,
    # but the contents are shifted for different types of files
    read field[0] field[1] field[2] field[3] field[4] field[5] field[6] field[7] field[8] field[9] field[10] field[11]

    if [ $? -ne 0 ]; then
	# stdin is exhausted
	exit 0
    fi

    # ignore irrelevant lines generated by ls -lR
    if [ "${field[0]}" == "total" -o "${field[0]}" == "" ]; then
	continue
    fi
    
    type=`echo "${field[0]}" | cut -c 1`
    
    # block special & character special files
    if [ "$type" == "b" -o "$type" == "c" ]; then
	major=`echo "${field[4]}" | cut -d "," -f 1`
	mknod $targetdir/${field[9]} $type $major ${field[5]}
	if [ $? -ne 0 ]; then
	    echo "mknod failed."
	    exit 1
	fi

    # create symlinks	
    elif [ "$type" == "l" ]; then
	ln -sf ${field[10]} $targetdir/${field[8]}
	if [ $? -ne 0 ]; then
	    echo "Couldn't link $targetdir/${field[8]} to ${field[10]}"
	    exit 1
	fi

    # create directories	
    elif [ "$type" == "d" ]; then
	mkdir -p $targetdir/${field[8]}

    # created named pipes	
    elif [ "$type" == "p" ]; then
    	mknod $targetdir/${field[8]} $type

    # delve into a subdir	
    elif [ "$type" == "." ]; then
	targetdir=$base/`echo ${field[0]} | cut -d ":" -f 1`
    fi
done
