/* smd-applet.c generated by valac 0.22.0, the Vala compiler
 * generated from smd-applet.vala, do not modify */

/* Released under the terms of GPLv3 or at your option any later version.*/
/* No warranties.*/
/* Copyright Enrico Tassi <gares@fettunta.org>*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>
#include <glib/gstdio.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <gdk/gdk.h>
#include "smd-config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
typedef struct _EventPrivate EventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _event_unref0(var) ((var == NULL) ? NULL : (var = (event_unref (var), NULL)))
typedef struct _ParamSpecEvent ParamSpecEvent;

#define TYPE_SMD_APPLET (smd_applet_get_type ())
#define SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SMD_APPLET, smdApplet))
#define SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SMD_APPLET, smdAppletClass))
#define IS_SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SMD_APPLET))
#define IS_SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SMD_APPLET))
#define SMD_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SMD_APPLET, smdAppletClass))

typedef struct _smdApplet smdApplet;
typedef struct _smdAppletClass smdAppletClass;
typedef struct _smdAppletPrivate smdAppletPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	EXIT_ABORT
} Exit;
#define EXIT exit_quark ()
struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint (*get_state) (NetworkManager* self);
};

struct _Event {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventPrivate * priv;
	gchar* message;
	gchar* message_icon;
	gboolean enter_network_error_mode;
	gboolean enter_error_mode;
	gboolean transient_error_message;
	gchar* context;
	gchar* cause;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* commands;
};

struct _EventClass {
	GTypeClass parent_class;
	void (*finalize) (Event *self);
};

struct _ParamSpecEvent {
	GParamSpec parent_instance;
};

struct _smdApplet {
	GtkApplication parent_instance;
	smdAppletPrivate * priv;
};

struct _smdAppletClass {
	GtkApplicationClass parent_class;
};

struct _smdAppletPrivate {
	GtkBuilder* builder;
	GtkStatusIcon* si;
	GtkWindow* win;
	GtkWindow* err_win;
	GtkNotebook* notebook;
	GtkSwitch* sync_active;
	GtkComboBoxText* cblogs;
	GeeArrayList* lognames;
	GSettings* settings;
	GThread* thread;
	gboolean thread_die;
	GPid pid;
	GMutex events_lock;
	GeeArrayList* events;
	gboolean error_mode;
	gboolean network_error_mode;
	gboolean config_wait_mode;
	GHashTable* command_hash;
	NetworkManager* net_manager;
	NotifyNotification* notification;
	gboolean notification_server_has_persistence;
};

struct _Block1Data {
	int _ref_count_;
	smdApplet * self;
	GtkSwitch* bnotify;
	GtkSwitch* bautostart;
};


extern gboolean verbose;
gboolean verbose = FALSE;
static gpointer event_parent_class = NULL;
extern gchar* SMD_LOGS_DIR;
gchar* SMD_LOGS_DIR = NULL;
extern gchar* SMD_LOOP_CFG;
gchar* SMD_LOOP_CFG = NULL;
extern gchar* SMD_PP_DEF_CFG;
gchar* SMD_PP_DEF_CFG = NULL;
extern gchar* XDG_AUTORUN_FILE;
gchar* XDG_AUTORUN_FILE = NULL;
static gpointer smd_applet_parent_class = NULL;
extern gchar* smd_applet_smd_loop_cmd;
gchar* smd_applet_smd_loop_cmd = NULL;
extern gchar* smd_applet_smd_applet_ui;
gchar* smd_applet_smd_applet_ui = NULL;
extern gchar* smd_applet_smd_push_cmd;
gchar* smd_applet_smd_push_cmd = NULL;
extern gchar* smd_applet_smd_applet_desktop;
gchar* smd_applet_smd_applet_desktop = NULL;
static gchar* smd_applet_menu_ui;
static gchar* smd_applet_menu_ui = NULL;

GQuark exit_quark (void);
void debug (const gchar* message);
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint network_manager_get_state (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint network_manager_dbus_proxy_get_state (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_state (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
#define NM_SERVICE "org.freedesktop.NetworkManager"
#define NM_PATH "/org/freedesktop/NetworkManager"
gboolean is_nm_connected (guint code);
gpointer event_ref (gpointer instance);
void event_unref (gpointer instance);
GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event (GValue* value, gpointer v_object);
void value_take_event (GValue* value, gpointer v_object);
gpointer value_get_event (const GValue* value);
GType event_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_DUMMY_PROPERTY
};
Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands);
Event* event_new (void);
Event* event_construct (GType object_type);
Event* event_generic_error (const gchar* cause);
Event* event_network_error (void);
Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails);
gboolean event_is_error_event (Event* self);
static void event_finalize (Event* obj);
#define SMD_LOOP "/bin/smd-loop"
#define SMD_PUSH "/bin/smd-push"
#define SMD_APPLET_UI "/share/syncmaildir-applet/smd-applet.ui"
#define SMD_APPLET_DESKTOP "/share/applications/smd-applet.desktop"
#define GNOME_AUTOSTART_DISABLED "X-GNOME-Autostart-enabled=false"
GType smd_applet_get_type (void) G_GNUC_CONST;
#define SMD_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SMD_APPLET, smdAppletPrivate))
enum  {
	SMD_APPLET_DUMMY_PROPERTY
};
#define SMD_APPLET_key_newmail "notify-new-mail"
smdApplet* smd_applet_new (GError** error);
smdApplet* smd_applet_construct (GType object_type, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (smdApplet* self, guint s);
static void ____lambda2__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self);
static void smd_applet_update_logcontents (smdApplet* self);
static void __lambda3_ (Block1Data* _data1_);
static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void smd_applet_close_err_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda6_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_loop_configured (smdApplet* self);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda7_ (smdApplet* self, GtkButton* b);
static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (smdApplet* self);
static void smd_applet_unpause (smdApplet* self);
static void smd_applet_pause (smdApplet* self);
static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void smd_applet_update_loglist (smdApplet* self);
static gboolean __lambda9_ (smdApplet* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static void __lambda10_ (smdApplet* self, GtkStatusIcon* s);
static void ___lambda10__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void __lambda11_ (smdApplet* self);
static void ___lambda11__g_application_activate (GApplication* _sender, gpointer self);
static void __lambda12_ (smdApplet* self);
static void ___lambda12__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void* smd_applet_smdThread (smdApplet* self);
static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error);
static void smd_applet_start_smdThread (smdApplet* self, gboolean force);
static gpointer _smd_applet_smdThread_gthread_func (gpointer self);
static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error);
static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s);
static void ___lambda5_ (smdApplet* self);
static void ____lambda5__gspawn_child_setup_func (gpointer self);
static gboolean smd_applet_eat_event (smdApplet* self);
static void ______lambda13_ (smdApplet* self, NotifyNotification* not, const gchar* action);
static void _______lambda13__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void ______lambda14_ (smdApplet* self, GtkButton* b);
static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force);
static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e);
static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e);
static void smd_applet_close_prefs (smdApplet* self);
static gboolean smd_applet_is_smd_stack_configured (smdApplet* self);
void smd_applet_start (smdApplet* self, GError** error);
static gboolean _smd_applet_eat_event_gsource_func (gpointer self);
static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void ___lambda15_ (smdApplet* self, NotifyNotification* n, const gchar* a);
static void ____lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void smd_applet_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};

GQuark exit_quark (void) {
	return g_quark_from_static_string ("exit-quark");
}


void debug (const gchar* message) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (message != NULL);
	_tmp0_ = verbose;
	if (_tmp0_) {
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = message;
		fprintf (_tmp1_, "DEBUG: %s\n", _tmp2_);
	}
}


guint network_manager_get_state (NetworkManager* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_state (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) network_manager_proxy_get_type);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.NetworkManager");
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) network_manager_register_object);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) )
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint state = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed ((NetworkManager*) proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint network_manager_dbus_proxy_get_state (NetworkManager* self) {
	GVariant *_inner_reply;
	guint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_state = network_manager_dbus_proxy_get_state;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_network_manager_get_state (NetworkManager* self) {
	guint result;
	GVariant* _reply;
	result = network_manager_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_state (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_network_manager_dbus_interface_info), &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_network_manager_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gboolean is_nm_connected (guint code) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gboolean _tmp3_ = FALSE;
	_tmp1_ = code;
	if (_tmp1_ == ((guint) 3)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_ = 0U;
		_tmp2_ = code;
		_tmp0_ = _tmp2_ == ((guint) 70);
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (cause != NULL, NULL);
	g_return_val_if_fail (commands != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("An error occurred, click on the icon for more details");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("error");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_error_mode = TRUE;
	_tmp3_ = cause;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (e->cause);
	e->cause = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (e->context);
	e->context = _tmp6_;
	_tmp7_ = permissions;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (e->permissions);
	e->permissions = _tmp8_;
	_tmp9_ = mail_name;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (e->mail_name);
	e->mail_name = _tmp10_;
	_tmp11_ = mail_body;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (e->mail_body);
	e->mail_body = _tmp12_;
	_tmp13_ = commands;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (e->commands);
	e->commands = _tmp14_;
	result = e;
	return result;
}


Event* event_generic_error (const gchar* cause) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (cause != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = cause;
	_tmp2_ = g_strconcat ("A failure occurred: ", _tmp1_, NULL);
	_g_free0 (e->message);
	e->message = _tmp2_;
	_tmp3_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp3_;
	e->transient_error_message = TRUE;
	result = e;
	return result;
}


Event* event_network_error (void) {
	Event* result = NULL;
	Event* e = NULL;
	Event* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("A persistent network failure occurred");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_network_error_mode = TRUE;
	result = e;
	return result;
}


Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails) {
	Event* result = NULL;
	gchar* preamble = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Event* e = NULL;
	Event* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = g_strdup_printf ("Synchronize with %s:\n", _tmp0_);
	preamble = _tmp1_;
	_tmp2_ = event_new ();
	e = _tmp2_;
	_tmp4_ = new_mails;
	if (_tmp4_ > 0) {
		gint _tmp5_ = 0;
		_tmp5_ = del_mails;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		Event* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		_tmp7_ = e;
		_tmp8_ = preamble;
		_tmp9_ = new_mails;
		_tmp10_ = del_mails;
		_tmp11_ = g_strdup_printf ("%s%d new messages\n%d deleted messages", _tmp8_, _tmp9_, _tmp10_);
		_g_free0 (_tmp7_->message);
		_tmp7_->message = _tmp11_;
	} else {
		gint _tmp12_ = 0;
		_tmp12_ = new_mails;
		if (_tmp12_ > 0) {
			Event* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gchar* _tmp16_ = NULL;
			_tmp13_ = e;
			_tmp14_ = preamble;
			_tmp15_ = new_mails;
			_tmp16_ = g_strdup_printf ("%s%d new messages", _tmp14_, _tmp15_);
			_g_free0 (_tmp13_->message);
			_tmp13_->message = _tmp16_;
		} else {
			Event* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
			_tmp17_ = e;
			_tmp18_ = preamble;
			_tmp19_ = del_mails;
			_tmp20_ = g_strdup_printf ("%s%d deleted messages", _tmp18_, _tmp19_);
			_g_free0 (_tmp17_->message);
			_tmp17_->message = _tmp20_;
		}
	}
	result = e;
	_g_free0 (preamble);
	return result;
}


gboolean event_is_error_event (Event* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->enter_error_mode;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->enter_network_error_mode;
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->transient_error_message;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	result = _tmp6_;
	return result;
}


Event* event_construct (GType object_type) {
	Event* self = NULL;
	self = (Event*) g_type_create_instance (object_type);
	return self;
}


Event* event_new (void) {
	return event_construct (TYPE_EVENT);
}


static void value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		event_unref (value->data[0].v_pointer);
	}
}


static void value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Event* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Event** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


void value_take_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


static void event_class_init (EventClass * klass) {
	event_parent_class = g_type_class_peek_parent (klass);
	EVENT_CLASS (klass)->finalize = event_finalize;
}


static void event_instance_init (Event * self) {
	gchar* _tmp0_ = NULL;
	self->message = NULL;
	_tmp0_ = g_strdup ("gtk-about");
	self->message_icon = _tmp0_;
	self->enter_network_error_mode = FALSE;
	self->enter_error_mode = FALSE;
	self->transient_error_message = FALSE;
	self->context = NULL;
	self->cause = NULL;
	self->permissions = NULL;
	self->mail_name = NULL;
	self->mail_body = NULL;
	self->commands = NULL;
	self->ref_count = 1;
}


static void event_finalize (Event* obj) {
	Event * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT, Event);
	_g_free0 (self->message);
	_g_free0 (self->message_icon);
	_g_free0 (self->context);
	_g_free0 (self->cause);
	_g_free0 (self->permissions);
	_g_free0 (self->mail_name);
	_g_free0 (self->mail_body);
	_g_object_unref0 (self->commands);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_init, value_event_free_value, value_event_copy_value, value_event_peek_pointer, "p", value_event_collect_value, "p", value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_type_id;
		event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Event", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


gpointer event_ref (gpointer instance) {
	Event* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void event_unref (gpointer instance) {
	Event* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		smdApplet * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->bautostart);
		_g_object_unref0 (_data1_->bnotify);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (smdApplet* self, guint s) {
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = s;
	_tmp1_ = is_nm_connected (_tmp0_);
	if (_tmp1_) {
		GtkSwitch* _tmp2_ = NULL;
		_tmp2_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp2_, TRUE);
	} else {
		GtkSwitch* _tmp3_ = NULL;
		_tmp3_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp3_, FALSE);
	}
}


static void ____lambda2__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self) {
	___lambda2_ (self, state);
}


static void __lambda3_ (Block1Data* _data1_) {
	smdApplet * self;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = _data1_->self;
	_tmp0_ = self->priv->settings;
	_tmp1_ = gtk_switch_get_active (_data1_->bnotify);
	_tmp2_ = _tmp1_;
	g_settings_set_boolean (_tmp0_, SMD_APPLET_key_newmail, _tmp2_);
}


static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda3_ (self);
}


static void __lambda4_ (Block1Data* _data1_) {
	smdApplet * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = gtk_switch_get_active (_data1_->bautostart);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* content = NULL;
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp2_ = smd_applet_smd_applet_desktop;
			g_file_get_contents (_tmp2_, &_tmp3_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp4_ = XDG_AUTORUN_FILE;
			_tmp5_ = content;
			g_file_set_contents (_tmp4_, _tmp5_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch5_g_file_error;
				}
				_g_free0 (content);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally5;
		__catch5_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = stderr;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "%s\n", _tmp8_);
			_g_error_free0 (e);
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
	} else {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = XDG_AUTORUN_FILE;
		g_remove (_tmp9_);
	}
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ (self);
}


static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_err_action (self, _sender);
}


static void __lambda6_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		gchar* cmd = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp0_ = smd_applet_is_smd_loop_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = smd_applet_smd_loop_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch6_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_LOOP_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_loop_configured (self);
		_g_free0 (cmd);
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda6_ (self, _sender);
}


static void __lambda7_ (smdApplet* self, GtkButton* b) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	{
		gboolean _tmp0_ = FALSE;
		gchar* cmd = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp0_ = smd_applet_is_smd_pushpull_configured (self);
		if (!_tmp0_) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = smd_applet_smd_push_cmd;
			_tmp2_ = g_strdup_printf ("%s -t", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error_);
			_g_free0 (_tmp3_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch7_g_spawn_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = SMD_PP_DEF_CFG;
		_tmp5_ = g_strdup_printf ("gnome-open %s", _tmp4_);
		cmd = _tmp5_;
		_tmp6_ = cmd;
		g_spawn_command_line_async (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		smd_applet_is_smd_pushpull_configured (self);
		_g_free0 (cmd);
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda7_ (self, _sender);
}


static void __lambda8_ (smdApplet* self) {
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = self->priv->sync_active;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	if (_tmp1_) {
		smd_applet_unpause (self);
	} else {
		smd_applet_pause (self);
	}
}


static void ___lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda8_ (self);
}


static gboolean __lambda9_ (smdApplet* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->win;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		smd_applet_update_loglist (self);
		smd_applet_update_logcontents (self);
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
	return result;
}


static void __lambda10_ (smdApplet* self, GtkStatusIcon* s) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->err_win;
		gtk_window_reshow_with_initial_size (_tmp1_);
	} else {
		GtkWindow* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->win;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->config_wait_mode;
		if (_tmp3_) {
			GtkNotebook* _tmp4_ = NULL;
			_tmp4_ = self->priv->notebook;
			g_object_set (_tmp4_, "page", 1, NULL);
		} else {
			GtkNotebook* _tmp5_ = NULL;
			_tmp5_ = self->priv->notebook;
			g_object_set (_tmp5_, "page", 0, NULL);
		}
	}
}


static void ___lambda10__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	__lambda10_ (self, _sender);
}


static void __lambda11_ (smdApplet* self) {
}


static void ___lambda11__g_application_activate (GApplication* _sender, gpointer self) {
	__lambda11_ (self);
}


static void __lambda12_ (smdApplet* self) {
	GPid _tmp0_ = 0;
	self->priv->thread_die = TRUE;
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GPid _tmp4_ = 0;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	g_application_quit ((GApplication*) self);
}


static void ___lambda12__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda12_ (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


smdApplet* smd_applet_construct (GType object_type, GError** error) {
	smdApplet * self = NULL;
	Block1Data* _data1_;
	GtkBuilder* _tmp3_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GSettings* _tmp20_ = NULL;
	GtkWindow* simple_mainwin = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkWindow* _tmp29_ = NULL;
	GtkApplicationWindow* _tmp30_ = NULL;
	GtkWidget* _tmp31_ = NULL;
	GtkWindow* _tmp32_ = NULL;
	gint w = 0;
	gint h = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	GtkWindow* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	GtkWindow* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GtkBuilder* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	GtkWindow* _tmp42_ = NULL;
	GtkLabel* lcopyright = NULL;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkGrid* logs_vb = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkGrid* _tmp48_ = NULL;
	GtkComboBoxText* _tmp49_ = NULL;
	GeeArrayList* _tmp50_ = NULL;
	GtkComboBoxText* _tmp51_ = NULL;
	GtkComboBoxText* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	GObject* _tmp54_ = NULL;
	GtkSwitch* _tmp55_ = NULL;
	GSettings* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkSwitch* _tmp60_ = NULL;
	GtkButton* bc = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkButton* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkButton* bel = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	GtkButton* _tmp76_ = NULL;
	GtkButton* bepp = NULL;
	GtkBuilder* _tmp77_ = NULL;
	GObject* _tmp78_ = NULL;
	GtkButton* _tmp79_ = NULL;
	GtkButton* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	GObject* _tmp82_ = NULL;
	GtkSwitch* _tmp83_ = NULL;
	GtkSwitch* _tmp84_ = NULL;
	GtkBuilder* _tmp85_ = NULL;
	GObject* _tmp86_ = NULL;
	GtkNotebook* _tmp87_ = NULL;
	GtkStatusIcon* _tmp88_ = NULL;
	GtkStatusIcon* _tmp89_ = NULL;
	GtkStatusIcon* _tmp90_ = NULL;
	GtkStatusIcon* _tmp91_ = NULL;
	GtkWindow* _tmp92_ = NULL;
	GSimpleAction* quit = NULL;
	GSimpleAction* _tmp93_ = NULL;
	GMenuModel* menu = NULL;
	GtkBuilder* _tmp94_ = NULL;
	GObject* _tmp95_ = NULL;
	GMenuModel* _tmp96_ = NULL;
	GMenuModel* _tmp97_ = NULL;
	GSimpleAction* _tmp98_ = NULL;
	GSimpleAction* _tmp99_ = NULL;
	GList* l = NULL;
	GList* _tmp100_ = NULL;
	GList* _tmp101_ = NULL;
	gint _tmp102_ = 0;
	GHashFunc _tmp103_ = NULL;
	GEqualFunc _tmp104_ = NULL;
	GHashTable* _tmp105_ = NULL;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (smdApplet*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	g_application_set_application_id ((GApplication*) self, "org.syncmaildir");
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "%s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp3_;
	{
		GtkBuilder* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->builder;
		_tmp5_ = smd_applet_smd_applet_ui;
		gtk_builder_add_from_file (_tmp4_, _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_tmp9_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the ui file");
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GtkBuilder* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp10_ = self->priv->builder;
		_tmp11_ = smd_applet_menu_ui;
		_tmp12_ = smd_applet_menu_ui;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_builder_add_from_string (_tmp10_, _tmp11_, (gsize) _tmp14_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "%s\n", _tmp17_);
		_tmp18_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the menu ui string");
		_inner_error_ = _tmp18_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) event_ref, event_unref, NULL);
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp19_;
	_tmp20_ = g_settings_new ("org.syncmaildir.applet");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp20_;
	{
		NetworkManager* _tmp21_ = NULL;
		NetworkManager* _tmp22_ = NULL;
		NetworkManager* _tmp23_ = NULL;
		_tmp22_ = g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", NM_SERVICE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", NM_PATH, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
		_tmp21_ = (NetworkManager*) _tmp22_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = _tmp21_;
		_tmp23_ = self->priv->net_manager;
		g_signal_connect_object (_tmp23_, "state-changed", (GCallback) ____lambda2__network_manager_state_changed, self, 0);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = stderr;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		fprintf (_tmp24_, "%s\n", _tmp26_);
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = self->priv->builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "wMain");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp28_) : NULL);
	simple_mainwin = _tmp29_;
	_tmp30_ = (GtkApplicationWindow*) gtk_application_window_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->win);
	self->priv->win = (GtkWindow*) _tmp30_;
	_tmp31_ = gtk_bin_get_child ((GtkBin*) simple_mainwin);
	_tmp32_ = self->priv->win;
	gtk_widget_reparent (_tmp31_, (GtkWidget*) _tmp32_);
	w = 0;
	h = 0;
	gtk_widget_get_size_request ((GtkWidget*) simple_mainwin, &_tmp33_, &_tmp34_);
	w = _tmp33_;
	h = _tmp34_;
	_tmp35_ = self->priv->win;
	_tmp36_ = w;
	_tmp37_ = h;
	gtk_widget_set_size_request ((GtkWidget*) _tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = self->priv->win;
	_tmp39_ = gtk_window_get_title (simple_mainwin);
	gtk_window_set_title (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "wError");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp41_) : NULL);
	_g_object_unref0 (self->priv->err_win);
	self->priv->err_win = _tmp42_;
	_tmp43_ = self->priv->builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "lCopyright");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp44_) : NULL);
	lcopyright = _tmp45_;
	gtk_label_set_text (lcopyright, "Copyright " SMD_CONF_COPYRIGHT);
	_tmp46_ = self->priv->builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "vbLog");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp47_) : NULL);
	logs_vb = _tmp48_;
	_tmp49_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->cblogs);
	self->priv->cblogs = _tmp49_;
	_tmp50_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->lognames);
	self->priv->lognames = _tmp50_;
	_tmp51_ = self->priv->cblogs;
	gtk_grid_attach (logs_vb, (GtkWidget*) _tmp51_, 0, 0, 1, 1);
	_tmp52_ = self->priv->cblogs;
	gtk_widget_show ((GtkWidget*) _tmp52_);
	smd_applet_update_logcontents (self);
	_tmp53_ = self->priv->builder;
	_tmp54_ = gtk_builder_get_object (_tmp53_, "sNotify");
	_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, GTK_TYPE_SWITCH) ? ((GtkSwitch*) _tmp54_) : NULL);
	_data1_->bnotify = _tmp55_;
	_tmp56_ = self->priv->settings;
	_tmp57_ = g_settings_get_boolean (_tmp56_, SMD_APPLET_key_newmail);
	gtk_switch_set_active (_data1_->bnotify, _tmp57_);
	g_signal_connect_data ((GObject*) _data1_->bnotify, "notify::active", (GCallback) ___lambda3__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp58_ = self->priv->builder;
	_tmp59_ = gtk_builder_get_object (_tmp58_, "sAutostart");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, GTK_TYPE_SWITCH) ? ((GtkSwitch*) _tmp59_) : NULL);
	_data1_->bautostart = _tmp60_;
	{
		gchar* content = NULL;
		gboolean _tmp61_ = FALSE;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		_tmp62_ = XDG_AUTORUN_FILE;
		_tmp64_ = g_file_get_contents (_tmp62_, &_tmp63_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp63_;
		_tmp61_ = _tmp64_;
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (content);
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		if (_tmp61_) {
			gboolean _tmp65_ = FALSE;
			_tmp65_ = g_regex_match_simple (GNOME_AUTOSTART_DISABLED, content, 0, 0);
			if (_tmp65_) {
				gtk_switch_set_active (_data1_->bautostart, FALSE);
			} else {
				gtk_switch_set_active (_data1_->bautostart, TRUE);
			}
		} else {
			gtk_switch_set_active (_data1_->bautostart, FALSE);
		}
		_g_free0 (content);
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp66_ = NULL;
		GError* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp66_ = stderr;
		_tmp67_ = e;
		_tmp68_ = _tmp67_->message;
		fprintf (_tmp66_, "%s\n", _tmp68_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (logs_vb);
			_g_object_unref0 (lcopyright);
			_g_object_unref0 (simple_mainwin);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect_data ((GObject*) _data1_->bautostart, "notify::active", (GCallback) ___lambda4__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp69_ = self->priv->builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "bClose");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp70_) : NULL);
	bc = _tmp71_;
	_tmp72_ = bc;
	g_signal_connect_object (_tmp72_, "clicked", (GCallback) _smd_applet_close_err_action_gtk_button_clicked, self, 0);
	_tmp73_ = self->priv->builder;
	_tmp74_ = gtk_builder_get_object (_tmp73_, "bEditLoopCfg");
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp74_) : NULL);
	bel = _tmp75_;
	_tmp76_ = bel;
	g_signal_connect_object (_tmp76_, "clicked", (GCallback) ___lambda6__gtk_button_clicked, self, 0);
	_tmp77_ = self->priv->builder;
	_tmp78_ = gtk_builder_get_object (_tmp77_, "bEditPushPullCfg");
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp78_) : NULL);
	bepp = _tmp79_;
	_tmp80_ = bepp;
	g_signal_connect_object (_tmp80_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp81_ = self->priv->builder;
	_tmp82_ = gtk_builder_get_object (_tmp81_, "sSyncActive");
	_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, GTK_TYPE_SWITCH) ? ((GtkSwitch*) _tmp82_) : NULL);
	_g_object_unref0 (self->priv->sync_active);
	self->priv->sync_active = _tmp83_;
	_tmp84_ = self->priv->sync_active;
	g_signal_connect_object ((GObject*) _tmp84_, "notify::active", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp85_ = self->priv->builder;
	_tmp86_ = gtk_builder_get_object (_tmp85_, "nMain");
	_tmp87_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, GTK_TYPE_NOTEBOOK) ? ((GtkNotebook*) _tmp86_) : NULL);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp87_;
	smd_applet_update_loglist (self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
	_tmp88_ = gtk_status_icon_new_from_icon_name ("mail-send-receive");
	_g_object_unref0 (self->priv->si);
	self->priv->si = _tmp88_;
	_tmp89_ = self->priv->si;
	gtk_status_icon_set_visible (_tmp89_, TRUE);
	_tmp90_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp90_, "smd-applet is running");
	_tmp91_ = self->priv->si;
	g_signal_connect_object (_tmp91_, "activate", (GCallback) ___lambda10__gtk_status_icon_activate, self, 0);
	_tmp92_ = self->priv->win;
	gtk_application_add_window ((GtkApplication*) self, _tmp92_);
	g_signal_connect_object ((GApplication*) self, "activate", (GCallback) ___lambda11__g_application_activate, self, 0);
	_tmp93_ = g_simple_action_new ("quit", NULL);
	quit = _tmp93_;
	_tmp94_ = self->priv->builder;
	_tmp95_ = gtk_builder_get_object (_tmp94_, "app-menu");
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp95_) : NULL);
	menu = _tmp96_;
	_tmp97_ = menu;
	gtk_application_set_app_menu ((GtkApplication*) self, _tmp97_);
	_tmp98_ = quit;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp98_);
	_tmp99_ = quit;
	g_signal_connect_object (_tmp99_, "activate", (GCallback) ___lambda12__g_simple_action_activate, self, 0);
	_tmp100_ = notify_get_server_caps ();
	l = _tmp100_;
	_tmp101_ = l;
	_tmp102_ = g_list_index (_tmp101_, "persistence");
	self->priv->notification_server_has_persistence = 0 <= _tmp102_;
	_tmp103_ = g_direct_hash;
	_tmp104_ = g_str_equal;
	_tmp105_ = g_hash_table_new_full (_tmp103_, _tmp104_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->command_hash);
	self->priv->command_hash = _tmp105_;
	_g_object_unref0 (menu);
	_g_object_unref0 (quit);
	_g_object_unref0 (bepp);
	_g_object_unref0 (bel);
	_g_object_unref0 (bc);
	_g_object_unref0 (logs_vb);
	_g_object_unref0 (lcopyright);
	_g_object_unref0 (simple_mainwin);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}


smdApplet* smd_applet_new (GError** error) {
	return smd_applet_construct (TYPE_SMD_APPLET, error);
}


static void* smd_applet_smdThread (smdApplet* self) {
	void* result = NULL;
	gboolean rc = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rc = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = rc;
		if (_tmp1_) {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->thread_die;
			_tmp0_ = !_tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
		debug ("(re)starting smd-loop");
		{
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			_tmp5_ = smd_applet_run_smd_loop (self, &_inner_error_);
			_tmp4_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == EXIT) {
					goto __catch8_exit;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			rc = _tmp4_;
		}
		goto __finally8;
		__catch8_exit:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			rc = FALSE;
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}


static gpointer _smd_applet_smdThread_gthread_func (gpointer self) {
	gpointer result;
	result = smd_applet_smdThread (self);
	g_object_unref (self);
	return result;
}


static void smd_applet_start_smdThread (smdApplet* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = force;
	if (!_tmp2_) {
		NetworkManager* _tmp3_ = NULL;
		_tmp3_ = self->priv->net_manager;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		NetworkManager* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->priv->net_manager;
		_tmp6_ = network_manager_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = is_nm_connected (_tmp7_);
		_tmp0_ = !_tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		GtkSwitch* _tmp10_ = NULL;
		GtkStatusIcon* _tmp11_ = NULL;
		_tmp10_ = self->priv->sync_active;
		gtk_switch_set_active (_tmp10_, FALSE);
		_tmp11_ = self->priv->si;
		gtk_status_icon_set_from_stock (_tmp11_, "gtk-media-pause");
	} else {
		GThread* _tmp12_ = NULL;
		_tmp12_ = g_thread_new (NULL, _smd_applet_smdThread_gthread_func, g_object_ref (self));
		_g_thread_unref0 (self->priv->thread);
		self->priv->thread = _tmp12_;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error) {
	gboolean result = FALSE;
	GRegex* context = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* cause = NULL;
	GRegex* _tmp1_ = NULL;
	GRegex* human = NULL;
	GRegex* _tmp2_ = NULL;
	GRegex* actions = NULL;
	GRegex* _tmp3_ = NULL;
	GMatchInfo* i_ctx = NULL;
	GMatchInfo* i_cause = NULL;
	GMatchInfo* i_human = NULL;
	GMatchInfo* i_act = NULL;
	GRegex* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GRegex* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GMatchInfo* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GRegex* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GMatchInfo* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean has_actions = FALSE;
	GRegex* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GMatchInfo* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GMatchInfo* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GMatchInfo* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gchar* permissions = NULL;
	gchar* mail_name = NULL;
	gchar* mail_body = NULL;
	GeeArrayList* commands = NULL;
	GEqualFunc _tmp56_ = NULL;
	GeeArrayList* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	GeeArrayList* _tmp131_ = NULL;
	GeeArrayList* _tmp132_ = NULL;
	gint _tmp133_ = 0;
	gint _tmp134_ = 0;
	const gchar* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	GMatchInfo* _tmp137_ = NULL;
	gchar* _tmp138_ = NULL;
	gchar* _tmp139_ = NULL;
	GMatchInfo* _tmp140_ = NULL;
	gchar* _tmp141_ = NULL;
	gchar* _tmp142_ = NULL;
	const gchar* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	const gchar* _tmp145_ = NULL;
	GeeArrayList* _tmp146_ = NULL;
	Event* _tmp147_ = NULL;
	Event* _tmp148_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_tmp0_ = g_regex_new ("context\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	context = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp1_ = g_regex_new ("probable-cause\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	cause = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = g_regex_new ("human-intervention\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	human = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp3_ = g_regex_new ("suggested-actions\\((.*)\\) *$", 0, 0, &_inner_error_);
	actions = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	i_ctx = NULL;
	i_cause = NULL;
	i_human = NULL;
	i_act = NULL;
	_tmp4_ = context;
	_tmp5_ = args;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_unref0 (i_ctx);
	i_ctx = _tmp6_;
	if (!_tmp7_) {
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = args;
		fprintf (_tmp8_, "smd-loop error with no context: %s\n", _tmp9_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp10_ = cause;
	_tmp11_ = args;
	_tmp13_ = g_regex_match (_tmp10_, _tmp11_, 0, &_tmp12_);
	_g_match_info_unref0 (i_cause);
	i_cause = _tmp12_;
	if (!_tmp13_) {
		FILE* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = args;
		fprintf (_tmp14_, "smd-loop error with no cause: %s\n", _tmp15_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp16_ = human;
	_tmp17_ = args;
	_tmp19_ = g_regex_match (_tmp16_, _tmp17_, 0, &_tmp18_);
	_g_match_info_unref0 (i_human);
	i_human = _tmp18_;
	if (!_tmp19_) {
		FILE* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = args;
		fprintf (_tmp20_, "smd-loop error with no human: %s\n", _tmp21_);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp22_ = actions;
	_tmp23_ = args;
	_tmp25_ = g_regex_match (_tmp22_, _tmp23_, 0, &_tmp24_);
	_g_match_info_unref0 (i_act);
	i_act = _tmp24_;
	has_actions = _tmp25_;
	_tmp27_ = i_human;
	_tmp28_ = g_match_info_fetch (_tmp27_, 1);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strcmp0 (_tmp29_, "necessary") != 0;
	_g_free0 (_tmp29_);
	if (_tmp30_) {
		GMatchInfo* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp31_ = i_cause;
		_tmp32_ = g_match_info_fetch (_tmp31_, 1);
		_tmp33_ = _tmp32_;
		_tmp26_ = g_strcmp0 (_tmp33_, "network") == 0;
		_g_free0 (_tmp33_);
	} else {
		_tmp26_ = FALSE;
	}
	_tmp34_ = _tmp26_;
	if (_tmp34_) {
		GeeArrayList* _tmp35_ = NULL;
		GeeArrayList* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		Event* _tmp39_ = NULL;
		Event* _tmp40_ = NULL;
		g_mutex_lock (&self->priv->events_lock);
		_tmp35_ = self->priv->events;
		_tmp36_ = self->priv->events;
		_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = event_network_error ();
		_tmp40_ = _tmp39_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp35_, _tmp38_, _tmp40_);
		_event_unref0 (_tmp40_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp41_ = i_human;
	_tmp42_ = g_match_info_fetch (_tmp41_, 1);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strcmp0 (_tmp43_, "necessary") != 0;
	_g_free0 (_tmp43_);
	if (_tmp44_) {
		FILE* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		GeeArrayList* _tmp47_ = NULL;
		GeeArrayList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		GMatchInfo* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		Event* _tmp54_ = NULL;
		Event* _tmp55_ = NULL;
		_tmp45_ = stderr;
		_tmp46_ = args;
		fprintf (_tmp45_, "smd-loop giving an avoidable error: %s\n", _tmp46_);
		g_mutex_lock (&self->priv->events_lock);
		_tmp47_ = self->priv->events;
		_tmp48_ = self->priv->events;
		_tmp49_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = i_cause;
		_tmp52_ = g_match_info_fetch (_tmp51_, 1);
		_tmp53_ = _tmp52_;
		_tmp54_ = event_generic_error (_tmp53_);
		_tmp55_ = _tmp54_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp47_, _tmp50_, _tmp55_);
		_event_unref0 (_tmp55_);
		_g_free0 (_tmp53_);
		g_mutex_unlock (&self->priv->events_lock);
		result = TRUE;
		_g_match_info_unref0 (i_act);
		_g_match_info_unref0 (i_human);
		_g_match_info_unref0 (i_cause);
		_g_match_info_unref0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	permissions = NULL;
	mail_name = NULL;
	mail_body = NULL;
	_tmp56_ = g_str_equal;
	_tmp57_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp56_);
	commands = _tmp57_;
	_tmp58_ = has_actions;
	if (_tmp58_) {
		gchar* acts = NULL;
		GMatchInfo* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		GRegex* r_perm = NULL;
		GRegex* _tmp61_ = NULL;
		GRegex* r_mail = NULL;
		GRegex* _tmp62_ = NULL;
		GRegex* r_cmd = NULL;
		GRegex* _tmp63_ = NULL;
		gint from = 0;
		_tmp59_ = i_act;
		_tmp60_ = g_match_info_fetch (_tmp59_, 1);
		acts = _tmp60_;
		_tmp61_ = g_regex_new ("display-permissions\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_perm = _tmp61_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp62_ = g_regex_new ("display-mail\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_mail = _tmp62_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp63_ = g_regex_new ("run\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_cmd = _tmp63_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_unref0 (i_act);
				_g_match_info_unref0 (i_human);
				_g_match_info_unref0 (i_cause);
				_g_match_info_unref0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		from = 0;
		{
			gboolean _tmp64_ = FALSE;
			_tmp64_ = TRUE;
			while (TRUE) {
				gboolean _tmp65_ = FALSE;
				gboolean _tmp66_ = FALSE;
				const gchar* _tmp67_ = NULL;
				gboolean _tmp71_ = FALSE;
				GMatchInfo* i_cmd = NULL;
				GRegex* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				GMatchInfo* _tmp74_ = NULL;
				gboolean _tmp75_ = FALSE;
				const gchar* _tmp128_ = NULL;
				gint _tmp129_ = 0;
				gchar* _tmp130_ = NULL;
				_tmp65_ = _tmp64_;
				if (!_tmp65_) {
				}
				_tmp64_ = FALSE;
				_tmp67_ = acts;
				if (_tmp67_ != NULL) {
					const gchar* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					_tmp68_ = acts;
					_tmp69_ = strlen (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp66_ = _tmp70_ > 0;
				} else {
					_tmp66_ = FALSE;
				}
				_tmp71_ = _tmp66_;
				if (!_tmp71_) {
					break;
				}
				i_cmd = NULL;
				_tmp72_ = r_perm;
				_tmp73_ = acts;
				_tmp75_ = g_regex_match (_tmp72_, _tmp73_, 0, &_tmp74_);
				_g_match_info_unref0 (i_cmd);
				i_cmd = _tmp74_;
				if (_tmp75_) {
					GMatchInfo* _tmp76_ = NULL;
					gint _tmp77_ = 0;
					gchar* file = NULL;
					GMatchInfo* _tmp78_ = NULL;
					gchar* _tmp79_ = NULL;
					gchar* output = NULL;
					gchar* err = NULL;
					_tmp76_ = i_cmd;
					g_match_info_fetch_pos (_tmp76_, 0, NULL, &_tmp77_);
					from = _tmp77_;
					_tmp78_ = i_cmd;
					_tmp79_ = g_match_info_fetch (_tmp78_, 1);
					file = _tmp79_;
					output = NULL;
					err = NULL;
					{
						const gchar* _tmp80_ = NULL;
						gchar* _tmp81_ = NULL;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_ = NULL;
						gchar* _tmp84_ = NULL;
						const gchar* _tmp85_ = NULL;
						const gchar* _tmp86_ = NULL;
						gchar* _tmp87_ = NULL;
						_tmp80_ = file;
						_tmp81_ = g_strconcat ("ls -ld ", _tmp80_, NULL);
						_tmp82_ = _tmp81_;
						g_spawn_command_line_sync (_tmp82_, &_tmp83_, &_tmp84_, NULL, &_inner_error_);
						_g_free0 (output);
						output = _tmp83_;
						_g_free0 (err);
						err = _tmp84_;
						_g_free0 (_tmp82_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_SPAWN_ERROR) {
								goto __catch9_g_spawn_error;
							}
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp85_ = output;
						_tmp86_ = err;
						_tmp87_ = g_strconcat (_tmp85_, _tmp86_, NULL);
						_g_free0 (permissions);
						permissions = _tmp87_;
					}
					goto __finally9;
					__catch9_g_spawn_error:
					{
						GError* e = NULL;
						FILE* _tmp88_ = NULL;
						GError* _tmp89_ = NULL;
						const gchar* _tmp90_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp88_ = stderr;
						_tmp89_ = e;
						_tmp90_ = _tmp89_->message;
						fprintf (_tmp88_, "Spawning ls: %s\n", _tmp90_);
						_g_error_free0 (e);
					}
					__finally9:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							return FALSE;
						} else {
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_unref0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_unref0 (i_act);
							_g_match_info_unref0 (i_human);
							_g_match_info_unref0 (i_cause);
							_g_match_info_unref0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (err);
					_g_free0 (output);
					_g_free0 (file);
				} else {
					GRegex* _tmp91_ = NULL;
					const gchar* _tmp92_ = NULL;
					GMatchInfo* _tmp93_ = NULL;
					gboolean _tmp94_ = FALSE;
					_tmp91_ = r_mail;
					_tmp92_ = acts;
					_tmp94_ = g_regex_match (_tmp91_, _tmp92_, 0, &_tmp93_);
					_g_match_info_unref0 (i_cmd);
					i_cmd = _tmp93_;
					if (_tmp94_) {
						GMatchInfo* _tmp95_ = NULL;
						gint _tmp96_ = 0;
						gchar* file = NULL;
						GMatchInfo* _tmp97_ = NULL;
						gchar* _tmp98_ = NULL;
						gchar* output = NULL;
						gchar* _tmp99_ = NULL;
						gchar* err = NULL;
						_tmp95_ = i_cmd;
						g_match_info_fetch_pos (_tmp95_, 0, NULL, &_tmp96_);
						from = _tmp96_;
						_tmp97_ = i_cmd;
						_tmp98_ = g_match_info_fetch (_tmp97_, 1);
						file = _tmp98_;
						_tmp99_ = g_strdup ("");
						output = _tmp99_;
						err = NULL;
						{
							const gchar* _tmp100_ = NULL;
							gchar* _tmp101_ = NULL;
							const gchar* _tmp102_ = NULL;
							gchar* _tmp103_ = NULL;
							gchar* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
							const gchar* _tmp107_ = NULL;
							const gchar* _tmp108_ = NULL;
							gchar* _tmp109_ = NULL;
							_tmp100_ = file;
							_tmp101_ = g_strdup (_tmp100_);
							_g_free0 (mail_name);
							mail_name = _tmp101_;
							_tmp102_ = file;
							_tmp103_ = g_strconcat ("cat ", _tmp102_, NULL);
							_tmp104_ = _tmp103_;
							g_spawn_command_line_sync (_tmp104_, &_tmp105_, &_tmp106_, NULL, &_inner_error_);
							_g_free0 (output);
							output = _tmp105_;
							_g_free0 (err);
							err = _tmp106_;
							_g_free0 (_tmp104_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == G_SPAWN_ERROR) {
									goto __catch10_g_spawn_error;
								}
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
							_tmp107_ = output;
							_tmp108_ = err;
							_tmp109_ = g_strconcat (_tmp107_, _tmp108_, NULL);
							_g_free0 (mail_body);
							mail_body = _tmp109_;
						}
						goto __finally10;
						__catch10_g_spawn_error:
						{
							GError* e = NULL;
							FILE* _tmp110_ = NULL;
							GError* _tmp111_ = NULL;
							const gchar* _tmp112_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp110_ = stderr;
							_tmp111_ = e;
							_tmp112_ = _tmp111_->message;
							fprintf (_tmp110_, "Spawning ls: %s\n", _tmp112_);
							_g_error_free0 (e);
						}
						__finally10:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								return FALSE;
							} else {
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_unref0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_unref0 (i_act);
								_g_match_info_unref0 (i_human);
								_g_match_info_unref0 (i_cause);
								_g_match_info_unref0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
					} else {
						GRegex* _tmp113_ = NULL;
						const gchar* _tmp114_ = NULL;
						GMatchInfo* _tmp115_ = NULL;
						gboolean _tmp116_ = FALSE;
						_tmp113_ = r_cmd;
						_tmp114_ = acts;
						_tmp116_ = g_regex_match (_tmp113_, _tmp114_, 0, &_tmp115_);
						_g_match_info_unref0 (i_cmd);
						i_cmd = _tmp115_;
						if (_tmp116_) {
							gchar* command = NULL;
							GMatchInfo* _tmp117_ = NULL;
							gchar* _tmp118_ = NULL;
							GMatchInfo* _tmp119_ = NULL;
							gint _tmp120_ = 0;
							GeeArrayList* _tmp121_ = NULL;
							GeeArrayList* _tmp122_ = NULL;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							const gchar* _tmp125_ = NULL;
							_tmp117_ = i_cmd;
							_tmp118_ = g_match_info_fetch (_tmp117_, 1);
							command = _tmp118_;
							_tmp119_ = i_cmd;
							g_match_info_fetch_pos (_tmp119_, 0, NULL, &_tmp120_);
							from = _tmp120_;
							_tmp121_ = commands;
							_tmp122_ = commands;
							_tmp123_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp122_);
							_tmp124_ = _tmp123_;
							_tmp125_ = command;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp121_, _tmp124_, _tmp125_);
							_g_free0 (command);
						} else {
							FILE* _tmp126_ = NULL;
							const gchar* _tmp127_ = NULL;
							_tmp126_ = stderr;
							_tmp127_ = acts;
							fprintf (_tmp126_, "Unrecognized action: %s\n", _tmp127_);
							_g_match_info_unref0 (i_cmd);
							break;
						}
					}
				}
				_tmp128_ = acts;
				_tmp129_ = from;
				_tmp130_ = string_substring (_tmp128_, (glong) _tmp129_, (glong) (-1));
				_g_free0 (acts);
				acts = _tmp130_;
				_g_match_info_unref0 (i_cmd);
			}
		}
		_g_regex_unref0 (r_cmd);
		_g_regex_unref0 (r_mail);
		_g_regex_unref0 (r_perm);
		_g_free0 (acts);
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp131_ = self->priv->events;
	_tmp132_ = self->priv->events;
	_tmp133_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = account;
	_tmp136_ = host;
	_tmp137_ = i_ctx;
	_tmp138_ = g_match_info_fetch (_tmp137_, 1);
	_tmp139_ = _tmp138_;
	_tmp140_ = i_cause;
	_tmp141_ = g_match_info_fetch (_tmp140_, 1);
	_tmp142_ = _tmp141_;
	_tmp143_ = permissions;
	_tmp144_ = mail_name;
	_tmp145_ = mail_body;
	_tmp146_ = commands;
	_tmp147_ = event_error (_tmp135_, _tmp136_, _tmp139_, _tmp142_, _tmp143_, _tmp144_, _tmp145_, _tmp146_);
	_tmp148_ = _tmp147_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp131_, _tmp134_, _tmp148_);
	_event_unref0 (_tmp148_);
	_g_free0 (_tmp142_);
	_g_free0 (_tmp139_);
	g_mutex_unlock (&self->priv->events_lock);
	result = FALSE;
	_g_object_unref0 (commands);
	_g_free0 (mail_body);
	_g_free0 (mail_name);
	_g_free0 (permissions);
	_g_match_info_unref0 (i_act);
	_g_match_info_unref0 (i_human);
	_g_match_info_unref0 (i_cause);
	_g_match_info_unref0 (i_ctx);
	_g_regex_unref0 (actions);
	_g_regex_unref0 (human);
	_g_regex_unref0 (cause);
	_g_regex_unref0 (context);
	return result;
}


static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	{
		GMatchInfo* info = NULL;
		GRegex* r_tags = NULL;
		GRegex* _tmp0_ = NULL;
		GRegex* r_skip = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GRegex* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GMatchInfo* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* account = NULL;
		GMatchInfo* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* host = NULL;
		GMatchInfo* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* tags = NULL;
		GMatchInfo* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GMatchInfo* i_args = NULL;
		GRegex* r_stats = NULL;
		GRegex* _tmp18_ = NULL;
		GRegex* r_error = NULL;
		GRegex* _tmp19_ = NULL;
		GRegex* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GMatchInfo* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		info = NULL;
		_tmp0_ = g_regex_new ("^([^:]+): smd-(client|server|loop|push|pull|pushpull)@([^:]+): TAGS:(." \
"*)$", 0, 0, &_inner_error_);
		r_tags = _tmp0_;
		if (_inner_error_ != NULL) {
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp1_ = g_regex_new ("^([^:]+): smd-(client|server)@([^:]+): ERROR", 0, 0, &_inner_error_);
		r_skip = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp2_ = r_skip;
		_tmp3_ = s;
		_tmp4_ = g_regex_match (_tmp2_, _tmp3_, 0, NULL);
		if (_tmp4_) {
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		}
		_tmp5_ = r_tags;
		_tmp6_ = s;
		_tmp8_ = g_regex_match (_tmp5_, _tmp6_, 0, &_tmp7_);
		_g_match_info_unref0 (info);
		info = _tmp7_;
		if (!_tmp8_) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp9_ = s;
			_tmp10_ = g_strdup_printf ("unhandled smd-loop message: %s", _tmp9_);
			_tmp11_ = _tmp10_;
			debug (_tmp11_);
			_g_free0 (_tmp11_);
			result = TRUE;
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		}
		_tmp12_ = info;
		_tmp13_ = g_match_info_fetch (_tmp12_, 1);
		account = _tmp13_;
		_tmp14_ = info;
		_tmp15_ = g_match_info_fetch (_tmp14_, 3);
		host = _tmp15_;
		_tmp16_ = info;
		_tmp17_ = g_match_info_fetch (_tmp16_, 4);
		tags = _tmp17_;
		i_args = NULL;
		_tmp18_ = g_regex_new (" stats::(.*)$", 0, 0, &_inner_error_);
		r_stats = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = g_regex_new (" error::(.*)$", 0, 0, &_inner_error_);
		r_error = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp20_ = r_stats;
		_tmp21_ = tags;
		_tmp23_ = g_regex_match (_tmp20_, _tmp21_, 0, &_tmp22_);
		_g_match_info_unref0 (i_args);
		i_args = _tmp22_;
		if (_tmp23_) {
			GRegex* r_neW = NULL;
			GRegex* _tmp24_ = NULL;
			GRegex* r_del = NULL;
			GRegex* _tmp25_ = NULL;
			GMatchInfo* i_new = NULL;
			GMatchInfo* i_del = NULL;
			gchar* args = NULL;
			GMatchInfo* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gboolean has_new = FALSE;
			GRegex* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			GMatchInfo* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			gboolean has_del = FALSE;
			GRegex* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			GMatchInfo* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			gint new_mails = 0;
			gboolean _tmp36_ = FALSE;
			gint del_mails = 0;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp46_ = FALSE;
			const gchar* _tmp47_ = NULL;
			gboolean _tmp52_ = FALSE;
			_tmp24_ = g_regex_new ("new-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_neW = _tmp24_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch11_g_regex_error;
				}
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp25_ = g_regex_new ("del-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
			r_del = _tmp25_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch11_g_regex_error;
				}
				_g_regex_unref0 (r_neW);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			i_new = NULL;
			i_del = NULL;
			_tmp26_ = i_args;
			_tmp27_ = g_match_info_fetch (_tmp26_, 1);
			args = _tmp27_;
			_tmp28_ = r_neW;
			_tmp29_ = args;
			_tmp31_ = g_regex_match (_tmp28_, _tmp29_, 0, &_tmp30_);
			_g_match_info_unref0 (i_new);
			i_new = _tmp30_;
			has_new = _tmp31_;
			_tmp32_ = r_del;
			_tmp33_ = args;
			_tmp35_ = g_regex_match (_tmp32_, _tmp33_, 0, &_tmp34_);
			_g_match_info_unref0 (i_del);
			i_del = _tmp34_;
			has_del = _tmp35_;
			new_mails = 0;
			_tmp36_ = has_new;
			if (_tmp36_) {
				GMatchInfo* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				_tmp37_ = i_new;
				_tmp38_ = g_match_info_fetch (_tmp37_, 1);
				_tmp39_ = _tmp38_;
				_tmp40_ = atoi (_tmp39_);
				new_mails = _tmp40_;
				_g_free0 (_tmp39_);
			}
			del_mails = 0;
			_tmp41_ = has_del;
			if (_tmp41_) {
				GMatchInfo* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				_tmp42_ = i_del;
				_tmp43_ = g_match_info_fetch (_tmp42_, 1);
				_tmp44_ = _tmp43_;
				_tmp45_ = atoi (_tmp44_);
				del_mails = _tmp45_;
				_g_free0 (_tmp44_);
			}
			_tmp47_ = host;
			if (g_strcmp0 (_tmp47_, "localhost") == 0) {
				gboolean _tmp48_ = FALSE;
				gint _tmp49_ = 0;
				gboolean _tmp51_ = FALSE;
				_tmp49_ = new_mails;
				if (_tmp49_ > 0) {
					_tmp48_ = TRUE;
				} else {
					gint _tmp50_ = 0;
					_tmp50_ = del_mails;
					_tmp48_ = _tmp50_ > 0;
				}
				_tmp51_ = _tmp48_;
				_tmp46_ = _tmp51_;
			} else {
				_tmp46_ = FALSE;
			}
			_tmp52_ = _tmp46_;
			if (_tmp52_) {
				GeeArrayList* _tmp53_ = NULL;
				GeeArrayList* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				const gchar* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				Event* _tmp61_ = NULL;
				Event* _tmp62_ = NULL;
				g_mutex_lock (&self->priv->events_lock);
				_tmp53_ = self->priv->events;
				_tmp54_ = self->priv->events;
				_tmp55_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = account;
				_tmp58_ = host;
				_tmp59_ = new_mails;
				_tmp60_ = del_mails;
				_tmp61_ = event_stats (_tmp57_, _tmp58_, _tmp59_, _tmp60_);
				_tmp62_ = _tmp61_;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp53_, _tmp56_, _tmp62_);
				_event_unref0 (_tmp62_);
				g_mutex_unlock (&self->priv->events_lock);
			} else {
			}
			result = TRUE;
			_g_free0 (args);
			_g_match_info_unref0 (i_del);
			_g_match_info_unref0 (i_new);
			_g_regex_unref0 (r_del);
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_unref0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_unref0 (info);
			return result;
		} else {
			GRegex* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			GMatchInfo* _tmp65_ = NULL;
			gboolean _tmp66_ = FALSE;
			_tmp63_ = r_error;
			_tmp64_ = tags;
			_tmp66_ = g_regex_match (_tmp63_, _tmp64_, 0, &_tmp65_);
			_g_match_info_unref0 (i_args);
			i_args = _tmp65_;
			if (_tmp66_) {
				gchar* args = NULL;
				GMatchInfo* _tmp67_ = NULL;
				gchar* _tmp68_ = NULL;
				gboolean _tmp69_ = FALSE;
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				gboolean _tmp73_ = FALSE;
				_tmp67_ = i_args;
				_tmp68_ = g_match_info_fetch (_tmp67_, 1);
				args = _tmp68_;
				_tmp70_ = args;
				_tmp71_ = account;
				_tmp72_ = host;
				_tmp73_ = smd_applet_eval_smd_loop_error_message (self, _tmp70_, _tmp71_, _tmp72_, &_inner_error_);
				_tmp69_ = _tmp73_;
				if (_inner_error_ != NULL) {
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_unref0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_unref0 (info);
					if (_inner_error_->domain == G_REGEX_ERROR) {
						goto __catch11_g_regex_error;
					}
					_g_free0 (args);
					_g_regex_unref0 (r_error);
					_g_regex_unref0 (r_stats);
					_g_match_info_unref0 (i_args);
					_g_free0 (tags);
					_g_free0 (host);
					_g_free0 (account);
					_g_regex_unref0 (r_skip);
					_g_regex_unref0 (r_tags);
					_g_match_info_unref0 (info);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				result = _tmp69_;
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				return result;
			} else {
				FILE* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
				_tmp74_ = stderr;
				_tmp75_ = s;
				fprintf (_tmp74_, "unhandled smd-loop message: %s\n", _tmp75_);
				result = TRUE;
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_unref0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_unref0 (info);
				return result;
			}
		}
		_g_regex_unref0 (r_error);
		_g_regex_unref0 (r_stats);
		_g_match_info_unref0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_unref0 (info);
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp76_ = NULL;
		GError* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp76_ = stderr;
		_tmp77_ = e;
		_tmp78_ = _tmp77_->message;
		fprintf (_tmp76_, "%s\n", _tmp78_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void ___lambda5_ (smdApplet* self) {
	setpgid ((pid_t) 0, (pid_t) 0);
}


static void ____lambda5__gspawn_child_setup_func (gpointer self) {
	___lambda5_ (self);
}


static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error) {
	gboolean result = FALSE;
	gchar** cmd = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint cmd_length1 = 0;
	gint _cmd_size_ = 0;
	gint child_in = 0;
	gint child_out = 0;
	gint child_err = 0;
	gchar* buff = NULL;
	gchar* _tmp4_ = NULL;
	gint buff_length1 = 0;
	gint _buff_size_ = 0;
	GSpawnFlags flags = 0;
	gboolean rc = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_smd_loop_cmd;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("-v");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	cmd = _tmp3_;
	cmd_length1 = 2;
	_cmd_size_ = cmd_length1;
	_tmp4_ = g_new0 (gchar, 10240);
	buff = _tmp4_;
	buff_length1 = 10240;
	_buff_size_ = buff_length1;
	flags = 0;
	_tmp5_ = smd_applet_smd_loop_cmd;
	_tmp6_ = g_strdup_printf ("spawning %s\n", _tmp5_);
	_tmp7_ = _tmp6_;
	debug (_tmp7_);
	_g_free0 (_tmp7_);
	{
		gboolean _tmp8_ = FALSE;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GSpawnFlags _tmp10_ = 0;
		GPid _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		_tmp9_ = cmd;
		_tmp9__length1 = cmd_length1;
		_tmp10_ = flags;
		_tmp15_ = g_spawn_async_with_pipes (NULL, _tmp9_, NULL, _tmp10_, ____lambda5__gspawn_child_setup_func, self, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_inner_error_);
		self->priv->pid = _tmp11_;
		child_in = _tmp12_;
		child_out = _tmp13_;
		child_err = _tmp14_;
		_tmp8_ = _tmp15_;
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		rc = _tmp8_;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = smd_applet_smd_loop_cmd;
		_tmp18_ = g_strconcat ("Unable to execute ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ": ", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
		_tmp27_ = _tmp26_;
		fprintf (_tmp16_, "%s", _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp28_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally12;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (rc) {
		FILE* input = NULL;
		gint _tmp29_ = 0;
		FILE* _tmp30_ = NULL;
		gchar* s = NULL;
		gboolean goon = FALSE;
		const gchar* _tmp50_ = NULL;
		GPid _tmp60_ = 0;
		GPid _tmp61_ = 0;
		_tmp29_ = child_out;
		_tmp30_ = fdopen (_tmp29_, "r");
		input = _tmp30_;
		s = NULL;
		goon = TRUE;
		while (TRUE) {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp41_ = FALSE;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			gboolean _tmp47_ = FALSE;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			_tmp33_ = goon;
			if (_tmp33_) {
				FILE* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				_tmp34_ = input;
				_tmp35_ = buff;
				_tmp35__length1 = buff_length1;
				_tmp36_ = fgets (_tmp35_, _tmp35__length1, _tmp34_);
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (s);
				s = _tmp37_;
				_tmp38_ = s;
				_tmp32_ = _tmp38_ != NULL;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp39_ = _tmp32_;
			if (_tmp39_) {
				gboolean _tmp40_ = FALSE;
				_tmp40_ = self->priv->thread_die;
				_tmp31_ = !_tmp40_;
			} else {
				_tmp31_ = FALSE;
			}
			_tmp41_ = _tmp31_;
			if (!_tmp41_) {
				break;
			}
			_tmp42_ = s;
			_tmp43_ = g_strdup_printf ("smd-loop outputs: %s", _tmp42_);
			_tmp44_ = _tmp43_;
			debug (_tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = s;
			_tmp46_ = smd_applet_eval_smd_loop_message (self, _tmp45_);
			goon = _tmp46_;
			_tmp47_ = goon;
			_tmp48_ = g_strdup_printf ("eval_smd_loop_message returned %d", (gint) _tmp47_);
			_tmp49_ = _tmp48_;
			debug (_tmp49_);
			_g_free0 (_tmp49_);
		}
		_tmp50_ = s;
		if (_tmp50_ != NULL) {
			FILE* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			_tmp51_ = input;
			_tmp52_ = buff;
			_tmp52__length1 = buff_length1;
			_tmp53_ = fgets (_tmp52_, _tmp52__length1, _tmp51_);
			_tmp54_ = g_strdup (_tmp53_);
			_g_free0 (s);
			s = _tmp54_;
			_tmp55_ = s;
			if (_tmp55_ != NULL) {
				FILE* _tmp56_ = NULL;
				FILE* _tmp57_ = NULL;
				GPid _tmp58_ = 0;
				const gchar* _tmp59_ = NULL;
				_tmp56_ = stderr;
				fprintf (_tmp56_, "smd-loop gave error tag but not died\n");
				_tmp57_ = stderr;
				_tmp58_ = self->priv->pid;
				_tmp59_ = s;
				fprintf (_tmp57_, "smd-loop has pid %d and prints %s\n", (gint) _tmp58_, _tmp59_);
			}
		}
		_tmp60_ = self->priv->pid;
		g_spawn_close_pid (_tmp60_);
		_tmp61_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp61_)), SIGTERM);
		result = goon;
		_g_free0 (s);
		_fclose0 (input);
		buff = (g_free (buff), NULL);
		cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		FILE* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		GError* _tmp68_ = NULL;
		_tmp62_ = stderr;
		_tmp63_ = smd_applet_smd_loop_cmd;
		_tmp64_ = g_strconcat ("Unable to execute ", _tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strconcat (_tmp65_, "\n", NULL);
		_tmp67_ = _tmp66_;
		fprintf (_tmp62_, "%s", _tmp67_);
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_tmp68_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp68_;
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	buff = (g_free (buff), NULL);
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
}


static void ______lambda13_ (smdApplet* self, NotifyNotification* not, const gchar* action) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (not != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_window_reshow_with_initial_size (_tmp0_);
}


static void _______lambda13__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	______lambda13_ (self, notification, action);
}


static void ______lambda14_ (smdApplet* self, GtkButton* b) {
	gint cmd_status = 0;
	gchar* output = NULL;
	gchar* _error_ = NULL;
	GHashTable* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->priv->command_hash;
	_tmp1_ = b;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = g_strdup_printf ("executing: %s\n", (const gchar*) _tmp2_);
	_tmp4_ = _tmp3_;
	debug (_tmp4_);
	_g_free0 (_tmp4_);
	{
		GHashTable* _tmp5_ = NULL;
		GtkButton* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp5_ = self->priv->command_hash;
		_tmp6_ = b;
		_tmp7_ = g_hash_table_lookup (_tmp5_, (GtkWidget*) _tmp6_);
		g_spawn_command_line_sync ((const gchar*) _tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_inner_error_);
		_g_free0 (output);
		output = _tmp8_;
		_g_free0 (_error_);
		_error_ = _tmp9_;
		cmd_status = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch16_g_spawn_error;
			}
			_g_free0 (_error_);
			_g_free0 (output);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = WIFEXITED (cmd_status);
		if (_tmp12_) {
			gint _tmp13_ = 0;
			_tmp13_ = WEXITSTATUS (cmd_status);
			_tmp11_ = 0 == _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp14_ = _tmp11_;
		if (_tmp14_) {
			GtkButton* _tmp15_ = NULL;
			_tmp15_ = b;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
		} else {
			GtkMessageDialog* w = NULL;
			GtkWindow* _tmp16_ = NULL;
			GtkMessageDialog* _tmp17_ = NULL;
			GtkMessageDialog* _tmp18_ = NULL;
			GtkMessageDialog* _tmp19_ = NULL;
			_tmp16_ = self->priv->err_win;
			_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "An error occurred:\n%s\n%s", output, _error_);
			g_object_ref_sink (_tmp17_);
			w = _tmp17_;
			_tmp18_ = w;
			gtk_dialog_run ((GtkDialog*) _tmp18_);
			_tmp19_ = w;
			gtk_widget_destroy ((GtkWidget*) _tmp19_);
			_g_object_unref0 (w);
		}
	}
	goto __finally16;
	__catch16_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		fprintf (_tmp20_, "Spawning: %s\n", _tmp22_);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (_error_);
	_g_free0 (output);
}


static void _______lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda14_ (self, _sender);
}


static gboolean smd_applet_eat_event (smdApplet* self) {
	gboolean result = FALSE;
	Event* e = NULL;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp9_ = FALSE;
	Event* _tmp10_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp59_ = FALSE;
	Event* _tmp60_ = NULL;
	gboolean _tmp63_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	e = NULL;
	_tmp0_ = self->priv->error_mode;
	if (_tmp0_) {
		result = TRUE;
		_event_unref0 (e);
		return result;
	}
	g_mutex_lock (&self->priv->events_lock);
	_tmp1_ = self->priv->events;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeArrayList* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		Event* _tmp8_ = NULL;
		_tmp4_ = self->priv->events;
		_tmp5_ = gee_abstract_list_first ((GeeAbstractList*) _tmp4_);
		_event_unref0 (e);
		e = (Event*) _tmp5_;
		_tmp6_ = self->priv->events;
		_tmp7_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, 0);
		_tmp8_ = (Event*) _tmp7_;
		_event_unref0 (_tmp8_);
	}
	g_mutex_unlock (&self->priv->events_lock);
	_tmp10_ = e;
	if (_tmp10_ != NULL) {
		Event* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp9_ = _tmp12_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp13_ = _tmp9_;
	if (_tmp13_) {
		gboolean notify_on_newail = FALSE;
		GSettings* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		Event* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp20_ = FALSE;
		notify_on_newail = FALSE;
		_tmp14_ = self->priv->settings;
		_tmp15_ = g_settings_get_boolean (_tmp14_, SMD_APPLET_key_newmail);
		notify_on_newail = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->enter_network_error_mode;
		if (_tmp18_) {
			gboolean _tmp19_ = FALSE;
			_tmp19_ = self->priv->network_error_mode;
			_tmp16_ = _tmp19_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp20_ = _tmp16_;
		if (_tmp20_) {
		} else {
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			Event* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp33_ = FALSE;
			_tmp23_ = e;
			_tmp24_ = event_is_error_event (_tmp23_);
			if (!_tmp24_) {
				gboolean _tmp25_ = FALSE;
				_tmp25_ = notify_on_newail;
				_tmp22_ = _tmp25_;
			} else {
				_tmp22_ = FALSE;
			}
			_tmp26_ = _tmp22_;
			if (_tmp26_) {
				_tmp21_ = TRUE;
			} else {
				gboolean _tmp27_ = FALSE;
				Event* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp32_ = FALSE;
				_tmp28_ = e;
				_tmp29_ = event_is_error_event (_tmp28_);
				if (_tmp29_) {
					Event* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
					_tmp30_ = e;
					_tmp31_ = _tmp30_->enter_network_error_mode;
					_tmp27_ = _tmp31_;
				} else {
					_tmp27_ = FALSE;
				}
				_tmp32_ = _tmp27_;
				_tmp21_ = _tmp32_;
			}
			_tmp33_ = _tmp21_;
			if (_tmp33_) {
				Event* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				Event* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				NotifyNotification* _tmp38_ = NULL;
				NotifyNotification* _tmp39_ = NULL;
				GVariant* _tmp40_ = NULL;
				GVariant* _tmp41_ = NULL;
				_tmp34_ = e;
				_tmp35_ = _tmp34_->message;
				_tmp36_ = e;
				_tmp37_ = _tmp36_->message_icon;
				_tmp38_ = notify_notification_new ("Syncmaildir", _tmp35_, _tmp37_);
				_g_object_unref0 (self->priv->notification);
				self->priv->notification = _tmp38_;
				_tmp39_ = self->priv->notification;
				_tmp40_ = g_variant_new_boolean (TRUE);
				g_variant_ref_sink (_tmp40_);
				_tmp41_ = _tmp40_;
				notify_notification_set_hint (_tmp39_, "transient", _tmp41_);
				_g_variant_unref0 (_tmp41_);
				{
					NotifyNotification* _tmp42_ = NULL;
					_tmp42_ = self->priv->notification;
					notify_notification_show (_tmp42_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch13_g_error;
					}
				}
				goto __finally13;
				__catch13_g_error:
				{
					GError* e = NULL;
					FILE* _tmp43_ = NULL;
					GError* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp43_ = stderr;
					_tmp44_ = e;
					_tmp45_ = _tmp44_->message;
					fprintf (_tmp43_, "%s\n", _tmp45_);
					_g_error_free0 (e);
				}
				__finally13:
				if (_inner_error_ != NULL) {
					_event_unref0 (e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			} else {
				Event* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				_tmp46_ = e;
				_tmp47_ = event_is_error_event (_tmp46_);
				if (_tmp47_) {
					Event* _tmp48_ = NULL;
					const gchar* _tmp49_ = NULL;
					Event* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					NotifyNotification* _tmp52_ = NULL;
					NotifyNotification* _tmp53_ = NULL;
					NotifyNotification* _tmp54_ = NULL;
					_tmp48_ = e;
					_tmp49_ = _tmp48_->message;
					_tmp50_ = e;
					_tmp51_ = _tmp50_->message_icon;
					_tmp52_ = notify_notification_new ("Syncmaildir", _tmp49_, _tmp51_);
					_g_object_unref0 (self->priv->notification);
					self->priv->notification = _tmp52_;
					_tmp53_ = self->priv->notification;
					notify_notification_set_timeout (_tmp53_, 0);
					_tmp54_ = self->priv->notification;
					notify_notification_add_action (_tmp54_, "clicked", "Handle error", _______lambda13__notify_action_callback, g_object_ref (self), g_object_unref);
					{
						NotifyNotification* _tmp55_ = NULL;
						_tmp55_ = self->priv->notification;
						notify_notification_show (_tmp55_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch14_g_error;
						}
					}
					goto __finally14;
					__catch14_g_error:
					{
						GError* e = NULL;
						FILE* _tmp56_ = NULL;
						GError* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp56_ = stderr;
						_tmp57_ = e;
						_tmp58_ = _tmp57_->message;
						fprintf (_tmp56_, "%s\n", _tmp58_);
						_g_error_free0 (e);
					}
					__finally14:
					if (_inner_error_ != NULL) {
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	_tmp60_ = e;
	if (_tmp60_ != NULL) {
		Event* _tmp61_ = NULL;
		gboolean _tmp62_ = FALSE;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->enter_error_mode;
		_tmp59_ = _tmp62_;
	} else {
		_tmp59_ = FALSE;
	}
	_tmp63_ = _tmp59_;
	if (_tmp63_) {
		GtkStatusIcon* _tmp64_ = NULL;
		GtkStatusIcon* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		GtkLabel* l_ctx = NULL;
		GtkBuilder* _tmp68_ = NULL;
		GObject* _tmp69_ = NULL;
		GtkLabel* _tmp70_ = NULL;
		GtkLabel* l_cause = NULL;
		GtkBuilder* _tmp71_ = NULL;
		GObject* _tmp72_ = NULL;
		GtkLabel* _tmp73_ = NULL;
		GtkLabel* _tmp74_ = NULL;
		Event* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		GtkLabel* _tmp77_ = NULL;
		Event* _tmp78_ = NULL;
		const gchar* _tmp79_ = NULL;
		GHashTable* _tmp80_ = NULL;
		GtkGrid* vb = NULL;
		GtkBuilder* _tmp81_ = NULL;
		GObject* _tmp82_ = NULL;
		GtkGrid* _tmp83_ = NULL;
		GtkGrid* _tmp84_ = NULL;
		GList* _tmp85_ = NULL;
		Event* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		Event* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		Event* _tmp126_ = NULL;
		GeeArrayList* _tmp127_ = NULL;
		GtkWidget* x = NULL;
		GtkBuilder* _tmp175_ = NULL;
		GObject* _tmp176_ = NULL;
		GtkWidget* _tmp177_ = NULL;
		GtkWidget* _tmp178_ = NULL;
		Event* _tmp179_ = NULL;
		const gchar* _tmp180_ = NULL;
		GtkBuilder* _tmp181_ = NULL;
		GObject* _tmp182_ = NULL;
		GtkWidget* _tmp183_ = NULL;
		GtkWidget* _tmp184_ = NULL;
		Event* _tmp185_ = NULL;
		const gchar* _tmp186_ = NULL;
		GtkBuilder* _tmp187_ = NULL;
		GObject* _tmp188_ = NULL;
		GtkWidget* _tmp189_ = NULL;
		GtkWidget* _tmp190_ = NULL;
		Event* _tmp191_ = NULL;
		GeeArrayList* _tmp192_ = NULL;
		gint _tmp193_ = 0;
		gint _tmp194_ = 0;
		_tmp64_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp64_, "error");
		_tmp65_ = self->priv->si;
		gtk_status_icon_set_tooltip_text (_tmp65_, "smd-applet encountered an error");
		self->priv->error_mode = TRUE;
		_tmp66_ = self->priv->notification_server_has_persistence;
		if (!_tmp66_) {
			GtkStatusIcon* _tmp67_ = NULL;
			_tmp67_ = self->priv->si;
			gtk_status_icon_set_visible (_tmp67_, TRUE);
		}
		_tmp68_ = self->priv->builder;
		_tmp69_ = gtk_builder_get_object (_tmp68_, "lContext");
		_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp69_) : NULL);
		l_ctx = _tmp70_;
		_tmp71_ = self->priv->builder;
		_tmp72_ = gtk_builder_get_object (_tmp71_, "lCause");
		_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp72_) : NULL);
		l_cause = _tmp73_;
		_tmp74_ = l_ctx;
		_tmp75_ = e;
		_tmp76_ = _tmp75_->context;
		gtk_label_set_text (_tmp74_, _tmp76_);
		_tmp77_ = l_cause;
		_tmp78_ = e;
		_tmp79_ = _tmp78_->cause;
		gtk_label_set_text (_tmp77_, _tmp79_);
		_tmp80_ = self->priv->command_hash;
		g_hash_table_remove_all (_tmp80_);
		_tmp81_ = self->priv->builder;
		_tmp82_ = gtk_builder_get_object (_tmp81_, "vbRun");
		_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp82_) : NULL);
		vb = _tmp83_;
		_tmp84_ = vb;
		_tmp85_ = gtk_container_get_children ((GtkContainer*) _tmp84_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp85_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp86_ = NULL;
				GtkWidget* w = NULL;
				_tmp86_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp86_;
				{
					GtkGrid* _tmp87_ = NULL;
					GtkWidget* _tmp88_ = NULL;
					_tmp87_ = vb;
					_tmp88_ = w;
					gtk_container_remove ((GtkContainer*) _tmp87_, _tmp88_);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
		_tmp89_ = e;
		_tmp90_ = _tmp89_->permissions;
		if (_tmp90_ != NULL) {
			GtkLabel* l = NULL;
			GtkBuilder* _tmp91_ = NULL;
			GObject* _tmp92_ = NULL;
			GtkLabel* _tmp93_ = NULL;
			GtkLabel* _tmp94_ = NULL;
			Event* _tmp95_ = NULL;
			const gchar* _tmp96_ = NULL;
			_tmp91_ = self->priv->builder;
			_tmp92_ = gtk_builder_get_object (_tmp91_, "lPermissions");
			_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp92_) : NULL);
			l = _tmp93_;
			_tmp94_ = l;
			_tmp95_ = e;
			_tmp96_ = _tmp95_->permissions;
			gtk_label_set_text (_tmp94_, _tmp96_);
			_g_object_unref0 (l);
		}
		_tmp97_ = e;
		_tmp98_ = _tmp97_->mail_name;
		if (_tmp98_ != NULL) {
			GtkEntry* fn = NULL;
			GtkBuilder* _tmp99_ = NULL;
			GObject* _tmp100_ = NULL;
			GtkEntry* _tmp101_ = NULL;
			GtkEntry* _tmp102_ = NULL;
			Event* _tmp103_ = NULL;
			const gchar* _tmp104_ = NULL;
			GtkTextView* l = NULL;
			GtkBuilder* _tmp105_ = NULL;
			GObject* _tmp106_ = NULL;
			GtkTextView* _tmp107_ = NULL;
			GtkTextBuffer* b = NULL;
			GtkTextView* _tmp108_ = NULL;
			GtkTextBuffer* _tmp109_ = NULL;
			GtkTextBuffer* _tmp110_ = NULL;
			GtkTextBuffer* _tmp111_ = NULL;
			Event* _tmp112_ = NULL;
			const gchar* _tmp113_ = NULL;
			GtkTextIter it = {0};
			GtkTextIter subj = {0};
			GtkTextBuffer* _tmp114_ = NULL;
			GtkTextIter _tmp115_ = {0};
			GtkTextIter _tmp116_ = {0};
			gboolean _tmp117_ = FALSE;
			_tmp99_ = self->priv->builder;
			_tmp100_ = gtk_builder_get_object (_tmp99_, "eMailName");
			_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp100_) : NULL);
			fn = _tmp101_;
			_tmp102_ = fn;
			_tmp103_ = e;
			_tmp104_ = _tmp103_->mail_name;
			gtk_entry_set_text (_tmp102_, _tmp104_);
			_tmp105_ = self->priv->builder;
			_tmp106_ = gtk_builder_get_object (_tmp105_, "tvMail");
			_tmp107_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, GTK_TYPE_TEXT_VIEW) ? ((GtkTextView*) _tmp106_) : NULL);
			l = _tmp107_;
			_tmp108_ = l;
			_tmp109_ = gtk_text_view_get_buffer (_tmp108_);
			_tmp110_ = _g_object_ref0 (_tmp109_);
			b = _tmp110_;
			_tmp111_ = b;
			_tmp112_ = e;
			_tmp113_ = _tmp112_->mail_body;
			gtk_text_buffer_set_text (_tmp111_, _tmp113_, -1);
			_tmp114_ = b;
			gtk_text_buffer_get_start_iter (_tmp114_, &_tmp115_);
			it = _tmp115_;
			_tmp117_ = gtk_text_iter_forward_search (&it, "Subject:", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp116_, NULL, NULL);
			subj = _tmp116_;
			if (_tmp117_) {
				GtkTextMark* insert = NULL;
				GtkTextBuffer* _tmp118_ = NULL;
				GtkTextMark* _tmp119_ = NULL;
				GtkTextMark* _tmp120_ = NULL;
				GtkTextBuffer* _tmp121_ = NULL;
				GtkTextIter _tmp122_ = {0};
				GtkTextIter _tmp123_ = {0};
				GtkTextView* _tmp124_ = NULL;
				GtkTextMark* _tmp125_ = NULL;
				_tmp118_ = b;
				_tmp119_ = gtk_text_buffer_get_insert (_tmp118_);
				_tmp120_ = _g_object_ref0 (_tmp119_);
				insert = _tmp120_;
				_tmp121_ = b;
				_tmp122_ = subj;
				_tmp123_ = subj;
				gtk_text_buffer_select_range (_tmp121_, &_tmp122_, &_tmp123_);
				_tmp124_ = l;
				_tmp125_ = insert;
				gtk_text_view_scroll_to_mark (_tmp124_, _tmp125_, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (insert);
			}
			_g_object_unref0 (b);
			_g_object_unref0 (l);
			_g_object_unref0 (fn);
		}
		_tmp126_ = e;
		_tmp127_ = _tmp126_->commands;
		if (_tmp127_ != NULL) {
			{
				GeeArrayList* _command_list = NULL;
				Event* _tmp128_ = NULL;
				GeeArrayList* _tmp129_ = NULL;
				GeeArrayList* _tmp130_ = NULL;
				gint _command_size = 0;
				GeeArrayList* _tmp131_ = NULL;
				gint _tmp132_ = 0;
				gint _tmp133_ = 0;
				gint _command_index = 0;
				_tmp128_ = e;
				_tmp129_ = _tmp128_->commands;
				_tmp130_ = _g_object_ref0 (_tmp129_);
				_command_list = _tmp130_;
				_tmp131_ = _command_list;
				_tmp132_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp131_);
				_tmp133_ = _tmp132_;
				_command_size = _tmp133_;
				_command_index = -1;
				while (TRUE) {
					gint _tmp134_ = 0;
					gint _tmp135_ = 0;
					gint _tmp136_ = 0;
					gchar* command = NULL;
					GeeArrayList* _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gpointer _tmp139_ = NULL;
					GtkGrid* hb = NULL;
					GtkGrid* _tmp140_ = NULL;
					GtkGrid* _tmp141_ = NULL;
					GtkGrid* _tmp142_ = NULL;
					gchar* nice_command = NULL;
					GtkLabel* lbl = NULL;
					const gchar* _tmp158_ = NULL;
					GtkLabel* _tmp159_ = NULL;
					GtkLabel* _tmp160_ = NULL;
					GtkButton* but = NULL;
					GtkButton* _tmp161_ = NULL;
					GHashTable* _tmp162_ = NULL;
					GtkButton* _tmp163_ = NULL;
					GtkWidget* _tmp164_ = NULL;
					const gchar* _tmp165_ = NULL;
					gchar* _tmp166_ = NULL;
					GtkButton* _tmp167_ = NULL;
					GtkGrid* _tmp168_ = NULL;
					GtkLabel* _tmp169_ = NULL;
					GtkGrid* _tmp170_ = NULL;
					GtkButton* _tmp171_ = NULL;
					GtkGrid* _tmp172_ = NULL;
					GtkGrid* _tmp173_ = NULL;
					GtkGrid* _tmp174_ = NULL;
					_tmp134_ = _command_index;
					_command_index = _tmp134_ + 1;
					_tmp135_ = _command_index;
					_tmp136_ = _command_size;
					if (!(_tmp135_ < _tmp136_)) {
						break;
					}
					_tmp137_ = _command_list;
					_tmp138_ = _command_index;
					_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, _tmp138_);
					command = (gchar*) _tmp139_;
					_tmp140_ = (GtkGrid*) gtk_grid_new ();
					g_object_ref_sink (_tmp140_);
					hb = _tmp140_;
					_tmp141_ = hb;
					gtk_grid_set_column_homogeneous (_tmp141_, FALSE);
					_tmp142_ = hb;
					gtk_grid_set_column_spacing (_tmp142_, (guint) 10);
					{
						GMatchInfo* i_mailto = NULL;
						GRegex* mailto_rex = NULL;
						GRegex* _tmp143_ = NULL;
						GRegex* _tmp144_ = NULL;
						const gchar* _tmp145_ = NULL;
						GMatchInfo* _tmp146_ = NULL;
						gboolean _tmp147_ = FALSE;
						_tmp143_ = g_regex_new ("^gnome-open..mailto:", 0, 0, &_inner_error_);
						mailto_rex = _tmp143_;
						if (_inner_error_ != NULL) {
							_g_match_info_unref0 (i_mailto);
							if (_inner_error_->domain == G_REGEX_ERROR) {
								goto __catch15_g_regex_error;
							}
							_g_match_info_unref0 (i_mailto);
							_g_free0 (nice_command);
							_g_object_unref0 (hb);
							_g_free0 (command);
							_g_object_unref0 (_command_list);
							_g_object_unref0 (vb);
							_g_object_unref0 (l_cause);
							_g_object_unref0 (l_ctx);
							_event_unref0 (e);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp144_ = mailto_rex;
						_tmp145_ = command;
						_tmp147_ = g_regex_match (_tmp144_, _tmp145_, 0, &_tmp146_);
						_g_match_info_unref0 (i_mailto);
						i_mailto = _tmp146_;
						if (_tmp147_) {
							const gchar* _tmp148_ = NULL;
							gchar* _tmp149_ = NULL;
							gchar* _tmp150_ = NULL;
							gchar* _tmp151_ = NULL;
							gchar* _tmp152_ = NULL;
							gchar* _tmp153_ = NULL;
							_tmp148_ = command;
							_tmp149_ = g_uri_unescape_string (_tmp148_, NULL);
							_tmp150_ = _tmp149_;
							_tmp151_ = string_substring (_tmp150_, (glong) 12, (glong) 70);
							_tmp152_ = _tmp151_;
							_tmp153_ = g_strconcat (_tmp152_, "...", NULL);
							_g_free0 (nice_command);
							nice_command = _tmp153_;
							_g_free0 (_tmp152_);
							_g_free0 (_tmp150_);
						} else {
							const gchar* _tmp154_ = NULL;
							gchar* _tmp155_ = NULL;
							_tmp154_ = command;
							_tmp155_ = g_strdup (_tmp154_);
							_g_free0 (nice_command);
							nice_command = _tmp155_;
						}
						_g_regex_unref0 (mailto_rex);
						_g_match_info_unref0 (i_mailto);
					}
					goto __finally15;
					__catch15_g_regex_error:
					{
						GError* e = NULL;
						const gchar* _tmp156_ = NULL;
						gchar* _tmp157_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp156_ = command;
						_tmp157_ = g_strdup (_tmp156_);
						_g_free0 (nice_command);
						nice_command = _tmp157_;
						_g_error_free0 (e);
					}
					__finally15:
					if (_inner_error_ != NULL) {
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_list);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp158_ = nice_command;
					_tmp159_ = (GtkLabel*) gtk_label_new (_tmp158_);
					g_object_ref_sink (_tmp159_);
					lbl = _tmp159_;
					_tmp160_ = lbl;
					gtk_misc_set_alignment ((GtkMisc*) _tmp160_, 0.0f, 0.5f);
					_tmp161_ = (GtkButton*) gtk_button_new_from_stock ("gtk-execute");
					g_object_ref_sink (_tmp161_);
					but = _tmp161_;
					_tmp162_ = self->priv->command_hash;
					_tmp163_ = but;
					_tmp164_ = _g_object_ref0 ((GtkWidget*) _tmp163_);
					_tmp165_ = command;
					_tmp166_ = g_strdup (_tmp165_);
					g_hash_table_insert (_tmp162_, _tmp164_, _tmp166_);
					_tmp167_ = but;
					g_signal_connect_object (_tmp167_, "clicked", (GCallback) _______lambda14__gtk_button_clicked, self, 0);
					_tmp168_ = hb;
					_tmp169_ = lbl;
					gtk_grid_attach (_tmp168_, (GtkWidget*) _tmp169_, 1, 0, 1, 1);
					_tmp170_ = hb;
					_tmp171_ = but;
					gtk_grid_attach (_tmp170_, (GtkWidget*) _tmp171_, 0, 0, 1, 1);
					_tmp172_ = vb;
					_tmp173_ = hb;
					gtk_container_add ((GtkContainer*) _tmp172_, (GtkWidget*) _tmp173_);
					_tmp174_ = hb;
					gtk_widget_show_all ((GtkWidget*) _tmp174_);
					_g_object_unref0 (but);
					_g_object_unref0 (lbl);
					_g_free0 (nice_command);
					_g_object_unref0 (hb);
					_g_free0 (command);
				}
				_g_object_unref0 (_command_list);
			}
		}
		_tmp175_ = self->priv->builder;
		_tmp176_ = gtk_builder_get_object (_tmp175_, "fDisplayPermissions");
		_tmp177_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp176_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp176_) : NULL);
		x = _tmp177_;
		_tmp178_ = x;
		_tmp179_ = e;
		_tmp180_ = _tmp179_->permissions;
		gtk_widget_set_visible (_tmp178_, _tmp180_ != NULL);
		_tmp181_ = self->priv->builder;
		_tmp182_ = gtk_builder_get_object (_tmp181_, "fDisplayMail");
		_tmp183_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp182_) : NULL);
		_g_object_unref0 (x);
		x = _tmp183_;
		_tmp184_ = x;
		_tmp185_ = e;
		_tmp186_ = _tmp185_->mail_name;
		gtk_widget_set_visible (_tmp184_, _tmp186_ != NULL);
		_tmp187_ = self->priv->builder;
		_tmp188_ = gtk_builder_get_object (_tmp187_, "fRun");
		_tmp189_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp188_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp188_) : NULL);
		_g_object_unref0 (x);
		x = _tmp189_;
		_tmp190_ = x;
		_tmp191_ = e;
		_tmp192_ = _tmp191_->commands;
		_tmp193_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp192_);
		_tmp194_ = _tmp193_;
		gtk_widget_set_visible (_tmp190_, _tmp194_ > 0);
		_g_object_unref0 (x);
		_g_object_unref0 (vb);
		_g_object_unref0 (l_cause);
		_g_object_unref0 (l_ctx);
	} else {
		gboolean _tmp195_ = FALSE;
		Event* _tmp196_ = NULL;
		gboolean _tmp199_ = FALSE;
		_tmp196_ = e;
		if (_tmp196_ != NULL) {
			Event* _tmp197_ = NULL;
			gboolean _tmp198_ = FALSE;
			_tmp197_ = e;
			_tmp198_ = _tmp197_->enter_network_error_mode;
			_tmp195_ = _tmp198_;
		} else {
			_tmp195_ = FALSE;
		}
		_tmp199_ = _tmp195_;
		if (_tmp199_) {
			GtkStatusIcon* _tmp200_ = NULL;
			GtkStatusIcon* _tmp201_ = NULL;
			self->priv->network_error_mode = TRUE;
			_tmp200_ = self->priv->si;
			gtk_status_icon_set_from_icon_name (_tmp200_, "dialog-warning");
			_tmp201_ = self->priv->si;
			gtk_status_icon_set_tooltip_text (_tmp201_, "Network error");
		} else {
			Event* _tmp202_ = NULL;
			_tmp202_ = e;
			if (_tmp202_ != NULL) {
				GtkStatusIcon* _tmp203_ = NULL;
				GtkStatusIcon* _tmp204_ = NULL;
				self->priv->network_error_mode = FALSE;
				_tmp203_ = self->priv->si;
				gtk_status_icon_set_from_icon_name (_tmp203_, "mail-send-receive");
				_tmp204_ = self->priv->si;
				gtk_status_icon_set_tooltip_text (_tmp204_, "smd-applet is running");
			}
		}
	}
	result = TRUE;
	_event_unref0 (e);
	return result;
}


static void smd_applet_close_err_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_reset_to_regular_run (self, FALSE);
}


static gboolean smd_applet_close_err_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_reset_to_regular_run (self, FALSE);
	result = TRUE;
	return result;
}


static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force) {
	GtkWindow* _tmp0_ = NULL;
	GtkStatusIcon* _tmp1_ = NULL;
	GtkStatusIcon* _tmp2_ = NULL;
	GThread* _tmp3_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->err_win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->error_mode = FALSE;
	_tmp1_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp1_, "smd-applet is running");
	_tmp2_ = self->priv->si;
	gtk_status_icon_set_from_icon_name (_tmp2_, "mail-send-receive");
	debug ("joining smdThread");
	_tmp3_ = self->priv->thread;
	if (_tmp3_ != NULL) {
		GThread* _tmp4_ = NULL;
		_tmp4_ = self->priv->thread;
		g_thread_join (_tmp4_);
	}
	self->priv->thread_die = FALSE;
	debug ("starting smdThread");
	_tmp5_ = force;
	smd_applet_start_smdThread (self, _tmp5_);
}


static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEventAny* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_prefs (self);
	result = TRUE;
	return result;
}


static void smd_applet_close_prefs (smdApplet* self) {
	GtkWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->win;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->config_wait_mode;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GtkStatusIcon* _tmp5_ = NULL;
		self->priv->config_wait_mode = FALSE;
		_tmp5_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp5_, "mail-send-receive");
		debug ("starting smdThread since smd stack is configured");
		smd_applet_start_smdThread (self, FALSE);
	}
}


static void smd_applet_pause (smdApplet* self) {
	GPid _tmp0_ = 0;
	GtkStatusIcon* _tmp5_ = NULL;
	GtkStatusIcon* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	debug ("enter pause mode");
	_tmp0_ = self->priv->pid;
	if (((gint) _tmp0_) != 0) {
		GPid _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GPid _tmp4_ = 0;
		_tmp1_ = self->priv->pid;
		_tmp2_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) _tmp1_));
		_tmp3_ = _tmp2_;
		debug (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->pid;
		kill ((pid_t) (-((gint) _tmp4_)), SIGTERM);
	}
	self->priv->thread_die = TRUE;
	_tmp5_ = self->priv->si;
	gtk_status_icon_set_from_stock (_tmp5_, "gtk-media-pause");
	_tmp6_ = self->priv->si;
	gtk_status_icon_set_tooltip_text (_tmp6_, "smd-applet is paused");
}


static void smd_applet_unpause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("exit pause mode");
	smd_applet_reset_to_regular_run (self, TRUE);
}


static gboolean smd_applet_is_smd_loop_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkBox* l = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_LOOP_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "bErrLoop");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkBox* _tmp6_ = NULL;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkBox* _tmp7_ = NULL;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean rc = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkBox* l = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = SMD_PP_DEF_CFG;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_EXISTS);
	rc = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gtk_builder_get_object (_tmp2_, "bErrPushPull");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp3_) : NULL);
	l = _tmp4_;
	_tmp5_ = rc;
	if (!_tmp5_) {
		GtkBox* _tmp6_ = NULL;
		_tmp6_ = l;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	} else {
		GtkBox* _tmp7_ = NULL;
		_tmp7_ = l;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_stack_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean a = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean b = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_is_smd_loop_configured (self);
	a = _tmp0_;
	_tmp1_ = smd_applet_is_smd_pushpull_configured (self);
	b = _tmp1_;
	_tmp3_ = a;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = b;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	result = _tmp5_;
	return result;
}


static void smd_applet_update_loglist (smdApplet* self) {
	GtkTextView* tv = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkTextView* _tmp2_ = NULL;
	GtkTextBuffer* b = NULL;
	GtkTextView* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "tvLog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GTK_TYPE_TEXT_VIEW) ? ((GtkTextView*) _tmp1_) : NULL);
	tv = _tmp2_;
	_tmp3_ = tv;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	b = _tmp5_;
	{
		GDir* d = NULL;
		const gchar* _tmp6_ = NULL;
		GDir* _tmp7_ = NULL;
		gchar* file = NULL;
		GeeArrayList* new_lognames = NULL;
		GEqualFunc _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		gboolean _tmp16_ = FALSE;
		GeeArrayList* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp6_ = SMD_LOGS_DIR;
		_tmp7_ = g_dir_open (_tmp6_, (guint) 0, &_inner_error_);
		d = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch17_g_file_error;
			}
			_g_object_unref0 (b);
			_g_object_unref0 (tv);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = g_str_equal;
		_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp8_);
		new_lognames = _tmp9_;
		while (TRUE) {
			GDir* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			GeeArrayList* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp10_ = d;
			_tmp11_ = g_dir_read_name (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (file);
			file = _tmp12_;
			_tmp13_ = file;
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = new_lognames;
			_tmp15_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
		}
		_tmp17_ = new_lognames;
		_tmp18_ = self->priv->lognames;
		_tmp19_ = gee_abstract_collection_contains_all ((GeeAbstractCollection*) _tmp17_, (GeeCollection*) _tmp18_);
		if (!_tmp19_) {
			_tmp16_ = TRUE;
		} else {
			GeeArrayList* _tmp20_ = NULL;
			GeeArrayList* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = self->priv->lognames;
			_tmp21_ = new_lognames;
			_tmp22_ = gee_abstract_collection_contains_all ((GeeAbstractCollection*) _tmp20_, (GeeCollection*) _tmp21_);
			_tmp16_ = !_tmp22_;
		}
		_tmp23_ = _tmp16_;
		if (_tmp23_) {
			GtkComboBoxText* _tmp24_ = NULL;
			GtkTreeModel* _tmp25_ = NULL;
			GeeArrayList* _tmp26_ = NULL;
			GeeArrayList* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			_tmp24_ = self->priv->cblogs;
			_tmp25_ = gtk_combo_box_get_model ((GtkComboBox*) _tmp24_);
			gtk_list_store_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_LIST_STORE, GtkListStore));
			_tmp26_ = self->priv->lognames;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp26_);
			{
				GeeArrayList* _f_list = NULL;
				GeeArrayList* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				gint _f_size = 0;
				GeeArrayList* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _f_index = 0;
				_tmp27_ = new_lognames;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_f_list = _tmp28_;
				_tmp29_ = _f_list;
				_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_f_size = _tmp31_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gchar* f = NULL;
					GeeArrayList* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gpointer _tmp37_ = NULL;
					GeeArrayList* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					GtkComboBoxText* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					_tmp32_ = _f_index;
					_f_index = _tmp32_ + 1;
					_tmp33_ = _f_index;
					_tmp34_ = _f_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _f_list;
					_tmp36_ = _f_index;
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
					f = (gchar*) _tmp37_;
					_tmp38_ = self->priv->lognames;
					_tmp39_ = f;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, _tmp39_);
					_tmp40_ = self->priv->cblogs;
					_tmp41_ = f;
					gtk_combo_box_text_append_text (_tmp40_, _tmp41_);
					_g_free0 (f);
				}
				_g_object_unref0 (_f_list);
			}
			_tmp42_ = self->priv->lognames;
			_tmp43_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ == 0) {
				GtkTextBuffer* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				_tmp45_ = b;
				_tmp46_ = SMD_LOGS_DIR;
				_tmp47_ = g_strdup_printf ("No logs in %s", _tmp46_);
				_tmp48_ = _tmp47_;
				gtk_text_buffer_set_text (_tmp45_, _tmp48_, -1);
				_g_free0 (_tmp48_);
			} else {
				GtkComboBoxText* _tmp49_ = NULL;
				GtkComboBoxText* _tmp50_ = NULL;
				_tmp49_ = self->priv->cblogs;
				gtk_combo_box_set_title ((GtkComboBox*) _tmp49_, "Choose log file");
				_tmp50_ = self->priv->cblogs;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp50_, 0);
			}
		}
		_g_object_unref0 (new_lognames);
		_g_free0 (file);
		_g_dir_close0 (d);
	}
	goto __finally17;
	__catch17_g_file_error:
	{
		GError* e = NULL;
		GtkTextBuffer* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = b;
		_tmp52_ = SMD_LOGS_DIR;
		_tmp53_ = g_strdup_printf ("Unable to list directory %s", _tmp52_);
		_tmp54_ = _tmp53_;
		gtk_text_buffer_set_text (_tmp51_, _tmp54_, -1);
		_g_free0 (_tmp54_);
		_g_error_free0 (e);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (tv);
}


static void smd_applet_update_logcontents (smdApplet* self) {
	gint selected = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cblogs;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	selected = _tmp1_;
	_tmp2_ = selected;
	if (_tmp2_ >= 0) {
		gchar* file = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gpointer _tmp5_ = NULL;
		gchar* content = NULL;
		_tmp3_ = self->priv->lognames;
		_tmp4_ = selected;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
		file = (gchar*) _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = SMD_LOGS_DIR;
			_tmp8_ = file;
			_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			_tmp12_ = g_file_get_contents (_tmp10_, &_tmp11_, NULL, &_inner_error_);
			_g_free0 (content);
			content = _tmp11_;
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp10_);
			_tmp6_ = _tmp13_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch18_g_file_error;
				}
				_g_free0 (content);
				_g_free0 (file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			if (_tmp6_) {
				GtkTextView* tv = NULL;
				GtkBuilder* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkTextView* _tmp16_ = NULL;
				GtkTextBuffer* b = NULL;
				GtkTextView* _tmp17_ = NULL;
				GtkTextBuffer* _tmp18_ = NULL;
				GtkTextBuffer* _tmp19_ = NULL;
				GtkTextIter end_iter = {0};
				GtkTextIter start_iter = {0};
				GtkTextBuffer* _tmp20_ = NULL;
				GtkTextIter _tmp21_ = {0};
				GtkTextBuffer* _tmp22_ = NULL;
				GtkTextIter _tmp23_ = {0};
				const gchar* _tmp24_ = NULL;
				GtkTextBuffer* _tmp25_ = NULL;
				GtkTextIter _tmp26_ = {0};
				GtkTextIter _tmp27_ = {0};
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp14_ = self->priv->builder;
				_tmp15_ = gtk_builder_get_object (_tmp14_, "tvLog");
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GTK_TYPE_TEXT_VIEW) ? ((GtkTextView*) _tmp15_) : NULL);
				tv = _tmp16_;
				_tmp17_ = tv;
				_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
				_tmp19_ = _g_object_ref0 (_tmp18_);
				b = _tmp19_;
				_tmp20_ = b;
				gtk_text_buffer_get_end_iter (_tmp20_, &_tmp21_);
				end_iter = _tmp21_;
				_tmp22_ = b;
				gtk_text_buffer_get_start_iter (_tmp22_, &_tmp23_);
				start_iter = _tmp23_;
				_tmp24_ = content;
				_tmp25_ = b;
				_tmp26_ = start_iter;
				_tmp27_ = end_iter;
				_tmp28_ = gtk_text_buffer_get_text (_tmp25_, &_tmp26_, &_tmp27_, FALSE);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strcmp0 (_tmp24_, _tmp29_) != 0;
				_g_free0 (_tmp29_);
				if (_tmp30_) {
					GtkTextBuffer* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GtkTextBuffer* _tmp33_ = NULL;
					GtkTextIter _tmp34_ = {0};
					GtkTextView* _tmp35_ = NULL;
					GtkTextIter _tmp36_ = {0};
					_tmp31_ = b;
					_tmp32_ = content;
					gtk_text_buffer_set_text (_tmp31_, _tmp32_, -1);
					_tmp33_ = b;
					gtk_text_buffer_get_end_iter (_tmp33_, &_tmp34_);
					end_iter = _tmp34_;
					_tmp35_ = tv;
					_tmp36_ = end_iter;
					gtk_text_view_scroll_to_iter (_tmp35_, &_tmp36_, 0.0, TRUE, 0.0, 0.0);
				}
				_g_object_unref0 (b);
				_g_object_unref0 (tv);
			} else {
				FILE* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				_tmp37_ = stderr;
				_tmp38_ = SMD_LOGS_DIR;
				_tmp39_ = file;
				_tmp40_ = g_strconcat (_tmp38_, _tmp39_, NULL);
				_tmp41_ = _tmp40_;
				fprintf (_tmp37_, "Unable to read %s\n", _tmp41_);
				_g_free0 (_tmp41_);
			}
		}
		goto __finally18;
		__catch18_g_file_error:
		{
			GError* e = NULL;
			FILE* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			GError* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp42_ = stderr;
			_tmp43_ = SMD_LOGS_DIR;
			_tmp44_ = file;
			_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
			_tmp46_ = _tmp45_;
			_tmp47_ = e;
			_tmp48_ = _tmp47_->message;
			fprintf (_tmp42_, "Unable to read %s: %s\n", _tmp46_, _tmp48_);
			_g_free0 (_tmp46_);
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
		_g_free0 (file);
	}
}


static gboolean _smd_applet_eat_event_gsource_func (gpointer self) {
	gboolean result;
	result = smd_applet_eat_event (self);
	return result;
}


static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_prefs_event (self, event);
	return result;
}


static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_err_event (self, event);
	return result;
}


static void ___lambda15_ (smdApplet* self, NotifyNotification* n, const gchar* a) {
	GtkStatusIcon* _tmp0_ = NULL;
	g_return_if_fail (n != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->si;
	g_signal_emit_by_name (_tmp0_, "activate");
}


static void ____lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	___lambda15_ (self, notification, action);
}


void smd_applet_start (smdApplet* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GThread* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _smd_applet_eat_event_gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp0_) {
		smd_applet_start_smdThread (self, FALSE);
	} else {
		self->priv->config_wait_mode = TRUE;
	}
	_tmp1_ = self->priv->win;
	g_signal_connect_object ((GtkWidget*) _tmp1_, "delete-event", (GCallback) _smd_applet_close_prefs_event_gtk_widget_delete_event, self, 0);
	_tmp2_ = self->priv->err_win;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "delete-event", (GCallback) _smd_applet_close_err_event_gtk_widget_delete_event, self, 0);
	_tmp3_ = self->priv->config_wait_mode;
	if (_tmp3_) {
		GtkStatusIcon* _tmp5_ = NULL;
		GtkStatusIcon* _tmp6_ = NULL;
		GtkStatusIcon* _tmp7_ = NULL;
		NotifyNotification* _tmp9_ = NULL;
		NotifyNotification* _tmp10_ = NULL;
		GVariant* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		NotifyNotification* _tmp13_ = NULL;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = gtk_events_pending ();
			if (!_tmp4_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp5_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp5_, FALSE);
		sleep ((guint) 5);
		_tmp6_ = self->priv->si;
		gtk_status_icon_set_visible (_tmp6_, TRUE);
		_tmp7_ = self->priv->si;
		gtk_status_icon_set_from_icon_name (_tmp7_, "error");
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = gtk_events_pending ();
			if (!_tmp8_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp9_ = notify_notification_new ("Syncmaildir", "Syncmaildir is not configured properly.", "dialog-error");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp9_;
		_tmp10_ = self->priv->notification;
		_tmp11_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		notify_notification_set_hint (_tmp10_, "transient", _tmp12_);
		_g_variant_unref0 (_tmp12_);
		_tmp13_ = self->priv->notification;
		notify_notification_add_action (_tmp13_, "configure", "Configure now", ____lambda15__notify_action_callback, g_object_ref (self), g_object_unref);
		{
			NotifyNotification* _tmp14_ = NULL;
			_tmp14_ = self->priv->notification;
			notify_notification_show (_tmp14_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
			FILE* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = stderr;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			fprintf (_tmp15_, "%s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	g_application_run ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication), 0, NULL);
	_tmp18_ = self->priv->thread;
	if (_tmp18_ != NULL) {
		GThread* _tmp19_ = NULL;
		_tmp19_ = self->priv->thread;
		g_thread_join (_tmp19_);
	}
}


static void smd_applet_class_init (smdAppletClass * klass) {
	gchar* _tmp0_ = NULL;
	smd_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (smdAppletPrivate));
	G_OBJECT_CLASS (klass)->finalize = smd_applet_finalize;
	_tmp0_ = g_strdup ("\n" \
"\t<interface>\n" \
"\t  <menu id='app-menu'>\n" \
"\t    <section>\n" \
"\t      <item>\n" \
"\t        <attribute name='label' translatable='yes'>_Quit</attribute>" \
"\n" \
"\t        <attribute name='action'>app.quit</attribute>\n" \
"\t      </item>\n" \
"\t    </section>\n" \
"\t  </menu>\n" \
"\t</interface>\n" \
"\t");
	smd_applet_menu_ui = _tmp0_;
}


static void smd_applet_instance_init (smdApplet * self) {
	GMutex _tmp0_ = {0};
	self->priv = SMD_APPLET_GET_PRIVATE (self);
	self->priv->builder = NULL;
	self->priv->si = NULL;
	self->priv->win = NULL;
	self->priv->err_win = NULL;
	self->priv->notebook = NULL;
	self->priv->sync_active = NULL;
	self->priv->cblogs = NULL;
	self->priv->lognames = NULL;
	self->priv->settings = NULL;
	self->priv->thread = NULL;
	self->priv->thread_die = FALSE;
	g_mutex_init (&_tmp0_);
	self->priv->events_lock = _tmp0_;
	self->priv->events = NULL;
	self->priv->error_mode = FALSE;
	self->priv->network_error_mode = FALSE;
	self->priv->command_hash = NULL;
	self->priv->net_manager = NULL;
	self->priv->notification = NULL;
	self->priv->notification_server_has_persistence = FALSE;
}


static void smd_applet_finalize (GObject* obj) {
	smdApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SMD_APPLET, smdApplet);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->si);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->err_win);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->sync_active);
	_g_object_unref0 (self->priv->cblogs);
	_g_object_unref0 (self->priv->lognames);
	_g_object_unref0 (self->priv->settings);
	_g_thread_unref0 (self->priv->thread);
	_vala_clear_GMutex (&self->priv->events_lock);
	_g_object_unref0 (self->priv->events);
	_g_hash_table_unref0 (self->priv->command_hash);
	_g_object_unref0 (self->priv->net_manager);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (smd_applet_parent_class)->finalize (obj);
}


GType smd_applet_get_type (void) {
	static volatile gsize smd_applet_type_id__volatile = 0;
	if (g_once_init_enter (&smd_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (smdAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) smd_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (smdApplet), 0, (GInstanceInitFunc) smd_applet_instance_init, NULL };
		GType smd_applet_type_id;
		smd_applet_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "smdApplet", &g_define_type_info, 0);
		g_once_init_leave (&smd_applet_type_id__volatile, smd_applet_type_id);
	}
	return smd_applet_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* PREFIX = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gchar* homedir = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* conf_home = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GOptionEntry* oe = NULL;
	GOptionEntry _tmp46_ = {0};
	GOptionEntry _tmp47_ = {0};
	GOptionEntry _tmp48_ = {0};
	GOptionEntry* _tmp49_ = NULL;
	gint oe_length1 = 0;
	gint _oe_size_ = 0;
	GOptionContext* oc = NULL;
	GOptionContext* _tmp50_ = NULL;
	GOptionContext* _tmp51_ = NULL;
	GOptionEntry* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (SMD_CONF_PREFIX);
	PREFIX = _tmp0_;
	_tmp1_ = PREFIX;
	_tmp2_ = g_strconcat (_tmp1_, SMD_APPLET_UI, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	_tmp5_ = !_tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		FILE* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		FILE* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = PREFIX;
		fprintf (_tmp6_, "error: file not found: %s + %s\n", _tmp7_, SMD_APPLET_UI);
		_tmp8_ = g_strdup ("./smd-loop");
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp8_;
		_tmp9_ = stderr;
		_tmp10_ = smd_applet_smd_loop_cmd;
		fprintf (_tmp9_, "smd-applet not installed, " "assuming smd-loop is: %s\n", _tmp10_);
		_tmp11_ = g_strdup ("./smd-applet.ui");
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp11_;
		_tmp12_ = stderr;
		_tmp13_ = smd_applet_smd_applet_ui;
		fprintf (_tmp12_, "smd-applet not installed, " "assuming smd-applet.ui is: %s\n", _tmp13_);
		_tmp14_ = g_strdup ("./smd-push");
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp14_;
		_tmp15_ = stderr;
		_tmp16_ = smd_applet_smd_push_cmd;
		fprintf (_tmp15_, "smd-applet not installed, " "assuming smd-push is: %s\n", _tmp16_);
		_tmp17_ = g_strdup ("./smd-applet.desktop");
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp17_;
		_tmp18_ = stderr;
		_tmp19_ = smd_applet_smd_applet_desktop;
		fprintf (_tmp18_, "smd-applet not installed, " "assuming smd-applet.desktop is: %s\n", _tmp19_);
	} else {
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		_tmp20_ = PREFIX;
		_tmp21_ = g_strconcat (_tmp20_, SMD_LOOP, NULL);
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp21_;
		_tmp22_ = PREFIX;
		_tmp23_ = g_strconcat (_tmp22_, SMD_PUSH, NULL);
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp23_;
		_tmp24_ = PREFIX;
		_tmp25_ = g_strconcat (_tmp24_, SMD_APPLET_UI, NULL);
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp25_;
		_tmp26_ = PREFIX;
		_tmp27_ = g_strconcat (_tmp26_, SMD_APPLET_DESKTOP, NULL);
		_g_free0 (smd_applet_smd_applet_desktop);
		smd_applet_smd_applet_desktop = _tmp27_;
	}
	_tmp28_ = g_get_home_dir ();
	_tmp29_ = g_strdup (_tmp28_);
	homedir = _tmp29_;
	_tmp30_ = homedir;
	_tmp31_ = g_strconcat (_tmp30_, "/.smd/log/", NULL);
	_g_free0 (SMD_LOGS_DIR);
	SMD_LOGS_DIR = _tmp31_;
	_tmp32_ = homedir;
	_tmp33_ = g_strconcat (_tmp32_, "/.smd/loop", NULL);
	_g_free0 (SMD_LOOP_CFG);
	SMD_LOOP_CFG = _tmp33_;
	_tmp34_ = homedir;
	_tmp35_ = g_strconcat (_tmp34_, "/.smd/config.default", NULL);
	_g_free0 (SMD_PP_DEF_CFG);
	SMD_PP_DEF_CFG = _tmp35_;
	_tmp36_ = g_getenv ("XDG_CONFIG_HOME");
	_tmp37_ = g_strdup (_tmp36_);
	conf_home = _tmp37_;
	_tmp38_ = conf_home;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp39_ = conf_home;
		_tmp40_ = g_strconcat (_tmp39_, "/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp40_;
	} else {
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp41_ = homedir;
		_tmp42_ = g_strconcat (_tmp41_, "/.config/autostart/smd-applet.desktop", NULL);
		_g_free0 (XDG_AUTORUN_FILE);
		XDG_AUTORUN_FILE = _tmp42_;
	}
	_tmp43_ = XDG_AUTORUN_FILE;
	_tmp44_ = g_path_get_dirname (_tmp43_);
	_tmp45_ = _tmp44_;
	g_mkdir_with_parents (_tmp45_, 0700);
	_g_free0 (_tmp45_);
	gtk_init (&args_length1, &args);
	notify_init ("smd-applet");
	memset (&_tmp46_, 0, sizeof (GOptionEntry));
	_tmp46_.long_name = "verbose";
	_tmp46_.short_name = 'v';
	_tmp46_.flags = 0;
	_tmp46_.arg = G_OPTION_ARG_NONE;
	_tmp46_.arg_data = &verbose;
	_tmp46_.description = "verbose output, for debugging only";
	_tmp46_.arg_description = NULL;
	memset (&_tmp47_, 0, sizeof (GOptionEntry));
	_tmp47_.long_name = "smd-loop";
	_tmp47_.short_name = 'l';
	_tmp47_.flags = 0;
	_tmp47_.arg = G_OPTION_ARG_STRING;
	_tmp47_.arg_data = &smd_applet_smd_loop_cmd;
	_tmp47_.description = "override smd-loop command name, debugging only";
	_tmp47_.arg_description = "program";
	memset (&_tmp48_, 0, sizeof (GOptionEntry));
	_tmp48_.long_name = NULL;
	_tmp49_ = g_new0 (GOptionEntry, 3);
	_tmp49_[0] = _tmp46_;
	_tmp49_[1] = _tmp47_;
	_tmp49_[2] = _tmp48_;
	oe = _tmp49_;
	oe_length1 = 3;
	_oe_size_ = oe_length1;
	_tmp50_ = g_option_context_new (" - syncmaildir applet");
	oc = _tmp50_;
	_tmp51_ = oc;
	_tmp52_ = oe;
	_tmp52__length1 = oe_length1;
	g_option_context_add_main_entries (_tmp51_, _tmp52_, NULL);
	{
		GOptionContext* _tmp53_ = NULL;
		_tmp53_ = oc;
		g_option_context_parse (_tmp53_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch20_g_option_error;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally20;
	__catch20_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp54_ = NULL;
		GError* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp54_ = stderr;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		fprintf (_tmp54_, "%s\n", _tmp56_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally20:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		smdApplet* smd_applet = NULL;
		smdApplet* _tmp57_ = NULL;
		smdApplet* _tmp58_ = NULL;
		_tmp57_ = smd_applet_new (&_inner_error_);
		smd_applet = _tmp57_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				goto __catch21_exit;
			}
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp58_ = smd_applet;
		smd_applet_start (_tmp58_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (smd_applet);
			if (_inner_error_->domain == EXIT) {
				goto __catch21_exit;
			}
			_g_object_unref0 (smd_applet);
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (conf_home);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (smd_applet);
	}
	goto __finally21;
	__catch21_exit:
	{
		GError* e = NULL;
		FILE* _tmp59_ = NULL;
		GError* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp59_ = stderr;
		_tmp60_ = e;
		_tmp61_ = _tmp60_->message;
		fprintf (_tmp59_, "abort: %s\n", _tmp61_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (conf_home);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (oc);
	oe = (g_free (oe), NULL);
	_g_free0 (conf_home);
	_g_free0 (homedir);
	_g_free0 (PREFIX);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



