/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "frmutils.h"
#include <kapp.h>
frmUtils::frmUtils(QWidget* parent, const char* name, bool modal, WFlags fl)
                : KDialogBase( parent, name, modal, i18n("Conversion tool"), User1 | Cancel, User1 )
{
	fl=fl;
	d = new dlgUtils(this); 
	this->setMainWidget(d);

	setButtonGuiItem(User1, KGuiItem(i18n("Start"), "run"));
	
	d->btnSource->setPixmap(SmallIcon("fileopen"));
	d->btnDest->setPixmap(SmallIcon("fileopen"));

	d->cmbDestination->clear();
	// As .swl files are pre-selected (default):
	d->cmbDestination->insertItem(getFileString(shpFile));
	d->cmbDestination->insertItem(getFileString(nsfFile));
	destinationChanged(0);

	connect( d->btnSource, SIGNAL( clicked() ), this, SLOT( FindSource() ) );
	connect( d->btnDest,   SIGNAL( clicked() ), this, SLOT( FindDest() ) );
	connect( d->cmbOrigin, SIGNAL( activated(int) ), this, SLOT( originChanged(int) ) );
	connect( d->cmbDestination, SIGNAL( activated(int) ), this, SLOT( destinationChanged(int) ) );
}

frmUtils::~frmUtils()
{
	qDebug ("Deleting dlgUtils...");
	delete d;
}

QString frmUtils::getFileString(int i)
{
	switch (i)
	{
		case 0: // swsFile
			return i18n("SWScanner files") + " (*.sws)";
			break;
		case 1: // swlFile
			return i18n("SWScanner GPS Log files") + " (*.swl)";
			break;
		case 2: //nsfFile
			return i18n("NetStumbler summary files") + " (*.nsf)";
			break;
		case 3: //shpFile
			return i18n("ESRI Shapefiles") + " (*.shp *.shx *.dbf)";
			break;
	}
	// default: only to avoid warning
	return i18n("SWScanner files") + "(*.sws)";
}

void frmUtils::FindDest()
{
	QString type, source;
	switch(d->cmbOrigin->currentItem())
	{
		case 0: 
			if (d->cmbDestination->currentItem() == 0)
			{
				type = "*.shp *.shx *.dbf|" + getFileString(shpFile);
				source = ":<shapefiles>";
			}
			else
			{
				type = "*.nsf|" + getFileString(nsfFile);
				source = ":<swsfiles>";
			}
			break;
		case 1:
			if (d->cmbDestination->currentItem() == 0)
			{
				type = "*.shp *.shx *.dbf|" + getFileString(shpFile);
				source = ":<shapefiles>";
			}
			else
			{
				type = "*.sws|" + getFileString(swsFile);
				source = ":<swsfiles>";
			}
			break;
		case 2:
			type = "*.nsf|" + getFileString(nsfFile);
			source = ":<swsfiles>";
			break;
	}


	d->txtDest->setText(KFileDialog::getSaveFileName(
        	source, 
        	type,
        	this,
        	i18n("Choose a filename to save")));
}

void frmUtils::FindSource()
{
	QString type, source;
	switch(d->cmbOrigin->currentItem())
	{
		case 0: 
			type = "*.swl|" + getFileString(swlFile);
			source = ":<swslogfiles>";
			break;
		case 1:
			type = "*.nsf|" + getFileString(nsfFile);
			source = ":<swsfiles>";
			break;
		case 2:
			type = "*.sws|" + getFileString(swsFile);
			source = ":<swsfiles>";
			break;
	}

	d->txtSource->setText(KFileDialog::getOpenFileName(
        	source, 
        	type,
        	this,
        	i18n("Choose a filename to open")));
}

void frmUtils::destinationChanged(int destItem)
{
	// Clear previous filenames:
	d->txtDest->clear();

	switch (d->cmbOrigin->currentItem())
	{
		case 0: //swl
			if (destItem == 0)
				d->lblDestination->setText(i18n("Select an ESRI Shapefile:"));
			else
				d->lblDestination->setText(i18n("Select a NetStumbler summary file:"));
			break;
		case 1: //nsf
			if (destItem == 0)
				d->lblDestination->setText(i18n("Select an ESRI Shapefile:"));
			else
				d->lblDestination->setText(i18n("Select a SWScanner file:"));
			break;
		case 2: //sws
				d->lblDestination->setText(i18n("Select a NetStumbler summary file:"));
			break;
	}
}

void frmUtils::originChanged(int i)
{
	// Restart destination combobox:
	d->cmbDestination->clear();
// 	// Clear previous filenames:
	d->txtSource->clear();

	switch (i)
	{
		case 0: 
			d->lblSource->setText(i18n("Select a SWScanner GPS log file (NetStumbler txt log compatible):")); 
			d->cmbDestination->insertItem(getFileString(shpFile));
			d->cmbDestination->insertItem(getFileString(nsfFile));
			break;
		case 1:
			d->lblSource->setText(i18n("Select a NetStumbler summary file:"));
			d->cmbDestination->insertItem(getFileString(shpFile));
			d->cmbDestination->insertItem(getFileString(swsFile));
			break;
		case 2:
			d->lblSource->setText(i18n("Select a SWScanner file:"));
			d->cmbDestination->insertItem(getFileString(nsfFile));
			break;
	}
	destinationChanged(0);
}

void frmUtils::slotUser1()
{
	QFile source, dest;
	bool error = FALSE;

	// Necessary to complete both origin and destiny to continue
	if ( d->txtSource->text() == "" || d->txtDest->text() == "") 
	{
		KMessageBox::information( this, i18n("It's needed to select both source and destination files."));
		return;
	}

	source.setName(d->txtSource->text());
	dest.setName(d->txtDest->text());

	APList * list = new APList();
	switch(d->cmbOrigin->currentItem())
	{
		case 0: //.swl
			if (fileHandler::readFromSWL(&source, list) == 0)
			{
				if (d->cmbDestination->currentItem() == 0)
				{ //.swl => shapefile
					if (fileHandler::writeShapeFile(&dest, list) != 0)
						error = TRUE;
				}
				else
				{ //.swl => .nsf
					if (fileHandler::writeToNSF(&dest, list) != 0)
						error = TRUE;
				}
			}
			else
			{
				error = TRUE;
			}
			break;
		case 1: //.nsf
			if (fileHandler::readFromNSF(&source, list) == 0)
			{
				if (d->cmbDestination->currentItem() == 0)
				{ //.nsf => shapefile
					if (fileHandler::writeShapeFile(&dest, list) != 0)
						error = TRUE;
				}
				else
				{ //.nsf => .sws
					if (fileHandler::writeToSWS(&dest, list) != 0)
						error = TRUE;
				}
			}
			else
			{
				error = TRUE;
			}
			break;
		case 2: //.sws => .nsf
			if ( KMessageBox::warningContinueCancel( 0, 
								i18n("Although using 'nsf' format will allow you to open this\n"
								"file with NetStumbler, take into account that no geographical\n"
								"data will be saved on it " )) == KMessageBox::Cancel )
				return;
			if (fileHandler::readFromSWS(&source, list) == 0)
			{
				if (fileHandler::writeToNSF(&dest, list) != 0)
				{
					error = TRUE;
				}
			}
			else
			{
				error = TRUE;
			}
			break;
	}
	delete list;
	if (!error)
	{
		KMessageBox::information(0, i18n("Conversion successfully finished"));
	}
}

#include "frmutils.moc"

