//
// C++ Interface: configpopupmenu
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CONFIGPOPUPMENU_H
#define CONFIGPOPUPMENU_H

#include <kpopupmenu.h>
#include <klocale.h>
#include <kaction.h>
#include <kmainwindow.h>
#include <kactioncollection.h>

#include "frmconfig.h"

/**
@author Ivn Forcada Atienza
*/

class configPopupMenu : public KPopupMenu
{
private:
	QString essid;
	QString mac;
	QString iface;

	KActionCollection * 	apActions;
	KAction *		asociateAction;
	KAction *		changeAction;
	KAction *		removeAction;
	KAction *		configureAction;
	KAction *		showChartAction;
	
	bool	wep;
	bool	shownConfiguredMenu;

public:
	configPopupMenu(QWidget *parent=0, 
			const char *name=0, 
			QString essid = QString::null, 
			QString mac = QString::null, 
			bool wep = false, 
			QString iface= QString::null);

	~configPopupMenu();
	
	void update();
	bool getshownConfiguredMenu() { return shownConfiguredMenu; };
	KActionPtrList actions() { return apActions->actions(); };
	
private:
	bool isConfigured(QString essid, QString mac);
	void AddMenu(bool configured);

};
#endif
