/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "UtfTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "util/utf.h"

// svn
#include <svn_io.h>



UtfTest::UtfTest() : CppUnit::TestCase("UtfTest")
{
}

UtfTest::~UtfTest()
{
}

void UtfTest::setUp()
{
}

void UtfTest::tearDown()
{
}


CppUnit::Test *UtfTest::suite()
{
  CppUnit::TestSuite *newSuite = new CppUnit::TestSuite("FileTest");

  newSuite->addTest(new CppUnit::TestCaller<UtfTest>("testUtf8",&UtfTest::testUtf8) );
  newSuite->addTest(new CppUnit::TestCaller<UtfTest>("testUtf32be",&UtfTest::testUtf32be) );
  newSuite->addTest(new CppUnit::TestCaller<UtfTest>("testUtf32le",&UtfTest::testUtf32le) );
  newSuite->addTest(new CppUnit::TestCaller<UtfTest>("testUtf16be",&UtfTest::testUtf16be) );
  newSuite->addTest(new CppUnit::TestCaller<UtfTest>("testUtf16le",&UtfTest::testUtf16le) );

  return newSuite;
}


void UtfTest::testUtf8()
{
  svn_error_t*     err;
  svn_stringbuf_t* filebuf = NULL;

  err = svn_stringbuf_from_file( &filebuf, "../../tests/util/files/utf/utf-8.txt", _pool );

  CPPUNIT_ASSERT( err == SVN_NO_ERROR );

  utf utf8( (const unsigned char*)filebuf->data, filebuf->len );

  CPPUNIT_ASSERT( utf8.hasEncoding() );
  CPPUNIT_ASSERT_EQUAL( sc::String("utf-8"), utf8.getEncoding() );

  CPPUNIT_ASSERT( utf8.hasBom() );
  CPPUNIT_ASSERT( ! utf8.isBigEndian() );
  CPPUNIT_ASSERT( ! utf8.isLittleEndian() );
}

void UtfTest::testUtf32be()
{
  svn_error_t*     err;
  svn_stringbuf_t* filebuf = NULL;

  err = svn_stringbuf_from_file( &filebuf, "../../tests/util/files/utf/utf-32be.txt", _pool );

  CPPUNIT_ASSERT( err == SVN_NO_ERROR );

  utf utf( (const unsigned char*)filebuf->data, filebuf->len );

  CPPUNIT_ASSERT( utf.hasEncoding() );
  CPPUNIT_ASSERT_EQUAL( sc::String("utf-32be"), utf.getEncoding() );

  CPPUNIT_ASSERT( utf.hasBom() );
  CPPUNIT_ASSERT( utf.isBigEndian() );
  CPPUNIT_ASSERT( ! utf.isLittleEndian() );
}

void UtfTest::testUtf32le()
{
  svn_error_t*     err;
  svn_stringbuf_t* filebuf = NULL;

  err = svn_stringbuf_from_file( &filebuf, "../../tests/util/files/utf/utf-32le.txt", _pool );

  CPPUNIT_ASSERT( err == SVN_NO_ERROR );

  utf utf( (const unsigned char*)filebuf->data, filebuf->len );

  CPPUNIT_ASSERT( utf.hasEncoding() );
  CPPUNIT_ASSERT_EQUAL( sc::String("utf-32le"), utf.getEncoding() );

  CPPUNIT_ASSERT( utf.hasBom() );
  CPPUNIT_ASSERT( ! utf.isBigEndian() );
  CPPUNIT_ASSERT( utf.isLittleEndian() );
}   

void UtfTest::testUtf16be()
{
  svn_error_t*     err;
  svn_stringbuf_t* filebuf = NULL;

  err = svn_stringbuf_from_file( &filebuf, "../../tests/util/files/utf/utf-16be.txt", _pool );

  CPPUNIT_ASSERT( err == SVN_NO_ERROR );

  utf utf( (const unsigned char*)filebuf->data, filebuf->len );

  CPPUNIT_ASSERT( utf.hasEncoding() );
  CPPUNIT_ASSERT_EQUAL( sc::String("utf-16be"), utf.getEncoding() );

  CPPUNIT_ASSERT( utf.hasBom() );
  CPPUNIT_ASSERT( utf.isBigEndian() );
  CPPUNIT_ASSERT( ! utf.isLittleEndian() );
}

void UtfTest::testUtf16le()
{
  svn_error_t*     err;
  svn_stringbuf_t* filebuf = NULL;

  err = svn_stringbuf_from_file( &filebuf, "../../tests/util/files/utf/utf-16le.txt", _pool );

  CPPUNIT_ASSERT( err == SVN_NO_ERROR );

  utf utf( (const unsigned char*)filebuf->data, filebuf->len );

  CPPUNIT_ASSERT( utf.hasEncoding() );
  CPPUNIT_ASSERT_EQUAL( sc::String("utf-16le"), utf.getEncoding() );

  CPPUNIT_ASSERT( utf.hasBom() );
  CPPUNIT_ASSERT( ! utf.isBigEndian() );
  CPPUNIT_ASSERT( utf.isLittleEndian() );
}

