/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "FileTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "util/Error.h"
#include "util/File.h"


FileTest::FileTest() : CppUnit::TestCase("FileTest")
{
}

FileTest::~FileTest()
{
}

void FileTest::setUp()
{
  _fileExists = new File( "../../tests/util/files/test.txt" );
  _fileNoFile = new File( "filedoesnotexist" );
}

void FileTest::tearDown()
{
  delete _fileExists;
  delete _fileNoFile;
}


CppUnit::Test *FileTest::suite()
{
  CppUnit::TestSuite *newSuite = new CppUnit::TestSuite("FileTest");

  newSuite->addTest(new CppUnit::TestCaller<FileTest>("testOpen",&FileTest::testOpen) );
  newSuite->addTest(new CppUnit::TestCaller<FileTest>("testMMap",&FileTest::testMMap) );

  return newSuite;
}


void FileTest::testOpen()
{
  const sc::Error* error;

  // try existing file..
  error = _fileExists->open();
  CPPUNIT_ASSERT_EQUAL( (const sc::Error*)sc::Success, error );
  error = _fileExists->close();
  CPPUNIT_ASSERT_EQUAL( (const sc::Error*)sc::Success, error );

  // try non existent file..
  error = _fileNoFile->open();
  CPPUNIT_ASSERT( error );

  // that does crash in apr...
  //status = _fileNoFile->close();
  //CPPUNIT_ASSERT( status != APR_SUCCESS );
}

void FileTest::testMMap()
{
  const sc::Error* error;

  error = _fileExists->open();
  error = _fileExists->mmap();
  CPPUNIT_ASSERT_EQUAL( (const sc::Error*)sc::Success, error );

  char*     buf  = (char*)_fileExists->mmaped();
  sc_size_t size = _fileExists->getSize();
  CPPUNIT_ASSERT_EQUAL( (sc_size_t)109, size );

  error = _fileExists->unmmap();
  CPPUNIT_ASSERT_EQUAL( (const sc::Error*)sc::Success, error );
  error = _fileExists->close();
  CPPUNIT_ASSERT_EQUAL( (const sc::Error*)sc::Success, error );
}