/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFDIALOGCMD_H
#define _SC_DIFFDIALOGCMD_H

// sc
class BaseModel;
class Project;
class DiffDialog;
namespace svn {
  class Revision;
}

// qt
#include <qobject.h>
#include <qstring.h>
class QWidget;

/**
 * Helper class to run a dialog based diff.
 */ 
class DiffDialogCmd : public QObject
{
  typedef QObject super;
  Q_OBJECT 

public:
  DiffDialogCmd( QWidget* parent, BaseModel* model, const Project* prj,
    bool enableSrc1, bool enableSrc2 );
  ~DiffDialogCmd();

  void run( const QString& src1, const QString& src2,
    const svn::Revision* first, const svn::Revision* second,
    bool folder );

public slots:
  void diff();
  void patch();
  void summarize();
  void close();

private:
  QWidget*       _parent;
  QObject*       _result;
  BaseModel*     _model;
  DiffDialog*    _dlg;

  const Project* _prj;
  bool           _enableSrc1;
  bool           _enableSrc2;
};

#endif // _SC_DIFFDIALOGCMD_H
