/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LogCmd.h"
#include "LogParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


LogCmd::LogCmd( LogParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

LogCmd::~LogCmd()
{
  delete _cb;
}

void LogCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->log( _param->getPathsOrUrls(), *_param->getStartRevision(),
    *_param->getStopRevision(), _param->getLimit(), _param->getChangedPaths(),
    _param->getStrictHistory(), _param->getBaton() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
