/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COPYPARAM_H
#define _SC_COPYPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "svn/CommitInfo.h"
#include "svn/Revision.h"
#include "util/String.h"


/**
 * Parameter class for CopyCmd.
 */
class CopyParam : public ScParam
{
public:
  CopyParam( const svn::Paths& srcPathsOrUrls, const svn::Revision* srcRev, const char* dstPathOrUrl )
    : _srcPathsOrUrls(srcPathsOrUrls), _srcRev(srcRev), _dstPathOrUrl(dstPathOrUrl)
  {
  }

  ~CopyParam()
  {
    delete _srcRev;
  }

  const svn::Paths& getSrcPathsOrUrls() const
  {
    return _srcPathsOrUrls;
  }

  const svn::Revision* getSrcRevision() const
  {
    return _srcRev;
  }

  const sc::String& getDstPathOrUrl() const
  {
    return _dstPathOrUrl;
  }

  svn::CommitInfo& getCommitInfo()
  {
    return _info;
  }

  ScParamAccept(CopyParam);

private:
  // in
  svn::Paths            _srcPathsOrUrls;
  const svn::Revision*  _srcRev;

  sc::String            _dstPathOrUrl;

  // out
  svn::CommitInfo       _info;
};

#endif // _SC_COPYPARAM_H
