/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORYDIALOG_H
#define _SC_REPOSITORYDIALOG_H

// sc
#include "sublib/TargetId.h"
class RepositoryModel;

// qt
#include <qdialog.h>
class QListView;
class QListViewItem;
class QPushButton;
class QPixmap;


/**
 * Dialog for selecting a repository url.
 */
class RepositoryDialog : public QDialog, public TargetId
{
  typedef QDialog super;
  Q_OBJECT 

public:
  RepositoryDialog( RepositoryModel* model, QWidget *parent = 0 );
  virtual ~RepositoryDialog();

  void customEvent( QCustomEvent* ce );

  void setSource( const QString& root );
  void setRootRep( const QString& root );
  QString getSelection();

  QListView* getListView();

  bool showDirsOnly();
  void setDirsOnly( bool );

  const QPixmap& getFolderPixmap() const;

public slots:
  void selectionChanged( QListViewItem* );
  void expanded( QListViewItem* );
  void parent();

private:
  void getRootDetails();

  RepositoryModel* _model;
  QString          _root;
  QString          _rootRep;

  bool             _dirsOnly;
  QListView*       _list;
  QPushButton*     _parent;

  QPixmap*         _folder;

  bool             _running;
};

#endif // _SC_REPOSITORYDIALOG_H
