/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CopyDialog.h"
#include "RevisionWidget.h"
#include "ExternProvider.h"
#include "commands/CopyParam.h"
#include "sublib/Gui.h"
#include "sublib/ExternButton.h"

// qt
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qfiledialog.h>
#include <qtooltip.h>
#include <qvbuttongroup.h>
#include <qradiobutton.h>



CopyDialog::CopyDialog( ExternProvider* p, QWidget *parent )
: super( parent, NULL, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ),
  _p(p)
{
  setCaption( _q("subcommander:copy") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("copy options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,3,3);
    gl->setMargin(0);
    gl->setRowStretch( 1, 1 );
    {
      {
        QLabel* l  = new QLabel(this);
        _src       = new QComboBox(this);
        _srcBrowse = new ExternButton(this);
        _srcBrowse->setEnabled(false);

        l->setBuddy(_srcBrowse);
        l->setText( _q("&source:") );
        _src->setEditable(true);
        _src->setAutoCompletion(true);

        gl->addWidget(l,0,0);
        gl->addWidget(_src,0,1); 
        gl->addWidget(_srcBrowse,0,2); 

        connect( _src, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _src, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _src, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        QToolTip::add( _src, _q("the source file/folder you like to copy") );
      }
      {
        _srcRev = new RevisionWidget(true,"SND","HBCP",0,this);
        _srcRev->setTitle( _q("select source revision: ") );
        gl->addWidget( _srcRev,1,1 );
        //gl->addMultiCellWidget( _srcRev, 1, 1, 1, 2 );
      }
      {
        QLabel* l  = new QLabel(this);
        _dstRoot   = new QComboBox(this);
        _dstBrowse = new ExternButton(this);
        _dstBrowse->setEnabled(false);

        l->setBuddy(_dstBrowse);
        l->setText( _q("&destination root:") );
        l->setFixedWidth( l->sizeHint().width() );
        _dstRoot->setEditable(true);
        _dstRoot->setAutoCompletion(true);

        gl->addWidget(l,2,0);
        gl->addWidget(_dstRoot,2,1); 
        gl->addWidget(_dstBrowse,2,2); 

        connect( _dstRoot, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _dstRoot, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _dstRoot, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _dstBrowse, SIGNAL(clicked()), SLOT(repExtern()) );

        QToolTip::add( _dstRoot,
          _q("the destination root folder where you like to copy the source to") );
      }
      {
        QLabel* l = new QLabel(this);
        _dstName  = new QComboBox(this);

        l->setBuddy(_dstName);
        l->setText( _q("&destination name:") );
        l->setFixedWidth( l->sizeHint().width() );
        _dstName->setEditable(true);
        _dstName->setAutoCompletion(true);
        _dstName->setFocus();

        gl->addWidget(l,3,0);
        gl->addWidget(_dstName,3,1); 

        connect( _dstName, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _dstName, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _dstName, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        //connect( pb, SIGNAL(clicked()), SLOT(selectWcPath()) );

        QToolTip::add( _dstName, _q("the name of the source in the destination root folder") );
      }
    }

#if 0
    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _srcRev = new RevisionWidget(true,RevisionWidget::Head,0,this);
      _srcRev->setTitle( "select source revision: " );
      h1->addWidget( _srcRev );
    }
#endif

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      ca->setDefault(false);
      hu->addWidget(ca);

      hu->addSpacing(getSizeGripSpacing());
      
      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

CopyDialog::~CopyDialog()
{
}

void CopyDialog::selectWcPath()
{
#if 0
  QString sel = QFileDialog::getExistingDirectory( _wc->currentText(), this, "",
    "select wc target path..." );

  if( ! sel.isNull() )
  {
    _wc->insertItem( sel, 0 );
  }
#endif
}

void CopyDialog::setSrcPathOrUrl( const QString& url )
{
  _src->insertItem( url, 0 );
}

QString CopyDialog::getSrcPathOrUrl()
{
  return _src->currentText();
}

void CopyDialog::setDstPathOrUrl( const QString& path )
{
  _dstRoot->insertItem( path, 0 );
}

QString CopyDialog::getDstPathOrUrl()
{
  return _dstRoot->currentText();
}

svn::Revision* CopyDialog::getRevision()
{
  return _srcRev->getRevision();
}

void CopyDialog::enableSrc( bool enable )
{
  _src->setEnabled(enable);
  _srcBrowse->setEnabled(enable);
}

void CopyDialog::enableDst( bool enable )
{
  _dstRoot->setEnabled(enable);
  _dstBrowse->setEnabled(enable);
}

void CopyDialog::checkOk( const QString& text )
{
  QString src     = _src->currentText();
  QString dstRoot = _dstRoot->currentText();
  QString dstName = _dstName->currentText();

  if( ! src.isEmpty() && ! dstRoot.isEmpty() && ! dstName.isEmpty() )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }
}

CopyParam* CopyDialog::getParameters() const
{
  svn::Paths paths;

  QString dst = _dstRoot->currentText() + "/" + _dstName->currentText();
  paths.push_back(sc::String(_src->currentText().utf8()));

  return new CopyParam( paths, _srcRev->getRevision(), dst.utf8() );
}

void CopyDialog::repExtern()
{
  sc::String res;

  if( _p->selectUrl( this, sc::String(_dstRoot->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _dstRoot->setCurrentText(QString::fromUtf8(res));
  }
}
