/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "sgtk-hig.h"
#include "st-general-preferences-page.h"
#include "st-preferences.h"
#include "st-settings.h"
#include "st-dialog-api.h"
#include "st-util.h"
#include "st-util-api.h"
#include "st-stock.h"

/*** type definitions ********************************************************/

struct _STGeneralPreferencesPagePrivate
{
  GtkWidget	*folder_entry;
};
  
/*** function declarations ***************************************************/

static void st_general_preferences_page_class_init (STGeneralPreferencesPageClass *class);
static void st_general_preferences_page_init (STGeneralPreferencesPage *page);

static void st_general_preferences_page_browse_clicked_h (GtkButton *button,
							  gpointer user_data);

/*** implementation **********************************************************/

GType
st_general_preferences_page_get_type (void)
{
  static GType type = 0;
  
  if (! type)
    {
      static const GTypeInfo info = {
	sizeof(STGeneralPreferencesPageClass),
	NULL,
	NULL,
	(GClassInitFunc) st_general_preferences_page_class_init,
	NULL,
	NULL,
	sizeof(STGeneralPreferencesPage),
	0,
	(GInstanceInitFunc) st_general_preferences_page_init,
      };

      type = g_type_register_static(ST_TYPE_PREFERENCES_PAGE,
				    "STGeneralPreferencesPage",
				    &info,
				    0);
    }

  return type;
}

static void
st_general_preferences_page_class_init (STGeneralPreferencesPageClass *class)
{
  g_type_class_add_private(class, sizeof(STGeneralPreferencesPagePrivate));
}

static void
st_general_preferences_page_init (STGeneralPreferencesPage *page)
{
  STPreferencesPage *ppage = ST_PREFERENCES_PAGE(page);
  GtkWidget *splash_enabled;
  GtkWidget *always_reload;
  GtkWidget *folder_hbox1;
  GtkWidget *folder_label;
  GtkWidget *folder_hbox2;
  GtkWidget *folder_button;

  page->priv = G_TYPE_INSTANCE_GET_PRIVATE(page, ST_TYPE_GENERAL_PREFERENCES_PAGE, STGeneralPreferencesPagePrivate);

  st_preferences_page_set_name(ppage, "general");
  st_preferences_page_set_stock_id(ppage, ST_STOCK_GENERAL);
  st_preferences_page_set_label(ppage, _("General"));
  st_preferences_page_set_help_link_id(ppage, "preferences-general");

  splash_enabled = gtk_check_button_new_with_mnemonic(_("Sh_ow splash screen at startup"));
  st_set_tooltip(splash_enabled, _("If this option is enabled, a splash screen will be shown when starting streamtuner."));

  always_reload = gtk_check_button_new_with_mnemonic(_("_Always reload categories"));
  st_set_tooltip(always_reload, _("If this option is enabled, categories will always be reloaded when you select them."));

  folder_hbox1 = gtk_hbox_new(FALSE, SGTK_HIG_CONTROL_LABEL_SPACING);
  folder_label = gtk_label_new_with_mnemonic(_("_Music folder:"));

  folder_hbox2 = gtk_hbox_new(FALSE, SGTK_HIG_CONTROL_SPACING);

  page->priv->folder_entry = gtk_entry_new();
  st_set_tooltip(page->priv->folder_entry, _("The path to your music collection"));

  gtk_label_set_mnemonic_widget(GTK_LABEL(folder_label), page->priv->folder_entry);

  folder_button = gtk_button_new_with_mnemonic(_("_Browse..."));
  g_signal_connect(folder_button, "clicked", G_CALLBACK(st_general_preferences_page_browse_clicked_h), page);

  gtk_box_pack_start(GTK_BOX(folder_hbox2), page->priv->folder_entry, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(folder_hbox2), folder_button, FALSE, FALSE, 0);
  
  gtk_box_pack_start(GTK_BOX(folder_hbox1), folder_label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(folder_hbox1), folder_hbox2, TRUE, TRUE, 0);

  st_preferences_bind_boolean(GTK_TOGGLE_BUTTON(splash_enabled), &st_settings.splash_enabled);
  st_preferences_bind_boolean(GTK_TOGGLE_BUTTON(always_reload), &st_settings.always_reload);
  st_preferences_bind_string(GTK_ENTRY(page->priv->folder_entry), &st_settings.music_dir);
 
  gtk_box_pack_start(GTK_BOX(page), splash_enabled, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(page), always_reload, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(page), folder_hbox1, FALSE, FALSE, 0);

  gtk_widget_show(splash_enabled);
  gtk_widget_show(always_reload);
  gtk_widget_show_all(folder_hbox1);
}

static void
st_general_preferences_page_browse_clicked_h (GtkButton *button,
					      gpointer user_data)
{
  STGeneralPreferencesPage *page = user_data;
  GtkWidget *toplevel;
  GtkWidget *chooser;
  const char *folder;

  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(page));
  chooser = gtk_file_chooser_dialog_new(_("Select a Music Folder"),
					GTK_WINDOW(toplevel),
					GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, 1,
					NULL);

  folder = gtk_entry_get_text(GTK_ENTRY(page->priv->folder_entry));
  if (*folder)
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(chooser), folder);

  if (gtk_dialog_run(GTK_DIALOG(chooser)) == 1)
    {
      char *filename;
      char *converted = NULL;

      filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser));
      if (filename)
	{
	  GError *err = NULL;

	  converted = g_filename_to_utf8(filename, -1, NULL, NULL, &err);
	  g_free(filename);

	  if (! converted)
	    {
	      st_notice(_("unable to convert filename to UTF-8 encoding: %s"), err->message);
	      g_error_free(err);
	    }
	}
      
      gtk_entry_set_text(GTK_ENTRY(page->priv->folder_entry), converted ? converted : "");
      g_free(converted);

      /* focus-out-event will not be emitted, so we have to commit manually */
      st_preferences_commit_string(GTK_ENTRY(page->priv->folder_entry));
    }

  gtk_widget_destroy(chooser);
}

STPreferencesPage *
st_general_preferences_page_new (void)
{
  return g_object_new(ST_TYPE_GENERAL_PREFERENCES_PAGE, NULL);
}
