#ifndef INC_STORMPKG_H
#define INC_STORMPKG_H

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#include "list.h"

/* Defines */

#define SEARCH_NAMES		0x01
#define SEARCH_DESCRIPTIONS	0x02

#define PACKAGES_UNINSTALLED	0x01
#define PACKAGES_INSTALLED	0x02

#define SHOW_PRIORITIES		0x01
#define SHOW_SECTIONS		0x02

#define _USE_MSG_WINDOW_    0
#define _INPUT_PASSWORD_    0

/* Structures */

enum showpriority {
   dp_none,	// has not been involved in any unsatisfied things
   dp_may,	// has been involved in an unsatisfied Optional
   dp_must	// has been involved in an unsatisfied Recommended/Depends/Conflicts
};

enum selpriority {
   // where did the currently suggested value come from, and how important
   // is it to display this package ?

   // low
   sp_inherit,     // inherited from our parent list
   sp_selecting,   // propagating a selection
   sp_deselecting, // propagating a deselection
   sp_fixed        // it came from the `status' file and we're not a recursive list
   // high
};


struct package_node {

    struct list_head up_down;           // Unanchored list of nodes at same level
    struct list_head selected_list;	    // Anchored list of selected nodes
    struct list_head dependency_list;   // Anchored list of selected nodes for dep resolving
    struct package_node *left;          // Left node (ctree display)
    struct package_node *right;	        // Right node (ctree display)
    struct package_node *dep_up;        // "Up" from this node (dependency resolving)
    int	   index;

    struct pkgCache::Package * pkg;

    string *relations;
    const char *Section;

    const char *PriorityStr;
		
    const char *InstalledVersionStr;
    const char *AvailableVersionStr;
	
    char *CurrentShortDesc;
    char *AvailableShortDesc;
    char *CurrentLongDesc;
    char *AvailableLongDesc;
	
    unsigned int pkgInstalledSize;
    unsigned int pkgDebSize;
	
    GtkCTreeNode *gtk_ctree_node;	// GtkCTree node pointer
    int gtk_clist_row;			    // GtkCList row number

    enum pkgCache::State::PkgSelectedState   Selected;

    char Name[1];   				// Stretchable package name
};

/* Globals */

extern struct list_head dependencies_input_anchor;
extern struct list_head dependencies_output_anchor;

extern int should_apply;
/* Functions */

void choke(char *);

static char *auto_unit(struct units *,double );
char *autosize(double);
static void sync_display();

void set_progress(GtkWidget *,gfloat);
void set_statusbar(GtkWidget *,gchar *);
char *get_status_string(int);

void free_main_nodes();
void populate_package_tree_nodes(GtkCTree *ctree);
void populate_package_tree_nodes_message();
void populate_package_tree_search(char *,gboolean,int,int);
void populate_package_tree_toggle_show_parameters(int);
void find_next(char *,gboolean);

void gray_buttons(int);

void free_dependency_nodes_and_optionally_copy_selections_out_to_main_nodes(gboolean);
void close_dependency_window_and_optionally_copy_selections(gboolean);
void check_dependencies_and_interactively_resolve(struct list_head *,enum showpriority);
void populate_changes_list(void);
void apply_changes_and_possibly_quit();
void *apply_changes_and_possibly_quit_thread(void* arg);
void update_packages(void);
void *update_packages_thread(void *arg);

void link_selected_package(GtkWidget *,struct package_node *);
void unlink_selected_package(struct package_node *, int main);
void mark_selected_packages(enum pkgCache::State::PkgSelectedState);
void mark_selected_dependency_resolver_packages(enum pkgCache::State::PkgSelectedState);
void show_package_information(GtkWidget *,struct package_node *, int);
void set_toolbar_button_state_by_node(struct package_node *node, int main, int flag);
void set_toolbar_button_state(int main);

void package_tree_row_double_clicked_event(struct package_node *);
void package_list_row_double_clicked_event(struct package_node *);

extern int msg_dlg_exit;
void MsgDlg(char *msg, int ok, int exit);


//static char *get_want_string(enum pkgCache::State::PkgSelectedState ,pkgCache::Package* );

void  append_to_clist(struct package_node* , GtkCList *);

struct package_node** alloc_nodes(int);


/* Inlines */

static __inline__ void *__alloc_structure(size_t bytes){
   void *p;

   p = malloc(bytes);

   if (!p){
      perror("malloc()");
      choke("Memory allocation error.");
   }

   memset(p,0,bytes);

   return p;
}

/* Macros */

#define alloc_structure(x) ((x *)__alloc_structure(sizeof(x)))

#define alloc_structure_stretchable(x,stretch_bytes) ((x *)__alloc_structure(sizeof(x) + stretch_bytes))

#define free_structure(x) free(x)

#define SZ(x) x,strlen(x)

#endif
