#ifndef INC_SOURCES_H
#define INC_SOURCES_H

#include "list.h"

/* Structs */

enum source_status {
      SOURCE_DISABLED,
      SOURCE_ENABLED,
      SOURCE_COMMENT
   } ;                            /* Status (disabled == commented out) */

struct source_line {
   struct list_head list;               /* Anchored list of lines in sources.list */
   enum source_status status;
   char *type;                          /* Type (deb, deb-src) */
   char *source_uri;                    /* Source URI */
   char *distribution;                  /* Distribution */
   char *sections;                      /* Space-separated sections */
   char *comment;                       /* Comment (if this line is a comment) */
   int gtk_clist_row;			/* Row number in GtkCList */
};

/* Functions */

void interactively_edit_sources_list(void);
void ok_edit_sources_list(void);
void cancel_edit_sources_list(void);
void sources_list_row_double_clicked_event(struct source_line *);
void link_selected_sources_line(struct source_line *);
void unlink_selected_sources_line(struct source_line *);
void remove_selected_sources_line(void);
void update_selected_sources_line(void);
void add_sources_line(void);
int  check_method();

#endif
