"""
Hard-coded results for test_regression
"""

### REGRESSION MODEL RESULTS : OLS, GLS, WLS, AR###

import numpy as np

class Longley(object):
    '''
    The results for the Longley dataset were obtained from NIST

    http://www.itl.nist.gov/div898/strd/general/dataarchive.html

    Other results were obtained from Stata
    '''
    def __init__(self):
        self.params = ( 15.0618722713733, -0.358191792925910E-01,
                 -2.02022980381683, -1.03322686717359, -0.511041056535807E-01,
                 1829.15146461355, -3482258.63459582)
        self.bse = (84.9149257747669, 0.334910077722432E-01,
                   0.488399681651699, 0.214274163161675, 0.226073200069370,
                   455.478499142212, 890420.383607373)
        self.scale = 92936.0061673238
        self.rsquared = 0.995479004577296
        self.rsquared_adj = 0.99246501
        self.df_model = 6
        self.df_resid = 9
        self.ess = 184172401.944494
        self.ssr = 836424.055505915
        self.mse_model = 30695400.3240823
        self.mse_resid = 92936.0061673238
        self.fvalue = 330.285339234588
        self.llf = -109.6174
        self.aic = 233.2349
        self.bic = 238.643
        self.pvalues = np.array([ 0.86314083,  0.31268106,  0.00253509,
            0.00094437,  0.8262118 , 0.0030368 ,  0.0035604 ])
#pvalues from rmodelwrap
        self.resid = np.array((267.34003, -94.01394, 46.28717, -410.11462,
            309.71459, -249.31122, -164.04896, -13.18036, 14.30477, 455.39409,
            -17.26893, -39.05504, -155.54997, -85.67131, 341.93151,
            -206.75783))

    def conf_int(self): # a method to be consistent with sm
        return [(-177.0291,207.1524), (-.111581,.0399428),(-3.125065,
                -.9153928),(-1.517948,-.5485049),(-.5625173,.4603083),
                   (798.7873,2859.515),(-5496529,-1467987)]


    HC0_se=(51.22035, 0.02458, 0.38324, 0.14625, 0.15821,
               428.38438, 832212)
    HC1_se=(68.29380, 0.03277, 0.51099, 0.19499, 0.21094,
                571.17917, 1109615)
    HC2_se=(67.49208, 0.03653, 0.55334, 0.20522, 0.22324,
                617.59295, 1202370)
    HC3_se=(91.11939, 0.05562, 0.82213, 0.29879, 0.32491,
                922.80784, 1799477)

class LongleyGls(object):
    '''
    The following results were obtained from running the test script with R.
    '''
    def __init__(self):
        self.params = (6.73894832e-02, -4.74273904e-01, 9.48988771e+04)
        self.bse = (1.07033903e-02, 1.53385472e-01, 1.39447723e+04)
        self.llf = -121.4294962954981
        self.fittedvalues = [59651.8255, 60860.1385, 60226.5336, 61467.1268,
                63914.0846, 64561.9553, 64935.9028, 64249.1684, 66010.0426,
                66834.7630, 67612.9309, 67018.8998, 68918.7758, 69310.1280,
                69181.4207, 70598.8734]
        self.resid = [671.174465, 261.861502, -55.533603, -280.126803,
                -693.084618, -922.955349, 53.097212, -488.168351, 8.957367,
                1022.236970,  556.069099, -505.899787, -263.775842, 253.871965,
                149.579309, -47.873374]
        self.scale = 542.443043098**2
        self.tvalues = [6.296088, -3.092039, 6.805337]
        self.pvalues = [2.761673e-05, 8.577197e-03, 1.252284e-05]
        self.bic = 253.118790021
        self.aic = 250.858992591
