package net.sf.statcvs.pages;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;

public class LogPageGroupMaker {
    private final ReportConfig config;
    private final Repository repository;

    public LogPageGroupMaker(final ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public PageGroup getPages() {
        final PageGroup pages = new PageGroup("Commit Logs");
        if (this.repository.getCommits().isEmpty()) {
            return pages;
        }
        final Date start = this.repository.getFirstDate();
        final Date end = this.repository.getLastDate();
        final Calendar calendar = new GregorianCalendar();
        calendar.setTime(end);
        final Calendar startCal = new GregorianCalendar();
        startCal.setTime(start);
        final List results = new ArrayList();
        while (true) {
            final int year = calendar.get(Calendar.YEAR);
            final int month = calendar.get(Calendar.MONTH);
            final NavigationNode page = new LogPageMaker(this.config, year, month, this.repository.getCommits()).toFile();
            results.add(page);
            if (calendar.get(Calendar.YEAR) == startCal.get(Calendar.YEAR) && calendar.get(Calendar.MONTH) == startCal.get(Calendar.MONTH)) {
                break;
            }
            calendar.add(Calendar.MONTH, -1);
        }
        final Iterator it = results.iterator();
        while (it.hasNext()) {
            pages.add((NavigationNode) it.next());
        }
        pages.setShowLinkToPreviousSibling(true);
        return pages;
    }
}
