-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Strings.Unbounded.Not_SPARK                                     --
--                                                                           --
-- Description                                                               --
--   This package provides the features of Ada.Strings.Unbounded which are   --
--   not compatible with SPARK. Please refer to the Ada LRM description of   --
--   Ada.Strings.Unbounded for usage information.                            --
--                                                                           --
-------------------------------------------------------------------------------

with SPARK.Ada.Strings.Maps.Not_SPARK;

package SPARK.Ada.Strings.Unbounded.Not_SPARK is

   type String_Access is new Standard.Ada.Strings.Unbounded.String_Access;

   procedure Free (X : in out String_Access);

   function To_String (Source : Unbounded_String) return String;

   function Slice
     (Source : Unbounded_String;
      Low    : Positive;
      High   : Natural) return String;

   function Index
     (Source  : Unbounded_String;
      Pattern : String;
      Going   : Direction := Direction_Forward;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural;

   --  Index is only defined in Ada 2005
   function Index
     (Source  : Unbounded_String;
      Pattern : String;
      From    : Positive;
      Going   : Direction := Direction_Forward;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural;

   function Count
     (Source  : Unbounded_String;
      Pattern : String;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function) return Natural;

   function Translate
     (Source  : Unbounded_String;
      Mapping : Maps.Not_SPARK.Character_Mapping_Function)
     return Unbounded_String;

   procedure Translate
     (Source  : in out Unbounded_String;
      Mapping : in     Maps.Not_SPARK.Character_Mapping_Function);

end SPARK.Ada.Strings.Unbounded.Not_SPARK;
