-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Unsigned                                                            --
--                                                                           --
-- Description                                                               --
--                                                                           --
-- This package is Ada, not SPARK. Do not submit it to the Examiner.         --
--                                                                           --
-- It supplies renamings of the Intrinsic Shift and Rotate functions         --
-- declared in Interfaces, so that these may be used from a SPARK program    --
-- via the shadow specifiction of this package.                              --
--                                                                           --
-- The content of this specification must be kep in sync with its            --
-- shadow specification in spark-interfaces.shs                              --
--                                                                           --
-- Language                                                                  --
--   Specification : Ada                                                     --
--   Private Part  : N/A                                                     --
--   Body          : N/A                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   No Ada Runtime, assuming Shift_ and Rotate_ functions are               --
--   Intrinsic on the target platform.                                       --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   None                                                                    --
--                                                                           --
-------------------------------------------------------------------------------

with Interfaces;
package SPARK.Unsigned
is
   -- Interfaces uses "Natural" for the Amount parameter of each
   -- function below, but we choose to introduce a named subtype here
   -- to ease RTC proof of calling units in SPARK.
   subtype Shift_Count is Natural range 0 .. 64;

   --------------------------------------------------------------------
   -- Shift and Rotate functions
   --
   -- These functions supply a non-overloaded, and therefore
   -- SPARK-compatible, declaration of the standard Shift and
   -- Rotate functions for the standard modular types.
   --
   -- For the compiler, this package specification
   -- supplies these declarations as renamings of the (overloaded)
   -- functions in package Interfaces, thus yielded the efficiency
   -- of the Intrinsic functions.
   --
   -- The de-overloading scheme used is to replace function
   -- XXX for type Unsigned_N with a function called
   -- XXX_N which renames the original entity.
   --------------------------------------------------------------------

   -- Rotate towards MSB
   function Rotate_Left_8
     (Value  : Interfaces.Unsigned_8;
      Amount : Shift_Count) return Interfaces.Unsigned_8
     renames Interfaces.Rotate_Left;

   -- Rotate towards LSB
   function Rotate_Right_8
     (Value  : Interfaces.Unsigned_8;
      Amount : Shift_Count) return Interfaces.Unsigned_8
     renames Interfaces.Rotate_Right;

   -- Shift towards MSB
   function Shift_Left_8
     (Value  : Interfaces.Unsigned_8;
      Amount : Shift_Count) return Interfaces.Unsigned_8
     renames Interfaces.Shift_Left;

   -- Shift towards LSB
   function Shift_Right_8
     (Value  : Interfaces.Unsigned_8;
      Amount : Shift_Count) return Interfaces.Unsigned_8
     renames Interfaces.Shift_Right;

   -- Arithmetic Shift towards LSB
   function Shift_Right_Arithmetic_8
     (Value  : Interfaces.Unsigned_8;
      Amount : Shift_Count) return Interfaces.Unsigned_8
     renames Interfaces.Shift_Right_Arithmetic;


   -- Rotate towards MSB
   function Rotate_Left_16
     (Value  : Interfaces.Unsigned_16;
      Amount : Shift_Count) return Interfaces.Unsigned_16
     renames Interfaces.Rotate_Left;

   -- Rotate towards LSB
   function Rotate_Right_16
     (Value  : Interfaces.Unsigned_16;
      Amount : Shift_Count) return Interfaces.Unsigned_16
     renames Interfaces.Rotate_Right;

   -- Shift towards MSB
   function Shift_Left_16
     (Value  : Interfaces.Unsigned_16;
      Amount : Shift_Count) return Interfaces.Unsigned_16
     renames Interfaces.Shift_Left;

   -- Shift towards LSB
   function Shift_Right_16
     (Value  : Interfaces.Unsigned_16;
      Amount : Shift_Count) return Interfaces.Unsigned_16
     renames Interfaces.Shift_Right;

   -- Arithmetic Shift towards LSB
   function Shift_Right_Arithmetic_16
     (Value  : Interfaces.Unsigned_16;
      Amount : Shift_Count) return Interfaces.Unsigned_16
     renames Interfaces.Shift_Right_Arithmetic;


   -- Rotate towards MSB
   function Rotate_Left_32
     (Value  : Interfaces.Unsigned_32;
      Amount : Shift_Count) return Interfaces.Unsigned_32
     renames Interfaces.Rotate_Left;

   -- Rotate towards LSB
   function Rotate_Right_32
     (Value  : Interfaces.Unsigned_32;
      Amount : Shift_Count) return Interfaces.Unsigned_32
     renames Interfaces.Rotate_Right;

   -- Shift towards MSB
   function Shift_Left_32
     (Value  : Interfaces.Unsigned_32;
      Amount : Shift_Count) return Interfaces.Unsigned_32
     renames Interfaces.Shift_Left;

   -- Shift towards LSB
   function Shift_Right_32
     (Value  : Interfaces.Unsigned_32;
      Amount : Shift_Count) return Interfaces.Unsigned_32
     renames Interfaces.Shift_Right;

   -- Arithmetic Shift towards LSB
   function Shift_Right_Arithmetic_32
     (Value  : Interfaces.Unsigned_32;
      Amount : Shift_Count) return Interfaces.Unsigned_32
     renames Interfaces.Shift_Right_Arithmetic;


   -- Rotate towards MSB
   function Rotate_Left_64
     (Value  : Interfaces.Unsigned_64;
      Amount : Shift_Count) return Interfaces.Unsigned_64
     renames Interfaces.Rotate_Left;

   -- Rotate towards LSB
   function Rotate_Right_64
     (Value  : Interfaces.Unsigned_64;
      Amount : Shift_Count) return Interfaces.Unsigned_64
     renames Interfaces.Rotate_Right;

   -- Shift towards MSB
   function Shift_Left_64
     (Value  : Interfaces.Unsigned_64;
      Amount : Shift_Count) return Interfaces.Unsigned_64
     renames Interfaces.Shift_Left;

   -- Shift towards LSB
   function Shift_Right_64
     (Value  : Interfaces.Unsigned_64;
      Amount : Shift_Count) return Interfaces.Unsigned_64
     renames Interfaces.Shift_Right;

   -- Arithmetic Shift towards LSB
   function Shift_Right_Arithmetic_64
     (Value  : Interfaces.Unsigned_64;
      Amount : Shift_Count) return Interfaces.Unsigned_64
     renames Interfaces.Shift_Right_Arithmetic;

end SPARK.Unsigned;
