-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
function Convert_Tagged_Actual (Actual, Tagged_Parameter_Sym : Dictionary.Symbol) return Dictionary.Symbol is
   ActualLocal : Dictionary.Symbol;
begin
   ActualLocal := Actual;
   loop
      -- normal exit: successful conversion
      exit when Dictionary.GetType (ActualLocal) = Tagged_Parameter_Sym;
      -- abnormal exit: can't follow inherited field pointers because type is hidden
      exit when Dictionary.GetFirstRecordSubcomponent (ActualLocal) = Dictionary.NullSymbol;
      ActualLocal := Dictionary.GetFirstRecordSubcomponent (ActualLocal);
   end loop;
   return ActualLocal;
end Convert_Tagged_Actual;
