-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddRecordComponent
  (Name                   : in LexTokenManager.Lex_String;
   Comp_Unit              : in ContextManager.UnitDescriptors;
   Declaration            : in Location;
   TheRecordType          : in Symbol;
   TheComponentType       : in Symbol;
   InheritedField         : in Boolean;
   ComponentTypeReference : in Location) is

   Component : Symbol;
   Previous  : Symbol;

   --------------------------------------------------------------------------------

   function IsRecordPrivate (TheRecordType, TheComponentType : Symbol) return TriState
   --# global in Dict;
   is
      IsRecordPrivateAlready, IsComponentPrivate, Result : TriState;

      --------------------------------------------------------------------------------

      function IsPrivate (TypeMark : Symbol;
                          Scope    : Scopes) return TriState
      --# global in Dict;
      is
         Result : TriState;
      begin

         case RawDict.GetTypePrivate (TypeMark) is
            when Never =>
               Result := Never;
            when Sometimes =>
               if IsLocal (Scope, GetScope (TypeMark)) then
                  Result := Sometimes;
               else
                  Result := Always;
               end if;
            when Always =>
               Result := Always;
         end case;

         return Result;

      end IsPrivate;

      --------------------------------------------------------------------------------

   begin

      IsRecordPrivateAlready := RawDict.GetTypePrivate (TheRecordType);
      IsComponentPrivate     := IsPrivate (TheComponentType, GetScope (TheRecordType));

      case IsRecordPrivateAlready is
         when Never =>
            Result := IsComponentPrivate;
         when Sometimes =>
            case IsComponentPrivate is
               when Never | Sometimes =>
                  Result := Sometimes;
               when Always =>
                  Result := Always;
            end case;
         when Always =>
            Result := Always;
      end case;

      return Result;

   end IsRecordPrivate;

   --------------------------------------------------------------------------------

   function IsRecordLimited (TheRecordType, TheComponentType : Symbol) return TriState
   --# global in Dict;
   is
      IsRecordLimitedAlready, IsComponentLimited, Result : TriState;

      --------------------------------------------------------------------------------

      function IsLimited (TypeMark : Symbol;
                          Scope    : Scopes) return TriState
      --# global in Dict;
      is
         Result : TriState;
      begin

         case RawDict.GetTypeLimited (TypeMark) is
            when Never =>
               Result := Never;
            when Sometimes =>
               if IsLocal (Scope, GetScope (TypeMark)) then
                  Result := Sometimes;
               else
                  Result := Always;
               end if;
            when Always =>
               Result := Always;
         end case;

         return Result;

      end IsLimited;

      --------------------------------------------------------------------------------

   begin

      IsRecordLimitedAlready := RawDict.GetTypeLimited (TheRecordType);
      IsComponentLimited     := IsLimited (TheComponentType, GetScope (TheRecordType));

      case IsRecordLimitedAlready is
         when Never =>
            Result := IsComponentLimited;
         when Sometimes =>
            case IsComponentLimited is
               when Never | Sometimes =>
                  Result := Sometimes;
               when Always =>
                  Result := Always;
            end case;
         when Always =>
            Result := Always;
      end case;

      return Result;

   end IsRecordLimited;

   --------------------------------------------------------------------------------

begin

   RawDict.CreateRecordComponent
     (Name           => Name,
      RecordType     => TheRecordType,
      ComponentType  => TheComponentType,
      InheritedField => InheritedField,
      Comp_Unit      => Comp_Unit,
      Loc            => Declaration.Start_Position,
      Component      => Component);

   Previous := RawDict.GetTypeLastRecordComponent (TheRecordType);

   if Previous = NullSymbol then
      RawDict.SetTypeFirstRecordComponent (TheRecordType, Component);
   else
      RawDict.SetNextRecordComponent (Previous, Component);
   end if;

   RawDict.SetTypeLastRecordComponent (TheRecordType, Component);

   RawDict.SetTypePrivate (TheRecordType, IsRecordPrivate (TheRecordType, TheComponentType));
   RawDict.SetTypeLimited (TheRecordType, IsRecordLimited (TheRecordType, TheComponentType));
   RawDict.SetTypeEqualityDefined (TheRecordType, EqualityDefined (TheRecordType) and then EqualityDefined (TheComponentType));
   RawDict.SetTypeContainsFloat (TheRecordType, ContainsFloat (TheRecordType) or else ContainsFloat (TheComponentType));

   if not TypeIsUnknown (TheComponentType) then
      AddOtherReference (TheComponentType, GetRegion (GetScope (TheRecordType)), ComponentTypeReference);
   end if;

end AddRecordComponent;
