/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef MSG_MIME_PROTOS_H
/** Defined when <sofia-sip/msg_mime_protos.h> has been included. */
#define MSG_MIME_PROTOS_H 

/**@ingroup msg_mime
 * @file sofia-sip/msg_mime_protos.h
 *
 * Prototypes for MIME headers (@RFC2045).
 *
 * This file is automatically generated from <msg_mime.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 */

#ifndef MSG_PARSER_H
#include <sofia-sip/msg_parser.h>
#endif
#ifndef MSG_MIME_H
#include <sofia-sip/msg_mime.h>
#endif
#ifndef MSG_MCLASS_H
#include <sofia-sip/msg_mclass.h>
#endif
#ifndef MSG_MCLASS_H
#include <sofia-sip/msg_mclass.h>
#endif

SOFIA_BEGIN_DECLS

MSG_DLL extern msg_mclass_t const msg_multipart_mclass[1];

#define msg_multipart_class ((msg_hclass_t *)msg_multipart_mclass)


/* Declare internal prototypes for Content-Type header */

/**@addtogroup msg_content_type 
 * @{ 
 */

enum { 
  /** Hash of Content-Type header. @internal */
  msg_content_type_hash = 51226 
};

/** Parse a Content-Type header. @internal */
MSG_DLL msg_parse_f msg_content_type_d;

/** Print a Content-Type header. @internal */
MSG_DLL msg_print_f msg_content_type_e;

MSG_DLL msg_xtra_f msg_content_type_dup_xtra;
MSG_DLL msg_dup_f msg_content_type_dup_one;

/**Header class for Content-Type header.
 * 
 * The header class msg_content_type_class defines how a 
 * Content-Type header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_type_t header structure.
 * 
 */
#ifndef msg_content_type_class
MSG_DLL extern msg_hclass_t msg_content_type_class[];
#endif

/**Initializer for an #msg_content_type_t structure.
 * 
 * A static msg_content_type_t structure must be initialized
 * with the MSG_CONTENT_TYPE_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_type_t msg_content_type = MSG_CONTENT_TYPE_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_TYPE_INIT() MSG_HDR_INIT(content_type)

/**Initialize an #msg_content_type_t structure.
 * 
 * An #msg_content_type_t structure can be initialized with the
 * msg_content_type_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_type_t msg_content_type;
 * 
 *  msg_content_type_init(&msg_content_type);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_type_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_type_t *msg_content_type_init(msg_content_type_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_type_class, sizeof(msg_content_type_t));
}
#else
#define msg_content_type_init(x) \
  MSG_HEADER_INIT(x, msg_content_type_class, sizeof(msg_content_type_t))
#endif

/**Test if header object is an instance of #msg_content_type_t.
 * 
 * The function msg_is_content_type() returns true (nonzero) if
 * the header class is an instance of Content-Type header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_type() returns true (nonzero) if the
 * header object is an instance of header Content-Type header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_type(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_type_hash;
}
#else
int msg_is_content_type(msg_header_t const *header);
#endif

#define msg_content_type_p(h) msg_is_content_type((h))

/**Duplicate (deep copy) #msg_content_type_t.
 * 
 * The function msg_content_type_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_type = msg_content_type_dup(home, msg->msg_content_type);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_type_dup() returns a pointer to the
 * newly duplicated #msg_content_type_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_type_t *msg_content_type_dup(su_home_t *home, 
				 msg_content_type_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_type_t *msg_content_type_dup(su_home_t *home, 
				 msg_content_type_t const *header)
{
  return (msg_content_type_t *)
    msg_header_dup_as(home, msg_content_type_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_type_t header structure.
 * 
 * The function msg_content_type_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_type = msg_content_type_copy(home, msg->msg_content_type);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_type_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_type_t *msg_content_type_copy(su_home_t *home, 
				  msg_content_type_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_type_t *msg_content_type_copy(su_home_t *home, 
				  msg_content_type_t const *header)
{
  return (msg_content_type_t *)
    msg_header_copy_as(home, msg_content_type_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_type_t.
 * 
 * The function msg_content_type_make() makes a new #msg_content_type_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_type_make() returns a pointer to newly maked
 * #msg_content_type_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_type_t *msg_content_type_make(su_home_t *home, char const *s)
{
  return (msg_content_type_t*)msg_header_make(home, msg_content_type_class, s);
}
#else
msg_content_type_t *msg_content_type_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Type header from formatting result.
 * 
 * The function msg_content_type_format() makes a new Content-Type header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_type_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_type_t *msg_content_type_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_type_t *msg_content_type_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_type_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_type_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Disposition header */

/**@addtogroup msg_content_disposition 
 * @{ 
 */

enum { 
  /** Hash of Content-Disposition header. @internal */
  msg_content_disposition_hash = 16333 
};

/** Parse a Content-Disposition header. @internal */
MSG_DLL msg_parse_f msg_content_disposition_d;

/** Print a Content-Disposition header. @internal */
MSG_DLL msg_print_f msg_content_disposition_e;

MSG_DLL msg_xtra_f msg_content_disposition_dup_xtra;
MSG_DLL msg_dup_f msg_content_disposition_dup_one;

/**Header class for Content-Disposition header.
 * 
 * The header class msg_content_disposition_class defines how a 
 * Content-Disposition header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_disposition_t header structure.
 * 
 */
#ifndef msg_content_disposition_class
MSG_DLL extern msg_hclass_t msg_content_disposition_class[];
#endif

/**Initializer for an #msg_content_disposition_t structure.
 * 
 * A static msg_content_disposition_t structure must be initialized
 * with the MSG_CONTENT_DISPOSITION_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_disposition_t msg_content_disposition = MSG_CONTENT_DISPOSITION_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_DISPOSITION_INIT() MSG_HDR_INIT(content_disposition)

/**Initialize an #msg_content_disposition_t structure.
 * 
 * An #msg_content_disposition_t structure can be initialized with the
 * msg_content_disposition_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_disposition_t msg_content_disposition;
 * 
 *  msg_content_disposition_init(&msg_content_disposition);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_disposition_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_disposition_t *msg_content_disposition_init(msg_content_disposition_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_disposition_class, sizeof(msg_content_disposition_t));
}
#else
#define msg_content_disposition_init(x) \
  MSG_HEADER_INIT(x, msg_content_disposition_class, sizeof(msg_content_disposition_t))
#endif

/**Test if header object is an instance of #msg_content_disposition_t.
 * 
 * The function msg_is_content_disposition() returns true (nonzero) if
 * the header class is an instance of Content-Disposition header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_disposition() returns true (nonzero) if the
 * header object is an instance of header Content-Disposition header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_disposition(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_disposition_hash;
}
#else
int msg_is_content_disposition(msg_header_t const *header);
#endif

#define msg_content_disposition_p(h) msg_is_content_disposition((h))

/**Duplicate (deep copy) #msg_content_disposition_t.
 * 
 * The function msg_content_disposition_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_disposition = msg_content_disposition_dup(home, msg->msg_content_disposition);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_disposition_dup() returns a pointer to the
 * newly duplicated #msg_content_disposition_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_disposition_t *msg_content_disposition_dup(su_home_t *home, 
				 msg_content_disposition_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_disposition_t *msg_content_disposition_dup(su_home_t *home, 
				 msg_content_disposition_t const *header)
{
  return (msg_content_disposition_t *)
    msg_header_dup_as(home, msg_content_disposition_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_disposition_t header structure.
 * 
 * The function msg_content_disposition_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_disposition = msg_content_disposition_copy(home, msg->msg_content_disposition);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_disposition_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_disposition_t *msg_content_disposition_copy(su_home_t *home, 
				  msg_content_disposition_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_disposition_t *msg_content_disposition_copy(su_home_t *home, 
				  msg_content_disposition_t const *header)
{
  return (msg_content_disposition_t *)
    msg_header_copy_as(home, msg_content_disposition_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_disposition_t.
 * 
 * The function msg_content_disposition_make() makes a new #msg_content_disposition_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_disposition_make() returns a pointer to newly maked
 * #msg_content_disposition_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_disposition_t *msg_content_disposition_make(su_home_t *home, char const *s)
{
  return (msg_content_disposition_t*)msg_header_make(home, msg_content_disposition_class, s);
}
#else
msg_content_disposition_t *msg_content_disposition_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Disposition header from formatting result.
 * 
 * The function msg_content_disposition_format() makes a new Content-Disposition header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_disposition_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_disposition_t *msg_content_disposition_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_disposition_t *msg_content_disposition_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_disposition_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_disposition_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Location header */

/**@addtogroup msg_content_location 
 * @{ 
 */

enum { 
  /** Hash of Content-Location header. @internal */
  msg_content_location_hash = 3453 
};

/** Parse a Content-Location header. @internal */
MSG_DLL msg_parse_f msg_content_location_d;

/** Print a Content-Location header. @internal */
MSG_DLL msg_print_f msg_content_location_e;

MSG_DLL msg_xtra_f msg_content_location_dup_xtra;
MSG_DLL msg_dup_f msg_content_location_dup_one;

/**Header class for Content-Location header.
 * 
 * The header class msg_content_location_class defines how a 
 * Content-Location header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_location_t header structure.
 * 
 */
#ifndef msg_content_location_class
MSG_DLL extern msg_hclass_t msg_content_location_class[];
#endif

/**Initializer for an #msg_content_location_t structure.
 * 
 * A static msg_content_location_t structure must be initialized
 * with the MSG_CONTENT_LOCATION_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_location_t msg_content_location = MSG_CONTENT_LOCATION_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_LOCATION_INIT() MSG_HDR_INIT(content_location)

/**Initialize an #msg_content_location_t structure.
 * 
 * An #msg_content_location_t structure can be initialized with the
 * msg_content_location_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_location_t msg_content_location;
 * 
 *  msg_content_location_init(&msg_content_location);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_location_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_location_t *msg_content_location_init(msg_content_location_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_location_class, sizeof(msg_content_location_t));
}
#else
#define msg_content_location_init(x) \
  MSG_HEADER_INIT(x, msg_content_location_class, sizeof(msg_content_location_t))
#endif

/**Test if header object is an instance of #msg_content_location_t.
 * 
 * The function msg_is_content_location() returns true (nonzero) if
 * the header class is an instance of Content-Location header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_location() returns true (nonzero) if the
 * header object is an instance of header Content-Location header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_location(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_location_hash;
}
#else
int msg_is_content_location(msg_header_t const *header);
#endif

#define msg_content_location_p(h) msg_is_content_location((h))

/**Duplicate (deep copy) #msg_content_location_t.
 * 
 * The function msg_content_location_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_location = msg_content_location_dup(home, msg->msg_content_location);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_location_dup() returns a pointer to the
 * newly duplicated #msg_content_location_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_location_t *msg_content_location_dup(su_home_t *home, 
				 msg_content_location_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_location_t *msg_content_location_dup(su_home_t *home, 
				 msg_content_location_t const *header)
{
  return (msg_content_location_t *)
    msg_header_dup_as(home, msg_content_location_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_location_t header structure.
 * 
 * The function msg_content_location_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_location = msg_content_location_copy(home, msg->msg_content_location);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_location_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_location_t *msg_content_location_copy(su_home_t *home, 
				  msg_content_location_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_location_t *msg_content_location_copy(su_home_t *home, 
				  msg_content_location_t const *header)
{
  return (msg_content_location_t *)
    msg_header_copy_as(home, msg_content_location_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_location_t.
 * 
 * The function msg_content_location_make() makes a new #msg_content_location_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_location_make() returns a pointer to newly maked
 * #msg_content_location_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_location_t *msg_content_location_make(su_home_t *home, char const *s)
{
  return (msg_content_location_t*)msg_header_make(home, msg_content_location_class, s);
}
#else
msg_content_location_t *msg_content_location_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Location header from formatting result.
 * 
 * The function msg_content_location_format() makes a new Content-Location header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_location_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_location_t *msg_content_location_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_location_t *msg_content_location_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_location_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_location_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-ID header */

/**@addtogroup msg_content_id 
 * @{ 
 */

enum { 
  /** Hash of Content-ID header. @internal */
  msg_content_id_hash = 42909 
};

/** Parse a Content-ID header. @internal */
MSG_DLL msg_parse_f msg_content_id_d;

/** Print a Content-ID header. @internal */
MSG_DLL msg_print_f msg_content_id_e;

MSG_DLL msg_xtra_f msg_content_id_dup_xtra;
MSG_DLL msg_dup_f msg_content_id_dup_one;

/**Header class for Content-ID header.
 * 
 * The header class msg_content_id_class defines how a 
 * Content-ID header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_id_t header structure.
 * 
 */
#ifndef msg_content_id_class
MSG_DLL extern msg_hclass_t msg_content_id_class[];
#endif

/**Initializer for an #msg_content_id_t structure.
 * 
 * A static msg_content_id_t structure must be initialized
 * with the MSG_CONTENT_ID_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_id_t msg_content_id = MSG_CONTENT_ID_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_ID_INIT() MSG_HDR_INIT(content_id)

/**Initialize an #msg_content_id_t structure.
 * 
 * An #msg_content_id_t structure can be initialized with the
 * msg_content_id_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_id_t msg_content_id;
 * 
 *  msg_content_id_init(&msg_content_id);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_id_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_id_t *msg_content_id_init(msg_content_id_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_id_class, sizeof(msg_content_id_t));
}
#else
#define msg_content_id_init(x) \
  MSG_HEADER_INIT(x, msg_content_id_class, sizeof(msg_content_id_t))
#endif

/**Test if header object is an instance of #msg_content_id_t.
 * 
 * The function msg_is_content_id() returns true (nonzero) if
 * the header class is an instance of Content-ID header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_id() returns true (nonzero) if the
 * header object is an instance of header Content-ID header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_id(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_id_hash;
}
#else
int msg_is_content_id(msg_header_t const *header);
#endif

#define msg_content_id_p(h) msg_is_content_id((h))

/**Duplicate (deep copy) #msg_content_id_t.
 * 
 * The function msg_content_id_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_id = msg_content_id_dup(home, msg->msg_content_id);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_id_dup() returns a pointer to the
 * newly duplicated #msg_content_id_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_id_t *msg_content_id_dup(su_home_t *home, 
				 msg_content_id_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_id_t *msg_content_id_dup(su_home_t *home, 
				 msg_content_id_t const *header)
{
  return (msg_content_id_t *)
    msg_header_dup_as(home, msg_content_id_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_id_t header structure.
 * 
 * The function msg_content_id_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_id = msg_content_id_copy(home, msg->msg_content_id);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_id_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_id_t *msg_content_id_copy(su_home_t *home, 
				  msg_content_id_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_id_t *msg_content_id_copy(su_home_t *home, 
				  msg_content_id_t const *header)
{
  return (msg_content_id_t *)
    msg_header_copy_as(home, msg_content_id_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_id_t.
 * 
 * The function msg_content_id_make() makes a new #msg_content_id_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_id_make() returns a pointer to newly maked
 * #msg_content_id_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_id_t *msg_content_id_make(su_home_t *home, char const *s)
{
  return (msg_content_id_t*)msg_header_make(home, msg_content_id_class, s);
}
#else
msg_content_id_t *msg_content_id_make(su_home_t *home, char const *s);
#endif


/**Make a Content-ID header from formatting result.
 * 
 * The function msg_content_id_format() makes a new Content-ID header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_id_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_id_t *msg_content_id_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_id_t *msg_content_id_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_id_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_id_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Language header */

/**@addtogroup msg_content_language 
 * @{ 
 */

enum { 
  /** Hash of Content-Language header. @internal */
  msg_content_language_hash = 62108 
};

/** Parse a Content-Language header. @internal */
MSG_DLL msg_parse_f msg_content_language_d;

/** Print a Content-Language header. @internal */
MSG_DLL msg_print_f msg_content_language_e;

MSG_DLL msg_xtra_f msg_content_language_dup_xtra;
MSG_DLL msg_dup_f msg_content_language_dup_one;

/**Header class for Content-Language header.
 * 
 * The header class msg_content_language_class defines how a 
 * Content-Language header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_language_t header structure.
 * 
 */
#ifndef msg_content_language_class
MSG_DLL extern msg_hclass_t msg_content_language_class[];
#endif

/**Initializer for an #msg_content_language_t structure.
 * 
 * A static msg_content_language_t structure must be initialized
 * with the MSG_CONTENT_LANGUAGE_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_language_t msg_content_language = MSG_CONTENT_LANGUAGE_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_LANGUAGE_INIT() MSG_HDR_INIT(content_language)

/**Initialize an #msg_content_language_t structure.
 * 
 * An #msg_content_language_t structure can be initialized with the
 * msg_content_language_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_language_t msg_content_language;
 * 
 *  msg_content_language_init(&msg_content_language);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_language_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_language_t *msg_content_language_init(msg_content_language_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_language_class, sizeof(msg_content_language_t));
}
#else
#define msg_content_language_init(x) \
  MSG_HEADER_INIT(x, msg_content_language_class, sizeof(msg_content_language_t))
#endif

/**Test if header object is an instance of #msg_content_language_t.
 * 
 * The function msg_is_content_language() returns true (nonzero) if
 * the header class is an instance of Content-Language header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_language() returns true (nonzero) if the
 * header object is an instance of header Content-Language header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_language(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_language_hash;
}
#else
int msg_is_content_language(msg_header_t const *header);
#endif

#define msg_content_language_p(h) msg_is_content_language((h))

/**Duplicate (deep copy) #msg_content_language_t.
 * 
 * The function msg_content_language_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_language = msg_content_language_dup(home, msg->msg_content_language);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_language_dup() returns a pointer to the
 * newly duplicated #msg_content_language_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_language_t *msg_content_language_dup(su_home_t *home, 
				 msg_content_language_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_language_t *msg_content_language_dup(su_home_t *home, 
				 msg_content_language_t const *header)
{
  return (msg_content_language_t *)
    msg_header_dup_as(home, msg_content_language_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_language_t header structure.
 * 
 * The function msg_content_language_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_language = msg_content_language_copy(home, msg->msg_content_language);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_language_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_language_t *msg_content_language_copy(su_home_t *home, 
				  msg_content_language_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_language_t *msg_content_language_copy(su_home_t *home, 
				  msg_content_language_t const *header)
{
  return (msg_content_language_t *)
    msg_header_copy_as(home, msg_content_language_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_language_t.
 * 
 * The function msg_content_language_make() makes a new #msg_content_language_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_language_make() returns a pointer to newly maked
 * #msg_content_language_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_language_t *msg_content_language_make(su_home_t *home, char const *s)
{
  return (msg_content_language_t*)msg_header_make(home, msg_content_language_class, s);
}
#else
msg_content_language_t *msg_content_language_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Language header from formatting result.
 * 
 * The function msg_content_language_format() makes a new Content-Language header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_language_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_language_t *msg_content_language_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_language_t *msg_content_language_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_language_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_language_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Encoding header */

/**@addtogroup msg_content_encoding 
 * @{ 
 */

enum { 
  /** Hash of Content-Encoding header. @internal */
  msg_content_encoding_hash = 8707 
};

/** Parse a Content-Encoding header. @internal */
MSG_DLL msg_parse_f msg_content_encoding_d;

/** Print a Content-Encoding header. @internal */
MSG_DLL msg_print_f msg_content_encoding_e;

MSG_DLL msg_xtra_f msg_content_encoding_dup_xtra;
MSG_DLL msg_dup_f msg_content_encoding_dup_one;

/**Header class for Content-Encoding header.
 * 
 * The header class msg_content_encoding_class defines how a 
 * Content-Encoding header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_encoding_t header structure.
 * 
 */
#ifndef msg_content_encoding_class
MSG_DLL extern msg_hclass_t msg_content_encoding_class[];
#endif

/**Initializer for an #msg_content_encoding_t structure.
 * 
 * A static msg_content_encoding_t structure must be initialized
 * with the MSG_CONTENT_ENCODING_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_encoding_t msg_content_encoding = MSG_CONTENT_ENCODING_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_ENCODING_INIT() MSG_HDR_INIT(content_encoding)

/**Initialize an #msg_content_encoding_t structure.
 * 
 * An #msg_content_encoding_t structure can be initialized with the
 * msg_content_encoding_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_encoding_t msg_content_encoding;
 * 
 *  msg_content_encoding_init(&msg_content_encoding);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_encoding_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_encoding_t *msg_content_encoding_init(msg_content_encoding_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_encoding_class, sizeof(msg_content_encoding_t));
}
#else
#define msg_content_encoding_init(x) \
  MSG_HEADER_INIT(x, msg_content_encoding_class, sizeof(msg_content_encoding_t))
#endif

/**Test if header object is an instance of #msg_content_encoding_t.
 * 
 * The function msg_is_content_encoding() returns true (nonzero) if
 * the header class is an instance of Content-Encoding header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_encoding() returns true (nonzero) if the
 * header object is an instance of header Content-Encoding header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_encoding(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_encoding_hash;
}
#else
int msg_is_content_encoding(msg_header_t const *header);
#endif

#define msg_content_encoding_p(h) msg_is_content_encoding((h))

/**Duplicate (deep copy) #msg_content_encoding_t.
 * 
 * The function msg_content_encoding_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_encoding = msg_content_encoding_dup(home, msg->msg_content_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_encoding_dup() returns a pointer to the
 * newly duplicated #msg_content_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_encoding_t *msg_content_encoding_dup(su_home_t *home, 
				 msg_content_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_encoding_t *msg_content_encoding_dup(su_home_t *home, 
				 msg_content_encoding_t const *header)
{
  return (msg_content_encoding_t *)
    msg_header_dup_as(home, msg_content_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_encoding_t header structure.
 * 
 * The function msg_content_encoding_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_encoding = msg_content_encoding_copy(home, msg->msg_content_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_encoding_t *msg_content_encoding_copy(su_home_t *home, 
				  msg_content_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_encoding_t *msg_content_encoding_copy(su_home_t *home, 
				  msg_content_encoding_t const *header)
{
  return (msg_content_encoding_t *)
    msg_header_copy_as(home, msg_content_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_encoding_t.
 * 
 * The function msg_content_encoding_make() makes a new #msg_content_encoding_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_encoding_make() returns a pointer to newly maked
 * #msg_content_encoding_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_encoding_t *msg_content_encoding_make(su_home_t *home, char const *s)
{
  return (msg_content_encoding_t*)msg_header_make(home, msg_content_encoding_class, s);
}
#else
msg_content_encoding_t *msg_content_encoding_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Encoding header from formatting result.
 * 
 * The function msg_content_encoding_format() makes a new Content-Encoding header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_encoding_t *msg_content_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_encoding_t *msg_content_encoding_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_encoding_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_encoding_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Transfer-Encoding header */

/**@addtogroup msg_content_transfer_encoding 
 * @{ 
 */

enum { 
  /** Hash of Content-Transfer-Encoding header. @internal */
  msg_content_transfer_encoding_hash = 7853 
};

/** Parse a Content-Transfer-Encoding header. @internal */
MSG_DLL msg_parse_f msg_content_transfer_encoding_d;

/** Print a Content-Transfer-Encoding header. @internal */
MSG_DLL msg_print_f msg_content_transfer_encoding_e;

MSG_DLL msg_xtra_f msg_content_transfer_encoding_dup_xtra;
MSG_DLL msg_dup_f msg_content_transfer_encoding_dup_one;

/**Header class for Content-Transfer-Encoding header.
 * 
 * The header class msg_content_transfer_encoding_class defines how a 
 * Content-Transfer-Encoding header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_transfer_encoding_t header structure.
 * 
 */
#ifndef msg_content_transfer_encoding_class
MSG_DLL extern msg_hclass_t msg_content_transfer_encoding_class[];
#endif

/**Initializer for an #msg_content_transfer_encoding_t structure.
 * 
 * A static msg_content_transfer_encoding_t structure must be initialized
 * with the MSG_CONTENT_TRANSFER_ENCODING_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_transfer_encoding_t msg_content_transfer_encoding = MSG_CONTENT_TRANSFER_ENCODING_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_TRANSFER_ENCODING_INIT() MSG_HDR_INIT(content_transfer_encoding)

/**Initialize an #msg_content_transfer_encoding_t structure.
 * 
 * An #msg_content_transfer_encoding_t structure can be initialized with the
 * msg_content_transfer_encoding_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_transfer_encoding_t msg_content_transfer_encoding;
 * 
 *  msg_content_transfer_encoding_init(&msg_content_transfer_encoding);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_transfer_encoding_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_transfer_encoding_t *msg_content_transfer_encoding_init(msg_content_transfer_encoding_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_transfer_encoding_class, sizeof(msg_content_transfer_encoding_t));
}
#else
#define msg_content_transfer_encoding_init(x) \
  MSG_HEADER_INIT(x, msg_content_transfer_encoding_class, sizeof(msg_content_transfer_encoding_t))
#endif

/**Test if header object is an instance of #msg_content_transfer_encoding_t.
 * 
 * The function msg_is_content_transfer_encoding() returns true (nonzero) if
 * the header class is an instance of Content-Transfer-Encoding header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_transfer_encoding() returns true (nonzero) if the
 * header object is an instance of header Content-Transfer-Encoding header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_transfer_encoding(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_transfer_encoding_hash;
}
#else
int msg_is_content_transfer_encoding(msg_header_t const *header);
#endif

#define msg_content_transfer_encoding_p(h) msg_is_content_transfer_encoding((h))

/**Duplicate (deep copy) #msg_content_transfer_encoding_t.
 * 
 * The function msg_content_transfer_encoding_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_transfer_encoding = msg_content_transfer_encoding_dup(home, msg->msg_content_transfer_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_transfer_encoding_dup() returns a pointer to the
 * newly duplicated #msg_content_transfer_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_transfer_encoding_t *msg_content_transfer_encoding_dup(su_home_t *home, 
				 msg_content_transfer_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_transfer_encoding_t *msg_content_transfer_encoding_dup(su_home_t *home, 
				 msg_content_transfer_encoding_t const *header)
{
  return (msg_content_transfer_encoding_t *)
    msg_header_dup_as(home, msg_content_transfer_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_transfer_encoding_t header structure.
 * 
 * The function msg_content_transfer_encoding_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_transfer_encoding = msg_content_transfer_encoding_copy(home, msg->msg_content_transfer_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_transfer_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_transfer_encoding_t *msg_content_transfer_encoding_copy(su_home_t *home, 
				  msg_content_transfer_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_transfer_encoding_t *msg_content_transfer_encoding_copy(su_home_t *home, 
				  msg_content_transfer_encoding_t const *header)
{
  return (msg_content_transfer_encoding_t *)
    msg_header_copy_as(home, msg_content_transfer_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_transfer_encoding_t.
 * 
 * The function msg_content_transfer_encoding_make() makes a new #msg_content_transfer_encoding_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_transfer_encoding_make() returns a pointer to newly maked
 * #msg_content_transfer_encoding_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_transfer_encoding_t *msg_content_transfer_encoding_make(su_home_t *home, char const *s)
{
  return (msg_content_transfer_encoding_t*)msg_header_make(home, msg_content_transfer_encoding_class, s);
}
#else
msg_content_transfer_encoding_t *msg_content_transfer_encoding_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Transfer-Encoding header from formatting result.
 * 
 * The function msg_content_transfer_encoding_format() makes a new Content-Transfer-Encoding header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_transfer_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_transfer_encoding_t *msg_content_transfer_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_transfer_encoding_t *msg_content_transfer_encoding_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_transfer_encoding_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_transfer_encoding_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Accept header */

/**@addtogroup msg_accept 
 * @{ 
 */

enum { 
  /** Hash of Accept header. @internal */
  msg_accept_hash = 29344 
};

/** Parse a Accept header. @internal */
MSG_DLL msg_parse_f msg_accept_d;

/** Print a Accept header. @internal */
MSG_DLL msg_print_f msg_accept_e;

MSG_DLL msg_xtra_f msg_accept_dup_xtra;
MSG_DLL msg_dup_f msg_accept_dup_one;

/**Header class for Accept header.
 * 
 * The header class msg_accept_class defines how a 
 * Accept header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_accept_t header structure.
 * 
 */
#ifndef msg_accept_class
MSG_DLL extern msg_hclass_t msg_accept_class[];
#endif

/**Initializer for an #msg_accept_t structure.
 * 
 * A static msg_accept_t structure must be initialized
 * with the MSG_ACCEPT_INIT() macro. For instance,
 * @code 
 * 
 *  msg_accept_t msg_accept = MSG_ACCEPT_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_ACCEPT_INIT() MSG_HDR_INIT(accept)

/**Initialize an #msg_accept_t structure.
 * 
 * An #msg_accept_t structure can be initialized with the
 * msg_accept_init() function/macro. For instance,
 * @code
 * 
 *  msg_accept_t msg_accept;
 * 
 *  msg_accept_init(&msg_accept);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_accept_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_accept_t *msg_accept_init(msg_accept_t x[1])
{
  return MSG_HEADER_INIT(x, msg_accept_class, sizeof(msg_accept_t));
}
#else
#define msg_accept_init(x) \
  MSG_HEADER_INIT(x, msg_accept_class, sizeof(msg_accept_t))
#endif

/**Test if header object is an instance of #msg_accept_t.
 * 
 * The function msg_is_accept() returns true (nonzero) if
 * the header class is an instance of Accept header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_accept() returns true (nonzero) if the
 * header object is an instance of header Accept header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_accept(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_accept_hash;
}
#else
int msg_is_accept(msg_header_t const *header);
#endif

#define msg_accept_p(h) msg_is_accept((h))

/**Duplicate (deep copy) #msg_accept_t.
 * 
 * The function msg_accept_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   accept = msg_accept_dup(home, msg->msg_accept);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_dup() returns a pointer to the
 * newly duplicated #msg_accept_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_t *msg_accept_dup(su_home_t *home, 
				 msg_accept_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_t *msg_accept_dup(su_home_t *home, 
				 msg_accept_t const *header)
{
  return (msg_accept_t *)
    msg_header_dup_as(home, msg_accept_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_accept_t header structure.
 * 
 * The function msg_accept_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   accept = msg_accept_copy(home, msg->msg_accept);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_t *msg_accept_copy(su_home_t *home, 
				  msg_accept_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_t *msg_accept_copy(su_home_t *home, 
				  msg_accept_t const *header)
{
  return (msg_accept_t *)
    msg_header_copy_as(home, msg_accept_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_accept_t.
 * 
 * The function msg_accept_make() makes a new #msg_accept_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_accept_make() returns a pointer to newly maked
 * #msg_accept_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_accept_t *msg_accept_make(su_home_t *home, char const *s)
{
  return (msg_accept_t*)msg_header_make(home, msg_accept_class, s);
}
#else
msg_accept_t *msg_accept_make(su_home_t *home, char const *s);
#endif


/**Make a Accept header from formatting result.
 * 
 * The function msg_accept_format() makes a new Accept header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_accept_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_t *msg_accept_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_accept_t *msg_accept_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_accept_class, fmt, ap);
  va_end(ap);
 
  return (msg_accept_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Accept-Charset header */

/**@addtogroup msg_accept_charset 
 * @{ 
 */

enum { 
  /** Hash of Accept-Charset header. @internal */
  msg_accept_charset_hash = 41803 
};

/** Parse a Accept-Charset header. @internal */
MSG_DLL msg_parse_f msg_accept_charset_d;

/** Print a Accept-Charset header. @internal */
MSG_DLL msg_print_f msg_accept_charset_e;

MSG_DLL msg_xtra_f msg_accept_charset_dup_xtra;
MSG_DLL msg_dup_f msg_accept_charset_dup_one;

/**Header class for Accept-Charset header.
 * 
 * The header class msg_accept_charset_class defines how a 
 * Accept-Charset header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_accept_charset_t header structure.
 * 
 */
#ifndef msg_accept_charset_class
MSG_DLL extern msg_hclass_t msg_accept_charset_class[];
#endif

/**Initializer for an #msg_accept_charset_t structure.
 * 
 * A static msg_accept_charset_t structure must be initialized
 * with the MSG_ACCEPT_CHARSET_INIT() macro. For instance,
 * @code 
 * 
 *  msg_accept_charset_t msg_accept_charset = MSG_ACCEPT_CHARSET_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_ACCEPT_CHARSET_INIT() MSG_HDR_INIT(accept_charset)

/**Initialize an #msg_accept_charset_t structure.
 * 
 * An #msg_accept_charset_t structure can be initialized with the
 * msg_accept_charset_init() function/macro. For instance,
 * @code
 * 
 *  msg_accept_charset_t msg_accept_charset;
 * 
 *  msg_accept_charset_init(&msg_accept_charset);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_accept_charset_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_accept_charset_t *msg_accept_charset_init(msg_accept_charset_t x[1])
{
  return MSG_HEADER_INIT(x, msg_accept_charset_class, sizeof(msg_accept_charset_t));
}
#else
#define msg_accept_charset_init(x) \
  MSG_HEADER_INIT(x, msg_accept_charset_class, sizeof(msg_accept_charset_t))
#endif

/**Test if header object is an instance of #msg_accept_charset_t.
 * 
 * The function msg_is_accept_charset() returns true (nonzero) if
 * the header class is an instance of Accept-Charset header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_accept_charset() returns true (nonzero) if the
 * header object is an instance of header Accept-Charset header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_accept_charset(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_accept_charset_hash;
}
#else
int msg_is_accept_charset(msg_header_t const *header);
#endif

#define msg_accept_charset_p(h) msg_is_accept_charset((h))

/**Duplicate (deep copy) #msg_accept_charset_t.
 * 
 * The function msg_accept_charset_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   accept_charset = msg_accept_charset_dup(home, msg->msg_accept_charset);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_charset_dup() returns a pointer to the
 * newly duplicated #msg_accept_charset_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_charset_t *msg_accept_charset_dup(su_home_t *home, 
				 msg_accept_charset_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_charset_t *msg_accept_charset_dup(su_home_t *home, 
				 msg_accept_charset_t const *header)
{
  return (msg_accept_charset_t *)
    msg_header_dup_as(home, msg_accept_charset_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_accept_charset_t header structure.
 * 
 * The function msg_accept_charset_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   accept_charset = msg_accept_charset_copy(home, msg->msg_accept_charset);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_charset_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_charset_t *msg_accept_charset_copy(su_home_t *home, 
				  msg_accept_charset_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_charset_t *msg_accept_charset_copy(su_home_t *home, 
				  msg_accept_charset_t const *header)
{
  return (msg_accept_charset_t *)
    msg_header_copy_as(home, msg_accept_charset_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_accept_charset_t.
 * 
 * The function msg_accept_charset_make() makes a new #msg_accept_charset_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_accept_charset_make() returns a pointer to newly maked
 * #msg_accept_charset_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_accept_charset_t *msg_accept_charset_make(su_home_t *home, char const *s)
{
  return (msg_accept_charset_t*)msg_header_make(home, msg_accept_charset_class, s);
}
#else
msg_accept_charset_t *msg_accept_charset_make(su_home_t *home, char const *s);
#endif


/**Make a Accept-Charset header from formatting result.
 * 
 * The function msg_accept_charset_format() makes a new Accept-Charset header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_accept_charset_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_charset_t *msg_accept_charset_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_accept_charset_t *msg_accept_charset_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_accept_charset_class, fmt, ap);
  va_end(ap);
 
  return (msg_accept_charset_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Accept-Encoding header */

/**@addtogroup msg_accept_encoding 
 * @{ 
 */

enum { 
  /** Hash of Accept-Encoding header. @internal */
  msg_accept_encoding_hash = 35932 
};

/** Parse a Accept-Encoding header. @internal */
MSG_DLL msg_parse_f msg_accept_encoding_d;

/** Print a Accept-Encoding header. @internal */
MSG_DLL msg_print_f msg_accept_encoding_e;

MSG_DLL msg_xtra_f msg_accept_encoding_dup_xtra;
MSG_DLL msg_dup_f msg_accept_encoding_dup_one;

/**Header class for Accept-Encoding header.
 * 
 * The header class msg_accept_encoding_class defines how a 
 * Accept-Encoding header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_accept_encoding_t header structure.
 * 
 */
#ifndef msg_accept_encoding_class
MSG_DLL extern msg_hclass_t msg_accept_encoding_class[];
#endif

/**Initializer for an #msg_accept_encoding_t structure.
 * 
 * A static msg_accept_encoding_t structure must be initialized
 * with the MSG_ACCEPT_ENCODING_INIT() macro. For instance,
 * @code 
 * 
 *  msg_accept_encoding_t msg_accept_encoding = MSG_ACCEPT_ENCODING_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_ACCEPT_ENCODING_INIT() MSG_HDR_INIT(accept_encoding)

/**Initialize an #msg_accept_encoding_t structure.
 * 
 * An #msg_accept_encoding_t structure can be initialized with the
 * msg_accept_encoding_init() function/macro. For instance,
 * @code
 * 
 *  msg_accept_encoding_t msg_accept_encoding;
 * 
 *  msg_accept_encoding_init(&msg_accept_encoding);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_accept_encoding_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_accept_encoding_t *msg_accept_encoding_init(msg_accept_encoding_t x[1])
{
  return MSG_HEADER_INIT(x, msg_accept_encoding_class, sizeof(msg_accept_encoding_t));
}
#else
#define msg_accept_encoding_init(x) \
  MSG_HEADER_INIT(x, msg_accept_encoding_class, sizeof(msg_accept_encoding_t))
#endif

/**Test if header object is an instance of #msg_accept_encoding_t.
 * 
 * The function msg_is_accept_encoding() returns true (nonzero) if
 * the header class is an instance of Accept-Encoding header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_accept_encoding() returns true (nonzero) if the
 * header object is an instance of header Accept-Encoding header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_accept_encoding(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_accept_encoding_hash;
}
#else
int msg_is_accept_encoding(msg_header_t const *header);
#endif

#define msg_accept_encoding_p(h) msg_is_accept_encoding((h))

/**Duplicate (deep copy) #msg_accept_encoding_t.
 * 
 * The function msg_accept_encoding_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   accept_encoding = msg_accept_encoding_dup(home, msg->msg_accept_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_encoding_dup() returns a pointer to the
 * newly duplicated #msg_accept_encoding_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_encoding_t *msg_accept_encoding_dup(su_home_t *home, 
				 msg_accept_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_encoding_t *msg_accept_encoding_dup(su_home_t *home, 
				 msg_accept_encoding_t const *header)
{
  return (msg_accept_encoding_t *)
    msg_header_dup_as(home, msg_accept_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_accept_encoding_t header structure.
 * 
 * The function msg_accept_encoding_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   accept_encoding = msg_accept_encoding_copy(home, msg->msg_accept_encoding);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_encoding_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_encoding_t *msg_accept_encoding_copy(su_home_t *home, 
				  msg_accept_encoding_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_encoding_t *msg_accept_encoding_copy(su_home_t *home, 
				  msg_accept_encoding_t const *header)
{
  return (msg_accept_encoding_t *)
    msg_header_copy_as(home, msg_accept_encoding_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_accept_encoding_t.
 * 
 * The function msg_accept_encoding_make() makes a new #msg_accept_encoding_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_accept_encoding_make() returns a pointer to newly maked
 * #msg_accept_encoding_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_accept_encoding_t *msg_accept_encoding_make(su_home_t *home, char const *s)
{
  return (msg_accept_encoding_t*)msg_header_make(home, msg_accept_encoding_class, s);
}
#else
msg_accept_encoding_t *msg_accept_encoding_make(su_home_t *home, char const *s);
#endif


/**Make a Accept-Encoding header from formatting result.
 * 
 * The function msg_accept_encoding_format() makes a new Accept-Encoding header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_accept_encoding_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_encoding_t *msg_accept_encoding_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_accept_encoding_t *msg_accept_encoding_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_accept_encoding_class, fmt, ap);
  va_end(ap);
 
  return (msg_accept_encoding_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Accept-Language header */

/**@addtogroup msg_accept_language 
 * @{ 
 */

enum { 
  /** Hash of Accept-Language header. @internal */
  msg_accept_language_hash = 23797 
};

/** Parse a Accept-Language header. @internal */
MSG_DLL msg_parse_f msg_accept_language_d;

/** Print a Accept-Language header. @internal */
MSG_DLL msg_print_f msg_accept_language_e;

MSG_DLL msg_xtra_f msg_accept_language_dup_xtra;
MSG_DLL msg_dup_f msg_accept_language_dup_one;

/**Header class for Accept-Language header.
 * 
 * The header class msg_accept_language_class defines how a 
 * Accept-Language header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_accept_language_t header structure.
 * 
 */
#ifndef msg_accept_language_class
MSG_DLL extern msg_hclass_t msg_accept_language_class[];
#endif

/**Initializer for an #msg_accept_language_t structure.
 * 
 * A static msg_accept_language_t structure must be initialized
 * with the MSG_ACCEPT_LANGUAGE_INIT() macro. For instance,
 * @code 
 * 
 *  msg_accept_language_t msg_accept_language = MSG_ACCEPT_LANGUAGE_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_ACCEPT_LANGUAGE_INIT() MSG_HDR_INIT(accept_language)

/**Initialize an #msg_accept_language_t structure.
 * 
 * An #msg_accept_language_t structure can be initialized with the
 * msg_accept_language_init() function/macro. For instance,
 * @code
 * 
 *  msg_accept_language_t msg_accept_language;
 * 
 *  msg_accept_language_init(&msg_accept_language);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_accept_language_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_accept_language_t *msg_accept_language_init(msg_accept_language_t x[1])
{
  return MSG_HEADER_INIT(x, msg_accept_language_class, sizeof(msg_accept_language_t));
}
#else
#define msg_accept_language_init(x) \
  MSG_HEADER_INIT(x, msg_accept_language_class, sizeof(msg_accept_language_t))
#endif

/**Test if header object is an instance of #msg_accept_language_t.
 * 
 * The function msg_is_accept_language() returns true (nonzero) if
 * the header class is an instance of Accept-Language header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_accept_language() returns true (nonzero) if the
 * header object is an instance of header Accept-Language header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_accept_language(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_accept_language_hash;
}
#else
int msg_is_accept_language(msg_header_t const *header);
#endif

#define msg_accept_language_p(h) msg_is_accept_language((h))

/**Duplicate (deep copy) #msg_accept_language_t.
 * 
 * The function msg_accept_language_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   accept_language = msg_accept_language_dup(home, msg->msg_accept_language);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_language_dup() returns a pointer to the
 * newly duplicated #msg_accept_language_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_language_t *msg_accept_language_dup(su_home_t *home, 
				 msg_accept_language_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_language_t *msg_accept_language_dup(su_home_t *home, 
				 msg_accept_language_t const *header)
{
  return (msg_accept_language_t *)
    msg_header_dup_as(home, msg_accept_language_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_accept_language_t header structure.
 * 
 * The function msg_accept_language_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   accept_language = msg_accept_language_copy(home, msg->msg_accept_language);
 * 
 * @endcode
 * 
 * @return
 * The function msg_accept_language_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_language_t *msg_accept_language_copy(su_home_t *home, 
				  msg_accept_language_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_accept_language_t *msg_accept_language_copy(su_home_t *home, 
				  msg_accept_language_t const *header)
{
  return (msg_accept_language_t *)
    msg_header_copy_as(home, msg_accept_language_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_accept_language_t.
 * 
 * The function msg_accept_language_make() makes a new #msg_accept_language_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_accept_language_make() returns a pointer to newly maked
 * #msg_accept_language_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_accept_language_t *msg_accept_language_make(su_home_t *home, char const *s)
{
  return (msg_accept_language_t*)msg_header_make(home, msg_accept_language_class, s);
}
#else
msg_accept_language_t *msg_accept_language_make(su_home_t *home, char const *s);
#endif


/**Make a Accept-Language header from formatting result.
 * 
 * The function msg_accept_language_format() makes a new Accept-Language header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_accept_language_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_accept_language_t *msg_accept_language_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_accept_language_t *msg_accept_language_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_accept_language_class, fmt, ap);
  va_end(ap);
 
  return (msg_accept_language_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for MIME-Version header */

/**@addtogroup msg_mime_version 
 * @{ 
 */

enum { 
  /** Hash of MIME-Version header. @internal */
  msg_mime_version_hash = 49047 
};

/** Parse a MIME-Version header. @internal */
MSG_DLL msg_parse_f msg_mime_version_d;

/** Print a MIME-Version header. @internal */
MSG_DLL msg_print_f msg_mime_version_e;

MSG_DLL msg_xtra_f msg_mime_version_dup_xtra;
MSG_DLL msg_dup_f msg_mime_version_dup_one;

/**Header class for MIME-Version header.
 * 
 * The header class msg_mime_version_class defines how a 
 * MIME-Version header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_mime_version_t header structure.
 * 
 */
#ifndef msg_mime_version_class
MSG_DLL extern msg_hclass_t msg_mime_version_class[];
#endif

/**Initializer for an #msg_mime_version_t structure.
 * 
 * A static msg_mime_version_t structure must be initialized
 * with the MSG_MIME_VERSION_INIT() macro. For instance,
 * @code 
 * 
 *  msg_mime_version_t msg_mime_version = MSG_MIME_VERSION_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_MIME_VERSION_INIT() MSG_HDR_INIT(mime_version)

/**Initialize an #msg_mime_version_t structure.
 * 
 * An #msg_mime_version_t structure can be initialized with the
 * msg_mime_version_init() function/macro. For instance,
 * @code
 * 
 *  msg_mime_version_t msg_mime_version;
 * 
 *  msg_mime_version_init(&msg_mime_version);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_mime_version_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_mime_version_t *msg_mime_version_init(msg_mime_version_t x[1])
{
  return MSG_HEADER_INIT(x, msg_mime_version_class, sizeof(msg_mime_version_t));
}
#else
#define msg_mime_version_init(x) \
  MSG_HEADER_INIT(x, msg_mime_version_class, sizeof(msg_mime_version_t))
#endif

/**Test if header object is an instance of #msg_mime_version_t.
 * 
 * The function msg_is_mime_version() returns true (nonzero) if
 * the header class is an instance of MIME-Version header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_mime_version() returns true (nonzero) if the
 * header object is an instance of header MIME-Version header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_mime_version(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_mime_version_hash;
}
#else
int msg_is_mime_version(msg_header_t const *header);
#endif

#define msg_mime_version_p(h) msg_is_mime_version((h))

/**Duplicate (deep copy) #msg_mime_version_t.
 * 
 * The function msg_mime_version_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   mime_version = msg_mime_version_dup(home, msg->msg_mime_version);
 * 
 * @endcode
 * 
 * @return
 * The function msg_mime_version_dup() returns a pointer to the
 * newly duplicated #msg_mime_version_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_mime_version_t *msg_mime_version_dup(su_home_t *home, 
				 msg_mime_version_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_mime_version_t *msg_mime_version_dup(su_home_t *home, 
				 msg_mime_version_t const *header)
{
  return (msg_mime_version_t *)
    msg_header_dup_as(home, msg_mime_version_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_mime_version_t header structure.
 * 
 * The function msg_mime_version_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   mime_version = msg_mime_version_copy(home, msg->msg_mime_version);
 * 
 * @endcode
 * 
 * @return
 * The function msg_mime_version_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_mime_version_t *msg_mime_version_copy(su_home_t *home, 
				  msg_mime_version_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_mime_version_t *msg_mime_version_copy(su_home_t *home, 
				  msg_mime_version_t const *header)
{
  return (msg_mime_version_t *)
    msg_header_copy_as(home, msg_mime_version_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_mime_version_t.
 * 
 * The function msg_mime_version_make() makes a new #msg_mime_version_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_mime_version_make() returns a pointer to newly maked
 * #msg_mime_version_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_mime_version_t *msg_mime_version_make(su_home_t *home, char const *s)
{
  return (msg_mime_version_t*)msg_header_make(home, msg_mime_version_class, s);
}
#else
msg_mime_version_t *msg_mime_version_make(su_home_t *home, char const *s);
#endif


/**Make a MIME-Version header from formatting result.
 * 
 * The function msg_mime_version_format() makes a new MIME-Version header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_mime_version_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_mime_version_t *msg_mime_version_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_mime_version_t *msg_mime_version_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_mime_version_class, fmt, ap);
  va_end(ap);
 
  return (msg_mime_version_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-MD5 header */

/**@addtogroup msg_content_md5 
 * @{ 
 */

enum { 
  /** Hash of Content-MD5 header. @internal */
  msg_content_md5_hash = 60494 
};

/** Parse a Content-MD5 header. @internal */
MSG_DLL msg_parse_f msg_content_md5_d;

/** Print a Content-MD5 header. @internal */
MSG_DLL msg_print_f msg_content_md5_e;

MSG_DLL msg_xtra_f msg_content_md5_dup_xtra;
MSG_DLL msg_dup_f msg_content_md5_dup_one;

/**Header class for Content-MD5 header.
 * 
 * The header class msg_content_md5_class defines how a 
 * Content-MD5 header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_md5_t header structure.
 * 
 */
#ifndef msg_content_md5_class
MSG_DLL extern msg_hclass_t msg_content_md5_class[];
#endif

/**Initializer for an #msg_content_md5_t structure.
 * 
 * A static msg_content_md5_t structure must be initialized
 * with the MSG_CONTENT_MD5_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_md5_t msg_content_md5 = MSG_CONTENT_MD5_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_MD5_INIT() MSG_HDR_INIT(content_md5)

/**Initialize an #msg_content_md5_t structure.
 * 
 * An #msg_content_md5_t structure can be initialized with the
 * msg_content_md5_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_md5_t msg_content_md5;
 * 
 *  msg_content_md5_init(&msg_content_md5);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_md5_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_md5_t *msg_content_md5_init(msg_content_md5_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_md5_class, sizeof(msg_content_md5_t));
}
#else
#define msg_content_md5_init(x) \
  MSG_HEADER_INIT(x, msg_content_md5_class, sizeof(msg_content_md5_t))
#endif

/**Test if header object is an instance of #msg_content_md5_t.
 * 
 * The function msg_is_content_md5() returns true (nonzero) if
 * the header class is an instance of Content-MD5 header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_md5() returns true (nonzero) if the
 * header object is an instance of header Content-MD5 header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_md5(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_md5_hash;
}
#else
int msg_is_content_md5(msg_header_t const *header);
#endif

#define msg_content_md5_p(h) msg_is_content_md5((h))

/**Duplicate (deep copy) #msg_content_md5_t.
 * 
 * The function msg_content_md5_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_md5 = msg_content_md5_dup(home, msg->msg_content_md5);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_md5_dup() returns a pointer to the
 * newly duplicated #msg_content_md5_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_md5_t *msg_content_md5_dup(su_home_t *home, 
				 msg_content_md5_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_md5_t *msg_content_md5_dup(su_home_t *home, 
				 msg_content_md5_t const *header)
{
  return (msg_content_md5_t *)
    msg_header_dup_as(home, msg_content_md5_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_md5_t header structure.
 * 
 * The function msg_content_md5_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_md5 = msg_content_md5_copy(home, msg->msg_content_md5);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_md5_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_md5_t *msg_content_md5_copy(su_home_t *home, 
				  msg_content_md5_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_md5_t *msg_content_md5_copy(su_home_t *home, 
				  msg_content_md5_t const *header)
{
  return (msg_content_md5_t *)
    msg_header_copy_as(home, msg_content_md5_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_md5_t.
 * 
 * The function msg_content_md5_make() makes a new #msg_content_md5_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_md5_make() returns a pointer to newly maked
 * #msg_content_md5_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_md5_t *msg_content_md5_make(su_home_t *home, char const *s)
{
  return (msg_content_md5_t*)msg_header_make(home, msg_content_md5_class, s);
}
#else
msg_content_md5_t *msg_content_md5_make(su_home_t *home, char const *s);
#endif


/**Make a Content-MD5 header from formatting result.
 * 
 * The function msg_content_md5_format() makes a new Content-MD5 header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_md5_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_md5_t *msg_content_md5_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_md5_t *msg_content_md5_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_md5_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_md5_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Content-Length header */

/**@addtogroup msg_content_length 
 * @{ 
 */

enum { 
  /** Hash of Content-Length header. @internal */
  msg_content_length_hash = 8402 
};

/** Parse a Content-Length header. @internal */
MSG_DLL msg_parse_f msg_content_length_d;

/** Print a Content-Length header. @internal */
MSG_DLL msg_print_f msg_content_length_e;

MSG_DLL msg_xtra_f msg_content_length_dup_xtra;
MSG_DLL msg_dup_f msg_content_length_dup_one;

/**Header class for Content-Length header.
 * 
 * The header class msg_content_length_class defines how a 
 * Content-Length header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_content_length_t header structure.
 * 
 */
#ifndef msg_content_length_class
MSG_DLL extern msg_hclass_t msg_content_length_class[];
#endif

/**Initializer for an #msg_content_length_t structure.
 * 
 * A static msg_content_length_t structure must be initialized
 * with the MSG_CONTENT_LENGTH_INIT() macro. For instance,
 * @code 
 * 
 *  msg_content_length_t msg_content_length = MSG_CONTENT_LENGTH_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_CONTENT_LENGTH_INIT() MSG_HDR_INIT(content_length)

/**Initialize an #msg_content_length_t structure.
 * 
 * An #msg_content_length_t structure can be initialized with the
 * msg_content_length_init() function/macro. For instance,
 * @code
 * 
 *  msg_content_length_t msg_content_length;
 * 
 *  msg_content_length_init(&msg_content_length);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_content_length_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_content_length_t *msg_content_length_init(msg_content_length_t x[1])
{
  return MSG_HEADER_INIT(x, msg_content_length_class, sizeof(msg_content_length_t));
}
#else
#define msg_content_length_init(x) \
  MSG_HEADER_INIT(x, msg_content_length_class, sizeof(msg_content_length_t))
#endif

/**Test if header object is an instance of #msg_content_length_t.
 * 
 * The function msg_is_content_length() returns true (nonzero) if
 * the header class is an instance of Content-Length header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_content_length() returns true (nonzero) if the
 * header object is an instance of header Content-Length header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_content_length(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_content_length_hash;
}
#else
int msg_is_content_length(msg_header_t const *header);
#endif

#define msg_content_length_p(h) msg_is_content_length((h))

/**Duplicate (deep copy) #msg_content_length_t.
 * 
 * The function msg_content_length_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   content_length = msg_content_length_dup(home, msg->msg_content_length);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_length_dup() returns a pointer to the
 * newly duplicated #msg_content_length_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_length_t *msg_content_length_dup(su_home_t *home, 
				 msg_content_length_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_length_t *msg_content_length_dup(su_home_t *home, 
				 msg_content_length_t const *header)
{
  return (msg_content_length_t *)
    msg_header_dup_as(home, msg_content_length_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_content_length_t header structure.
 * 
 * The function msg_content_length_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   content_length = msg_content_length_copy(home, msg->msg_content_length);
 * 
 * @endcode
 * 
 * @return
 * The function msg_content_length_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_length_t *msg_content_length_copy(su_home_t *home, 
				  msg_content_length_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_content_length_t *msg_content_length_copy(su_home_t *home, 
				  msg_content_length_t const *header)
{
  return (msg_content_length_t *)
    msg_header_copy_as(home, msg_content_length_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_content_length_t.
 * 
 * The function msg_content_length_make() makes a new #msg_content_length_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_content_length_make() returns a pointer to newly maked
 * #msg_content_length_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_content_length_t *msg_content_length_make(su_home_t *home, char const *s)
{
  return (msg_content_length_t*)msg_header_make(home, msg_content_length_class, s);
}
#else
msg_content_length_t *msg_content_length_make(su_home_t *home, char const *s);
#endif


/**Make a Content-Length header from formatting result.
 * 
 * The function msg_content_length_format() makes a new Content-Length header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_content_length_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_content_length_t *msg_content_length_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_content_length_t *msg_content_length_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_content_length_class, fmt, ap);
  va_end(ap);
 
  return (msg_content_length_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Recursive multipart header */

/**@addtogroup msg_multipart 
 * @{ 
 */

enum { 
  /** Hash of Recursive multipart header. @internal */
  msg_multipart_hash = 58884 
};

/** Parse a Recursive multipart header. @internal */
MSG_DLL msg_parse_f msg_multipart_d;

/** Print a Recursive multipart header. @internal */
MSG_DLL msg_print_f msg_multipart_e;

MSG_DLL msg_xtra_f msg_multipart_dup_xtra;
MSG_DLL msg_dup_f msg_multipart_dup_one;

/**Header class for Recursive multipart header.
 * 
 * The header class msg_multipart_class defines how a 
 * Recursive multipart header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_multipart_t header structure.
 * 
 */
#ifndef msg_multipart_class
MSG_DLL extern msg_hclass_t msg_multipart_class[];
#endif

/**Initializer for an #msg_multipart_t structure.
 * 
 * A static msg_multipart_t structure must be initialized
 * with the MSG_MULTIPART_INIT() macro. For instance,
 * @code 
 * 
 *  msg_multipart_t msg_multipart = MSG_MULTIPART_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_MULTIPART_INIT() MSG_HDR_INIT(multipart)

/**Initialize an #msg_multipart_t structure.
 * 
 * An #msg_multipart_t structure can be initialized with the
 * msg_multipart_init() function/macro. For instance,
 * @code
 * 
 *  msg_multipart_t msg_multipart;
 * 
 *  msg_multipart_init(&msg_multipart);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_multipart_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_multipart_t *msg_multipart_init(msg_multipart_t x[1])
{
  return MSG_HEADER_INIT(x, msg_multipart_class, sizeof(msg_multipart_t));
}
#else
#define msg_multipart_init(x) \
  MSG_HEADER_INIT(x, msg_multipart_class, sizeof(msg_multipart_t))
#endif

/**Test if header object is an instance of #msg_multipart_t.
 * 
 * The function msg_is_multipart() returns true (nonzero) if
 * the header class is an instance of Recursive multipart header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_multipart() returns true (nonzero) if the
 * header object is an instance of header Recursive multipart header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_multipart(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_multipart_hash;
}
#else
int msg_is_multipart(msg_header_t const *header);
#endif

#define msg_multipart_p(h) msg_is_multipart((h))

/**Duplicate (deep copy) #msg_multipart_t.
 * 
 * The function msg_multipart_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   multipart = msg_multipart_dup(home, msg->msg_multipart);
 * 
 * @endcode
 * 
 * @return
 * The function msg_multipart_dup() returns a pointer to the
 * newly duplicated #msg_multipart_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_multipart_t *msg_multipart_dup(su_home_t *home, 
				 msg_multipart_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_multipart_t *msg_multipart_dup(su_home_t *home, 
				 msg_multipart_t const *header)
{
  return (msg_multipart_t *)
    msg_header_dup_as(home, msg_multipart_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_multipart_t header structure.
 * 
 * The function msg_multipart_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   multipart = msg_multipart_copy(home, msg->msg_multipart);
 * 
 * @endcode
 * 
 * @return
 * The function msg_multipart_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_multipart_t *msg_multipart_copy(su_home_t *home, 
				  msg_multipart_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_multipart_t *msg_multipart_copy(su_home_t *home, 
				  msg_multipart_t const *header)
{
  return (msg_multipart_t *)
    msg_header_copy_as(home, msg_multipart_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_multipart_t.
 * 
 * The function msg_multipart_make() makes a new #msg_multipart_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_multipart_make() returns a pointer to newly maked
 * #msg_multipart_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_multipart_t *msg_multipart_make(su_home_t *home, char const *s)
{
  return (msg_multipart_t*)msg_header_make(home, msg_multipart_class, s);
}
#else
msg_multipart_t *msg_multipart_make(su_home_t *home, char const *s);
#endif


/**Make a Recursive multipart header from formatting result.
 * 
 * The function msg_multipart_format() makes a new Recursive multipart header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_multipart_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_multipart_t *msg_multipart_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_multipart_t *msg_multipart_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_multipart_class, fmt, ap);
  va_end(ap);
 
  return (msg_multipart_t*)h;
}
#endif

/** @} */

/* Declare internal prototypes for Warning header */

/**@addtogroup msg_warning 
 * @{ 
 */

enum { 
  /** Hash of Warning header. @internal */
  msg_warning_hash = 4130 
};

/** Parse a Warning header. @internal */
MSG_DLL msg_parse_f msg_warning_d;

/** Print a Warning header. @internal */
MSG_DLL msg_print_f msg_warning_e;

MSG_DLL msg_xtra_f msg_warning_dup_xtra;
MSG_DLL msg_dup_f msg_warning_dup_one;

/**Header class for Warning header.
 * 
 * The header class msg_warning_class defines how a 
 * Warning header header is parsed and printed.  It also
 * contains methods used by message parser and other functions
 * to manipulate the #msg_warning_t header structure.
 * 
 */
#ifndef msg_warning_class
MSG_DLL extern msg_hclass_t msg_warning_class[];
#endif

/**Initializer for an #msg_warning_t structure.
 * 
 * A static msg_warning_t structure must be initialized
 * with the MSG_WARNING_INIT() macro. For instance,
 * @code 
 * 
 *  msg_warning_t msg_warning = MSG_WARNING_INIT;
 * 
 * @endcode
 * @HI
 */
#define MSG_WARNING_INIT() MSG_HDR_INIT(warning)

/**Initialize an #msg_warning_t structure.
 * 
 * An #msg_warning_t structure can be initialized with the
 * msg_warning_init() function/macro. For instance,
 * @code
 * 
 *  msg_warning_t msg_warning;
 * 
 *  msg_warning_init(&msg_warning);
 * 
 * @endcode
 * 
 * @param x pointer to #msg_warning_t structure 
 */
#if SU_HAVE_INLINE
su_inline msg_warning_t *msg_warning_init(msg_warning_t x[1])
{
  return MSG_HEADER_INIT(x, msg_warning_class, sizeof(msg_warning_t));
}
#else
#define msg_warning_init(x) \
  MSG_HEADER_INIT(x, msg_warning_class, sizeof(msg_warning_t))
#endif

/**Test if header object is an instance of #msg_warning_t.
 * 
 * The function msg_is_warning() returns true (nonzero) if
 * the header class is an instance of Warning header
 * object and false (zero) otherwise.
 * 
 * @param header pointer to the header structure to be tested
 * 
 * @return The function msg_is_warning() returns true (nonzero) if the
 * header object is an instance of header Warning header and false (zero)
 * otherwise.
 */
#if SU_HAVE_INLINE
su_inline int msg_is_warning(msg_header_t const *header)
{
  return header && header->sh_class->hc_hash == msg_warning_hash;
}
#else
int msg_is_warning(msg_header_t const *header);
#endif

#define msg_warning_p(h) msg_is_warning((h))

/**Duplicate (deep copy) #msg_warning_t.
 * 
 * The function msg_warning_dup() duplicates a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->x_next) to a list of headers, all the headers in the
 * list are duplicated, too.
 * 
 * @param home   memory home used to allocate new structure
 * @param header header structure to be duplicated
 * 
 * When duplicating, all parameter lists and non-constant strings
 * attached to the header are copied, too. The function uses given
 * memory @a home to allocate all the memory areas used to copy the
 * header.
 * 
 * @par Example
 * @code
 * 
 *   warning = msg_warning_dup(home, msg->msg_warning);
 * 
 * @endcode
 * 
 * @return
 * The function msg_warning_dup() returns a pointer to the
 * newly duplicated #msg_warning_t header structure, or NULL
 * upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_warning_t *msg_warning_dup(su_home_t *home, 
				 msg_warning_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_warning_t *msg_warning_dup(su_home_t *home, 
				 msg_warning_t const *header)
{
  return (msg_warning_t *)
    msg_header_dup_as(home, msg_warning_class, (msg_header_t const *)header); 
}
#endif


/**Copy an #msg_warning_t header structure.
 * 
 * The function msg_warning_copy() copies a header structure @a
 * header. If the header structure @a header contains a reference
 * (@c header->h_next) to a list of headers, all the headers in that
 * list are copied, too. The function uses given memory @a home to
 * allocate all the memory areas used to copy the header structure
 * @a header.
 * 
 * @param home    memory home used to allocate new structure
 * @param header  pointer to the header structure to be duplicated
 * 
 * When copying, only the header structure and parameter lists
 * attached to it are duplicated. The new header structure retains
 * all the references to the strings within the old @a header,
 * including the encoding of the old header, if present.
 * 
 * @par Example
 * @code
 * 
 *   warning = msg_warning_copy(home, msg->msg_warning);
 * 
 * @endcode
 * 
 * @return
 * The function msg_warning_copy() returns a pointer to
 * newly copied header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_warning_t *msg_warning_copy(su_home_t *home, 
				  msg_warning_t const *header);

#if SU_HAVE_INLINE
su_inline
msg_warning_t *msg_warning_copy(su_home_t *home, 
				  msg_warning_t const *header)
{
  return (msg_warning_t *)
    msg_header_copy_as(home, msg_warning_class, (msg_header_t const *)header); 
}
#endif


/**Make a header structure #msg_warning_t.
 * 
 * The function msg_warning_make() makes a new #msg_warning_t header
 * structure. It allocates a new header structure, and decodes the string @a
 * s as the value of the structure.
 * 
 * @param home memory home used to allocate new header structure.
 * @param s    string to be decoded as value of the new header structure
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_make().
 * 
 * @return
 * The function msg_warning_make() returns a pointer to newly maked
 * #msg_warning_t header structure, or NULL upon an error.
 */
#if SU_HAVE_INLINE
su_inline msg_warning_t *msg_warning_make(su_home_t *home, char const *s)
{
  return (msg_warning_t*)msg_header_make(home, msg_warning_class, s);
}
#else
msg_warning_t *msg_warning_make(su_home_t *home, char const *s);
#endif


/**Make a Warning header from formatting result.
 * 
 * The function msg_warning_format() makes a new Warning header object
 * using snprintf-formatted result as its value. The function first
 * prints the arguments according to the format @a fmt specified. Then it
 * allocates a new header structure, and uses the formatting result as the
 * header value.
 * 
 * @param home   memory home used to allocate new header structure.
 * @param fmt    string used as a printf()-style format
 * @param ...    argument list for format
 * 
 * @note This function may be implemented as a macro calling
 * msg_header_format().
 * 
 * @return
 * The function msg_warning_format() returns a pointer to newly
 * makes header structure, or NULL upon an error.
 * 
 * @HIDE
 */
#if SU_HAVE_INLINE
su_inline
#endif
msg_warning_t *msg_warning_format(su_home_t *home, char const *fmt, ...)
     __attribute__((__format__ (printf, 2, 3)));

#if SU_HAVE_INLINE
su_inline msg_warning_t *msg_warning_format(su_home_t *home, char const *fmt, ...)
{
  msg_header_t *h;
  va_list ap;
  
  va_start(ap, fmt);
  h = msg_header_vformat(home, msg_warning_class, fmt, ap);
  va_end(ap);
 
  return (msg_warning_t*)h;
}
#endif

/** @} */


/* Internal prototypes */
MSG_DLL msg_update_f msg_accept_update;
MSG_DLL msg_update_f msg_accept_any_update;
MSG_DLL msg_update_f msg_content_disposition_update;

SOFIA_END_DECLS

#endif /** !defined(MSG_MIME_PROTOS_H) */
