#include "SpecCombine.h"

SpecCombine::SpecCombine(){
	m_halfsize = m_vecsize/2;
}

SpecCombine::SpecCombine(SndObj *magin, SndObj* phasin, int vecsize, float sr)
                 :SpecCart(magin, vecsize, sr){
	m_input2 = phasin;
	m_halfsize = m_vecsize/2;
}

SpecCombine::~SpecCombine(){
}


short
SpecCombine::DoProcess(){

if(!m_error){
 if(m_input && m_input2){

	 float a, b; int p;

      m_output[0] = m_input->Output(0);
      m_output[1] = m_input->Output(m_halfsize);

	 if(m_enable) {  
	
	 for(m_vecpos = 1; m_vecpos < m_halfsize; m_vecpos++) {

     p = m_vecpos*2;
     a = m_input->Output(m_vecpos);
	 b = m_input2->Output(m_vecpos);
  
     convert(&a, &b);

	 m_output[p] = a;
	 m_output[p+1] = b;

	 }

}
	else 
	for(m_vecpos = 0; m_vecpos < m_halfsize; m_vecpos++)
		m_output[m_vecpos] = m_output[m_vecpos+m_halfsize] = 0.f;
 
		 return 1;
 } else {
	m_error = 3;
	return 0;
 }
}
else return 0;

}
