#!/bin/sh
#Do not run directly. This is a helper script for make.

copy()
{
  if [ -f $2 ]; then
    echo "  Skipped $2, file already exists"
  else  
    echo "  $2"
    cp $1 $2
  fi        
}

forcecopy()
{
  if [ -f $2 ]; then
    echo "  Overwriting $2"
    cp $1 $2
  else
    echo "  $2"
    cp $1 $2
  fi
}

delete()
{
  if [ -f $1 ]; then
    echo " Deleting $1"
    rm $1
  fi
}

makedir()
{
  if [ -d $1 ]; then
    echo "  Skipped $1, directory already exists"
  else
    echo "  Creating directory $1"
    mkdir $1
  fi
}

echo ""
if [ ! -f src/smsd ] && [ ! -f src/smsd.exe ]; then 
  echo 'Please run "make -s install" instead.'
  exit 1
fi

echo "Installing binary program files"
makedir /usr/local
makedir /usr/local/bin
if [ -f src/smsd.exe ]; then
  forcecopy src/smsd.exe /usr/local/bin/smsd.exe
else
  forcecopy src/smsd /usr/local/bin/smsd
fi
delete /usr/local/bin/getsms
delete /usr/local/bin/putsms

echo "Installing some scripts"
copy scripts/sendsms /usr/local/bin/sendsms
copy scripts/sms2html /usr/local/bin/sms2html
copy scripts/sms2unicode /usr/local/bin/sms2unicode
copy scripts/unicode2sms /usr/local/bin/unicode2sms

echo "Installing config file"
copy examples/smsd.conf.easy /etc/smsd.conf

echo "Creating minimum spool directories"
makedir /var/spool
makedir /var/spool/sms
makedir /var/spool/sms/incoming
makedir /var/spool/sms/outgoing
makedir /var/spool/sms/checked

echo "Installing start-script"
if [ -d /etc/init.d ]; then
  copy scripts/sms /etc/init.d/sms 
elif [ -d /sbin/init.d ]; then
   copy scripts/sms /sbin/init.d/sms
else
  echo "  I do not know where to copy scripts/sms. Please find out yourself."
fi

echo ""
echo "Example script files are not installed automatically."
echo 'Please dont forget to edit /etc/smsd.conf.'
