/*
 * AudioImporter.h -- General collection of kino legacy class extensions
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _AUDIO_IMPORTER_
#define _AUDIO_IMPORTER_

#include <string>
using std::string;

class AudioImporter 
{
	public:
		static AudioImporter *GetImporter( string filename = "" );
		virtual bool Open( string input ) = 0;
		virtual bool Seek( long offset ) = 0;
		virtual bool Close( ) = 0;
		virtual int GetChannels( ) = 0;
		virtual int GetFrequency( ) = 0;
		virtual int GetBytesPerSample( ) = 0;
		virtual bool Get( int16_t **data, int numberofsamples ) = 0;
};

#endif
