#include "petscsys.h"
#include "petscfix.h"
#include "private/fortranimpl.h"
/* contiguous.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepcvec.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcvecsettemplate_ SLEPCVECSETTEMPLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcvecsettemplate_ slepcvecsettemplate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcmatgetvecstemplate_ SLEPCMATGETVECSTEMPLATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcmatgetvecstemplate_ slepcmatgetvecstemplate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcupdatevectors_ SLEPCUPDATEVECTORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcupdatevectors_ slepcupdatevectors
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcupdatestridevectors_ SLEPCUPDATESTRIDEVECTORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcupdatestridevectors_ slepcupdatestridevectors
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define slepcvecmaxpby_ SLEPCVECMAXPBY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define slepcvecmaxpby_ slepcvecmaxpby
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  slepcvecsettemplate_(Vec v, int *__ierr ){
*__ierr = SlepcVecSetTemplate(
	(Vec)PetscToPointer((v) ));
}
void PETSC_STDCALL  slepcmatgetvecstemplate_(Mat mat,Vec *right,Vec *left, int *__ierr ){
*__ierr = SlepcMatGetVecsTemplate(
	(Mat)PetscToPointer((mat) ),right,left);
}
void PETSC_STDCALL  slepcupdatevectors_(PetscInt *n,Vec *V,PetscInt *s,PetscInt *e, PetscScalar *Q,PetscInt *ldq,PetscBool *qtrans, int *__ierr ){
*__ierr = SlepcUpdateVectors(*n,V,*s,*e,Q,*ldq,*qtrans);
}
void PETSC_STDCALL  slepcupdatestridevectors_(PetscInt *n_,Vec *V,PetscInt *s,PetscInt *d,PetscInt *e, PetscScalar *Q,PetscInt *ldq_,PetscBool *qtrans, int *__ierr ){
*__ierr = SlepcUpdateStrideVectors(*n_,V,*s,*d,*e,Q,*ldq_,*qtrans);
}
void PETSC_STDCALL  slepcvecmaxpby_(Vec y,PetscScalar *beta,PetscScalar *alpha,PetscInt *nv,PetscScalar a[],Vec x[], int *__ierr ){
*__ierr = SlepcVecMAXPBY(
	(Vec)PetscToPointer((y) ),*beta,*alpha,*nv,a,x);
}
#if defined(__cplusplus)
}
#endif
