/*
 * Decompiled with CFR 0.152.
 */
package de.calcom.cclib.tree;

import java.util.Enumeration;
import java.util.Vector;

public class SimpleTreeNode {
    private String title = "";
    private Object data = null;
    private boolean expanded = false;
    private SimpleTreeNode parent = null;
    private Vector children = new Vector(0);
    private int row;

    protected SimpleTreeNode(String string) {
        this.title = string != null ? string : "";
    }

    protected SimpleTreeNode(String string, Object object) {
        this.title = string != null ? string : "";
        this.data = object != null ? object : "";
    }

    public String toString() {
        return this.title;
    }

    protected Enumeration getChildren() {
        return this.children.elements();
    }

    protected boolean isExpanded() {
        boolean bl = false;
        if (!this.isLeaf() && this.expanded) {
            bl = true;
        }
        return bl;
    }

    protected boolean isLeaf() {
        boolean bl = true;
        if (this.children.size() > 0) {
            bl = false;
        }
        return bl;
    }

    protected void add(SimpleTreeNode simpleTreeNode) {
        simpleTreeNode.setParent(this);
        this.children.addElement(simpleTreeNode);
    }

    private void setParent(SimpleTreeNode simpleTreeNode) {
        if (simpleTreeNode != null && this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = simpleTreeNode;
    }

    public boolean isRoot() {
        boolean bl = false;
        if (this.parent == null) {
            bl = true;
        }
        return bl;
    }

    protected void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    protected int getRow() {
        return this.row;
    }

    protected void setRow(int n) {
        this.row = n;
    }

    protected int getDepth() {
        int n = 0;
        SimpleTreeNode simpleTreeNode = this;
        while (!simpleTreeNode.isRoot()) {
            simpleTreeNode = simpleTreeNode.parent;
            ++n;
        }
        return n;
    }

    protected void removeChildAt(int n) {
        SimpleTreeNode simpleTreeNode = (SimpleTreeNode)this.children.elementAt(n);
        this.children.removeElementAt(n);
        simpleTreeNode.setParent(null);
    }

    protected void removeChild(SimpleTreeNode simpleTreeNode) {
        this.children.removeElement(simpleTreeNode);
        simpleTreeNode.setParent(null);
    }

    protected SimpleTreeNode getChildAt(int n) {
        return (SimpleTreeNode)this.children.elementAt(n);
    }

    public SimpleTreeNode getParent() {
        return this.parent;
    }

    protected void insert(SimpleTreeNode simpleTreeNode) {
        simpleTreeNode.setParent(this);
        if (!this.isRoot()) {
            this.parent.children.insertElementAt(simpleTreeNode, this.parent.children.indexOf(this));
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

