#
#
# $Id: sigit.spec,v 1.8 2003/07/22 22:03:42 redhead Exp $
#
# BUILD OPTIONS: 1 for yes, 0 for no
%define enable_boxes 0

Name:          Sigit
Version:       0.3.2
Release:       1
Summary:       A dynamic signature generator for e-mail, news and finger
Copyright:     GPL
Group:         Amusements
URL:           http://www.redhead.dk
Source:        http://www.redhead.dk/download/pub/%{name}/develop/%{name}-%{version}.tar.gz
BuildRoot:     /tmp/%{name}-%{version}
BuildRequires: zlib-devel, glibc-devel
Obsoletes:     sigit
Requires:      glibc, zlib
%if %{enable_boxes}
BuildRequires: boxes
%define boxes_config --with-boxes
%else
%define boxes_config --without-boxes
%endif
Packager:      Kenneth 'Redhead' Nielsen <kn@redhead.dk>
Vendor:        Kenneth 'Redhead' Nielsen <kn@redhead.dk>


%description
Getting tired of allways having the same signature attached to your emails. ?
Having trouble comming up with new ones all the time. ?
Problems with having to fit your email and contact info into your signature ?

Does any of these questions sound familiar, then Sigit might be the thing you're looking for.
It will work with your own configuration file, or with the one globaly placed on the system
And you can customise it to fit your every need.

Sigit is not just your simple signature changer, where you give it the signatures file to pick one from,
and tell it what file to write it to..
Sigit is more, it has an advanced way of integrating your favourit editor with the signatures it's
allready using, for easy editing. You can start it as a deamon, where you never have to restart it,
since its running in the background as a system process. And alot more, supporting several signature files
and even gzip support for the signature database.
%if %{enable_boxes}
If you have the boxes package installed, Sigit will also provide the use of having your signatures 
surrounded by the varius box-styles you're used to from the boxes selection. It even provides a random
box-style selection.
%endif

%prep

%setup

%build
rm -rf $RPM_BUILD_ROOT
# Since RPM likes to use it's own flags, we better use those 
CFLAGS="$RPM_OPT_FLAGS" ./configure %{boxes_config} --install-root=$RPM_BUILD_ROOT 

make 

%install
make install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS COPYING INSTALL README TODO 
%attr(555,root,root)/usr/bin/sigit 
%attr(555,root,root)/usr/bin/sigitdb
%attr(644,root,root)/etc/sigit.rc 
%attr(644,root,root)/usr/share/sigit/sigit.data 
%attr(644,root,root)/usr/share/sigit/sigit.sig 
%attr(444,root,root)%{_mandir}/man1/sigit.1* 
%attr(444,root,root)%{_mandir}/man1/sigitdb.1* 
%attr(444,root,root)%{_mandir}/man5/sigit.rc.5*


# If I ever find out a way, to combine the changelog with the log info submitted
# when you use CVS, then I would skip this next part, and just let CVS take controle
# of it all.

%changelog
* Wed Oct 26 2005 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed some more system-independancy, by checking for the str/strn
  equivalent functions, this however makes it the 0.3.2 release.

* Fri Sep 30 2005 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed the change in pthread support with gcc-4.x mentioned by moffe
  this introduced a change in the configure script aswell as in sigit.c
- It also introduced a recognition of the uname() function might not be 
  supported on every system, so now it will check for that too, altho
  it required several 100 lines of code beeing rewritten.

* Thu Nov 09 2004 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Finished on implementing teh limitation signatures. Altho this introduces one small
  bug, which makes it impossible for sigit to pick the last signature in the datafile,
  it is good enough for a release, so here is version 0.3.1

* Thu Oct 21 2004 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Started on the 0.4.0 branch, this one introduces the use of Ernst suggested limitations
  of signatures from the data file, now it will handle a setting in .sigitrc with 
  limit_sig=sigID1-sigID2
  and limit the random signatures between the two given sigID's. 
  It is not yet tested, and will remain untested, untill I find the use for it.

* Wed Mar 24 2004 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Oh how time passes by, I finaly found the time to look through the code one last time and
  now it is officialy time for the stable 0.3.0 version to be released, yay.
- Basicaly what's been done is simply to look through the code for any error, and look after
  some foul code fragments lying around, no extra changes or anything.

* Tue Jul 22 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Cleaned up the code, this included rewriting every struct definition in the program.
- Fixed some error checking to make sure theres no undocumented parts which might give an error.

* Fri Jul 18 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Gathered up the pieces to make a new release, so this is going to be vesion 0.2.4
- Fixed some spelling errors in the man pages and brought the documentation up to date.

* Wed Jul 16 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Added a new conversion char in the buffer_magic(), so you can use %L to display current load
- Fixed some error checking around the /proc file system reads, to ensure no sudden display
  of false information, or some unwanted error.
- Tried to solve the boxes zombie process escalation error.. Trying everything, latest try is to 
  parse '^D' to boxes, to falsely think it is a usual person typing the text that needs a surrounding 
  box.
  Moffe <moffespam (at) amagerkollegiet (dot) dk> showed me the way.. I had forgotten a waitpid() in 
  the pipe handling of boxes. 
- Added a few more email aliases to the spambot-harvesting setting, more like: <rchong@fcc.gov>,
  <rhundt@fcc.gov>, <uce@ftc.gov>, <sness@fcc.gov>, <president@whitehouse.gov>, <haesslich@loyalty.org>,
  <jquello@fcc.gov>
- Fixed a buffer overrun in read_config_fifo() mentioned by moffe. (Dont know how he forms his .sigitrc
  file, but somehow he manages to hit all the trapdoors available in the code.)

* Sun Jul 06 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made a change, so sigit will check for a working boxes, when running, in order to prevent a possible
  segfault if a precompiled binary is installed on a system without boxes installed.

* Mon Feb 03 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Found the problem in the execvp() call, it seems to fail when the -d flag to boxes comes befor the
  -a flag.. Could be a feature in boxes or the execvp() system call, because when the flags order
  is aligned in this way in the shell there's no failing in the boxes call.
- One small flaw is, that after a while, there will be _a lot_ zombie boxes threads. 
  I have to investigate a bit further on that. On the plus side, it now supports random boxes.
- This ensures the release of Sigit version 0.2.2.


* Sun Feb 02 2003 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Finaly found out the problem in my char**, it turned out I can only do what I want, when I return the 
  char** from the function, and at the same time paremeter transfer it to the function call.
  Unfortunately, it seems to fail on the execvp() call..


* Tue Oct 22 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Worked on solving the multiple flags bug. Found that it would require a char** beeing dynamicaly 
  allocated, and only freed when pretty_printer() returns. I have to work some more on it befor the
  pointer arithmetic is solved in this one.


* Mon Oct 21 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Worked on making a random selecting box design into the program, and succeeded in doing so.
  However in the process found a bug, which on giving several flags in the 'boxes_flags' setting
  will cause the boxing and signature creation to fail.


* Fri Oct 18 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Scraped the idear I had last night, turned out it was even easier than I thought, create two
  pipes to boxes, one writing to boxes stdin, the other reading from stdout from boxes. Then just
  write what ever the signature holds to boxes, and use the returned to fill the fifo.
- For ease of use, I've decided to create a --with-boxes flag to configure, so as default it wont
  be supported, this includes none of the code used to intervene with boxes beeing accessible.
- I've been wondering, if a setting allowing sigit to chose a random box from boxes, would be useful
  I think that will be what I am aiming at next.
- Since I made this, and it seems to work version 0.2.1 will be released sometime during the night.


* Thu Oct 17 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- I know, it has been quite some time since I last took at this project, now I've started 
  implementing support for boxes. Right now I'm thinking of reading the config file myself
  and then define how to create the box from that. 


* Thu Jun 20 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Began figuring out, how the boxing feature could be included, made a fix of the fifo_name 
  setting, if it should turn out to be given with full path.


* Wed Jun 19 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Started on the 0.2.1, this included rewriting all the snprintf/sprintf statements since Idealy
  I would like an aesy readable and functional code, when beginning the writing of boxing features.
- Had a discussion with Moffe, if it would be profitable to write a siglib, so other programmers
  could have the bennefit of reading/mengling with sigit data files. At the moment I don't think
  the usage of sigit is at such a large scale, that this would be efficient.


* Thu May 30 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Finished up the stable 0.2.0 release, now its ready for the public.
   (I'll release it, as soon as I get near an Internet connection.)
- Fixed the minor errors in the configure script, which now will work on every major OS.
  (Windows _not_ included, is it even considdered a major OS ??)
- Cleaned the code up a bit, to accomodate the *BSD people on their port of it, so they 
  wont have to read through a ton of crappy code.


* Wed May 01 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Edited the online changelog for the program, it was getting kinda long.. The one online, will 
  only hold info from the 0.1.0 release up untill now, dont worry in the .spec file the 
  complete one will still remain. 


* Sat Apr 27 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Wow, what a movie last night.. Fixed a small (bug) if you must call it that, if the debug_file 
  argument was given as an absolute path it would still be started from $HOME.


* Fri Apr 26 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Just trying to get through the day, waiting for the re-premiere of "The Wall" (can't wait) 
  So I'm just scavenging through the code, looking for 'FIXME' or obvius errors. 


* Wed Apr 24 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Discovered a small bug, (at first it appeared to be a bug) but on second glance, it turned out to be 
  a realy clever move by me. (How on earth did I come up with that) 
- Messed around with the create_pid_file/remove_pid_file, since I would love to have it remove
  the lock file no matter how it gets killed, this was the bug which moffe claimed he had stumbled 
  uppon. So I made a few changes, and hopefuly it will solve it.
- Theres still a small 'bug', the lock file will _not_ be removed, once Sigit dies, so a restart
  will have Sigit trying to kill any program running with the PID stored in the old lock file.
  The chances that a program using the same PID is currently beeing run by the same user is minimal.
  But I would love in my signal_handler to have it call remove_pid_file() when ever a kill signal 
  is recieved, but the sigset_t dosn't hold any handler bindings to a given signal.
- Updated the documentation, and gave it a quick readthrough in order to find any misstypings.


* Mon Apr 22 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Come to think of, that it would be alot easier, if the given --prefix and --etc-dir to the configure
  script, would also take effect in the programs handling of default file locations. So from now
  on, giving these flags during configuring, there will be no need to further make changes to 
  src/config.h, since the parsed DFLAGS will make the desired changes.


* Thu Apr 18 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made some code cleanup, trying to get it as clean as possible for the 0.2.0 release.
- Experiencing some disturbing difficulties at Dikus system, eventho it is beeing compiled on
  perfectly good Linux boxes, the documentation wont compile, simply returns with a 
   'No documentation found in sigit.pod' (Could be a special 'feature' at Diku)
- Moffe is at the moment running a 24/7 debugging on the program, since he claimed to have stumblet
  uppon an error, yet he has failed to recreate it.


* Mon Apr 15 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Due to an unexpected loss of bodyly functions yesterday (cause by intake of too much alcohol), 
  I couldn't get the 0.1.7 release ready.. So here it is.. And it's still in development brach
  since I'm not too sure of the long_args supported in BSD and OSF1, and the pthread support
  on HP-UX still needs to be solved.


* Sat Apr 13 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Got the testing for pthread and getopt_long to work on BSD aswell as OSF1,
  now all that needs is the full support on HP-UX, befor I'm completely satisfied.
  

* Mon Apr 08 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Hacked around on the testing for pthread support on BSD and OSF1 systems.


* Sat Apr 06 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed the long arguments, simply by putting the glibc-2.2.4 getopt.c into the code tree
- Added some testings for seeing if this new getopt_long() implementation would work effecient
  on all architectures.


* Thu Apr 04 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made attempts to fix this problem with the long arguments not beeing treated correct.
  It ended in a stable state, where one solution would _only_ allow using:
   `sigitdb -vv --edit db-file`
  And another solution, where it would _only_ allow using:
   `sigitdb --edit db-file -vv`
- Could be I should install gdd, and try debugging the thing.. 


* Wed Apr 03 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Found a terrible bug in the new changes made, to achieve runable code on all OS'es.
  Turned out, if you were to ask for a --edit/list/rebuild/delete request, it would just 
  print the help info, and exit. 
- However this bug appear to create further bugs, meaning if you use Sigitdb as in:
   `sigitdb -vv --edit db-file
  You will get a segmentation fault, so the only way to provide '-vv' request to the long_args
  is by using the program as in:
   `sigitdb --edit db-file -vv`
- It provided me the need to test all the possibilitys in Error reporting during --edit, which 
  turned out to be a good thing, parts of the error reportings will never get reached, but I'll 
  leave it in, just in case my testings couldn't hit the right conditions.
- Updated the man pages.
- Changed default signature file to be ~/.signature


* Mon Apr 01 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Was playing with the multi cluster-server running case, it seems to be more stable at the moment.
- Added a %C setting to the pretty/top_/bottom_line conversion, which will show the callsign of
  the program, else I would have gotten lost in the CVS versions I was testing. 


* Sat Mar 30 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed an unlink bug in the NFS part of starting the program, which on multi-cluster systems
  couldn't kill an allready running Sigit on another server belonging to the cluster.
- Made fixes to the use of sprintf() versus snprintf() for buffer-overflow, now that the 
  pressence of snprintf() is truely tested, altho those cases fixed here might never be 
  a problem regarding overrun. 


* Sat Mar 23 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made several changes, in order to achieve a code that would be complient with all the major
  OS'es of choice (*BSD, Linux, HP-UX, OSF1, etc)


* Wed Mar 20 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Changed location of the sigit.rc man page, since configuration-documentation should be
  placed in fifth section of the man pages.


* Fri Mar 15 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- And now it's time for the 0.1.6 release, I know the 0.1.5 was supposed to be the last develop,
  but since I've made quite a few changes in the last bit, I would like to still keep it as a 
  develop branch.


* Sat Mar 09 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Changed the '-n' flag, it is not needed any more, and will be disregarded, instead theres a 
  nfs_delay setting to be used on the specific fifo, that you intend to have assigned on a NFS
  mounted location. The number this instruction is set at, will indicate the seconds that will
  pass, befor the fifo's st_atime stamp will be checked for any changes.
- Fixed a possible off-by-one bug in the fetching of signatures, this especialy will make sure 
  theres allways a signature, and not an empty one as we have seen in other versions. 
- Fixed a small bug in the sigit.rc.pod file, which wouldn't let it compile.


* Thu Mar 07 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed a bug, which moffe discovered, if you were to create a db-file containing only one single
  signature, the program would exit with an error, and thereby destroying the db-file. 
- How ever, if the file containing the single signature, is made to look like one containing multiple
  the very last line will have to be: '@@@' else it will assume the tekst file is malformed, and 
  thereby take counter messures to start all over, and in the end give up leaving you with an 
  untouched db-file.
- Made the '-n' flag as supposed to work, it eliminates the need for a Diku-Patch, since it will
  do what was required of the Diku-Patch. For those who failed to follow the thought here, the
  '-n' flag will invoke sigit to work on NFS mounted $HOME systems, in a way which isn't too well 
  known, I've been thinking if it might be needed with a setting in the sigit.rc file aswell.
  This will make it possible to have it set on specific fifos.


* Tue Feb 26 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Changed the show_ident setting, so it will take any desired presetting, and use that as the 
  explanation describing the ident shown. Should some users still use 'no/false' and 'yes/true'
  it will accept those as the qualifiers aswell.  
- Made a quite extensive test of the pthreadding, on my school system, turned out I had forgot 
  it is running on NFS mounted $HOME, so the fifo monitoring was all screwed and turned out, it 
  would only end up monitoring the very first fifo created, thats, in the first place, why I 
  started on the Diku-Patch branch to this program.. 
  I will wait untill version 0.2.0 befor I release a propper Diku-Patch, the Develop branches 
  changes too frequent, I dont want the extra work of having to maintain the patch reguarding 
  to any change made during develpment. (Dont worry, I know exactly what the changes will have to be)
- Fixed a bug in the sigit.pod file, which wouldn't let it compile correct.


* Mon Feb 11 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Fixed a bug, which would cause the db-file to be currupted, if it was of version < 0.1.4
  and you were to do a '--append' on it as the first thing.
- Fixed a bug, where the creation and deletion of the lock file, would hold a nonexisting PID
  when the program was invoked with '-d'
- Fixed some typos in the help sections and configuration.
- Since noone have given me any pointers, on how the configure script is doing on *BSD and HP-UX,
  I will hold the 0.2.0 release, still waiting for some threadding testers to report bugs.
  If there are none in the threadding, well then I must have done something right.


* Sat Feb 02 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- This is it, now the official 0.1.5 release
- Added a way, to have comments inside the sigit.rc file settings parameters.
- finished the print_help() functions, and updated the documentation.
- I would have made this a stable release, but since the threadding of the program
  hasn't been the favorit gift for all the users just yet, I didn't get that one 
  tested so agressively as expected. If anyone would like to do so, please do it now.
- Mengled a bit more with the configure script, it still needs some more tweaks.. 
  How do you get a BSD or OSF1 box to realize the usage of getopt_long(), when thats
  a feature in glibc-2.2 ? And apparently none of the boxes running these OS'es I have
  contact with, is equiped with glibc. If anyone would like to take a look at that, 
  I'm very open to suggestions.
- Same as above, goes with the pthread, I havn't found a way to check on HP-UX if it's 
  supported. Does anyone know that ?? I keep telling myself, the HP-UX boxes I have access
  to gotta support pthreads, but no matter how I check, it fails.  

* Thu Jan 31 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Its getting pretty close to a 0.1.5 release, just finished doing all sort of things
- Change the structure in the file created by doing `sigitdb --edit` Dont worry it takes 
  counter messures for any older versions.
- Added a `sigitdb --list` which will print all the signatures in db-file to stdout.
- Made the autoconf/make script, altho its not entirely an autoconf/make script, just a 
  mengling with Makefiles flags, and a manualy created configure script to test them.
- Actualy changed a whole lot in the configure script to get it working on BSD aswell as
  Linux/HP-UX/OSF1/SunOS I still need some more with strange systems to test it.  
- Planing on starting to make the -H flags work perfect tomorrow, and thus releasing the 0.1.5 

* Sun Jan 13 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made a few changes in the main functions, in order to preserve the checking, and keep the 
  itterations to a minimum, and I added a few more checkups and error messages in case something
  should go wrong.
- Changed sigit to actualy use threads no matter if you want to or not, but remember if theres only
  one fifo, it will not spawn any threads. 
- As of now, this development fase is in a freeze, meaning it is only _very_ urgent extra addings 
  that will be made, untill 0.2.0 is ready it will mainly be debugging and bug fixed this source
  will be going through. Next on the TODO list is the autoconfigure/make things, that might be fun.
- And there you have it folks, version 0.1.4 (develop) is released.


* Sun Jan 13 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Tried further to bring gzip support into the program, turned out it needed more work.
  Started on a fresh with the signature writing routine, thought I would just have to 
  avoid seeking back in the file, turned out it is more complicated than that. 
  If the file is opened for writing, and you seek forward in it, then gzseek() handles it
  by compressing SEEK_OFFSET '\0' into the file, which basicaly means, when I want to seek to the 
  end of the file, in order to add another signature, gzseek() overwrite every signature 
  previusly stored in the file, and leaves me with a db-file where theres only the counter 
  in the beginning, and the last added signature at the end, everything in between is a '\0'
  
  There are two ways to work around that, one would be extreemly simple, instead of using gseek()
  I would have to read every signature in the file, untill filepointer points at the end. This can 
  however not be accomplished, since a gzopened file, which was ment for writing, can't be read.
  The other would be _very_ stupid, I would have to change the counter structure stored first in 
  the file, to maintain info on, where I'm currently storing the signatures, when rebuilding, I 
  would have to make sure, the first stored signature will be placed as the last signature in 
  the file. Then on the loop to store the rest of the signatures, I would have to seek 
  number_of_signatures -=1, into the file, store the next signature, and so on, till I've stored 
  all the signatures, now this requires __a lot__ of gzopen(), gzread(), gzclose(), gzopen(), 
  gzwrite(), gzseek(), gzwrite() in and endless loop, plus it would make the db-file from previus 
  version unusable.. 
  And the task to just add a single sig, would be murder, having to extract all the allready stored 
  ones, add the new sig to that, rebuild the db-file with those, and so forth.
- Tried the second solution, no go, since it tends to close the file _for good_ once you say 
  gzclose(), so when ever I would write a signature, that was one place closer to SEEK_SET,
  it would shorten the whole file. So I ended up with a file containing bits and pieces of every 
  signature added, but filling the same space as a single signature.. It wasn't pretty.
- Found a way, that might work.. Befor having to add any form on signature, I run a gzip converter
  on the file. If it is found to be compressed, it will uncompress it to a temporary file,
  then add all the signatures in question to this temporary file, once that is done, it will 
  recompress this temporary file into the orriginal db-file. It takes a bit more time, than beeing
  able to write compressed directly into the file, but it will give a db-file which isn't attached
  to the process while the whole adding and editing is taking place. 
- However I'm keeping the newly created counter structure, you never know when it might come 
  in handy, but dont worry, the program takes counter messures to make sure any previus db-file
  version can be read correctly.
- It just needs some more testing, and a 0.1.4 version should be on its way. But its 04:39am now
  And I dont feel that comfortable with debugging right now. 


* Sat Jan 12 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Added gzip support in the reading of the signatures from the database, so now it supports
  a gziped database file.. I had some trouble with it, the gzseek() seemed to be _very_
  concerned about wether its return value was messured as (val != 0) or (val < 0), must be my 
  returning from get_sig() that's screwed since it would give segfault... 
  But what the hell, it's 01:42am saturday morning, so I'm not that bright right now. 
  Since it supports gziped format of the db-file, one should make sigitdb compliant with it
  aswell, but no dice, I have read the zlib.h file, and there is _no_ way gzseek() will
  allow to seek back in the file, and sigitdb uses _a lot_ of that at the moment.
  I gotta find a way around that.
  If anyone wanna use it, then create the normal db-file and run a `gzip -9` on that.
- Fixed the bug I had with gzseek(), when I would compare the return value, turned out I 
  wanted to fclose() a gzopend file.. How stupid can one be.. 
- Added some more documentation to the man pages.. You can never get enough documentation.


* Fri Jan 11 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Added the requested stdin reading of signatures in sigitdb, which Sean would appreciate.
  Mailed him a patch, since it seems he's the only one who is troubled by it.
- Adding the stdin reading of signatures seems to make it diffucult for the db-file, if you 
  run a --rebuild or --edit on it directly after, the newly added signature seems to be gone
  yet uppon adding another one, the previus "non existing" signature suddently reappears.
- OK I fixed that small problem, it was an off by one error in edit_data_file()


* Thu Jan 10 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made some adjustments to the pretty_printer(), now it handles the 'show_ident' setting and 
  displaying of your 'name' and 'email' setting. 
- Made an effort to update the verbose output, to acommendate an overall theme, looks prommising
- The changes here will _only_ be available as patches, no need to create a new release at this
  short notice. 


* Thu Jan 10 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Still working on sigitdb, found why it would FUBAR the database, turned out the signature-count
  would be -1923838 for the first signature written, if the database was currupt, this we can't have
  especialy not, now that the following counts is started from that, especialy not with a search
  in the datafile starting from place -192383.
  It also turned out, that it was my verification of a valid db-file aswell that was screwed, no matter 
  what was given to it, it would _only_ return FAILURE, if the file did not exist. 
  So eventho it was the text file to rebuild the database with, it would say, this is a valid 
  db-file, and thus try and read the file binary, and rebuild the db-file from what was read.
- Also after having a chat with Sean, I realised it would be neat with a small script for email
  programs, that can't read from fifos, but can from programs, so I made a small script (ksigit)
  which will take the desired fifo, and simply cat it to stdout. Basicaly its just:
	#!/bin/sh
	cat $1
- And that ladies and gentlemen, makes another (0.1.3) develop release.. 


* Wed Jan 9 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Started working on sigitdb after getting a request from Sean Russell <ser(at)germane-software(dot)com>
  Foud out I needed to use getopt_long() in order to get it working, finished with a 
  version, where the --rebuild tag, will either erase the database, erase the signature file
  or FUBAR the database.. (So take your pick, but be fast, cause we're running out of FUBAR)


* Sun Jan 6 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Well in my deranged state of mind, I decided anyway to have a crack at the pthreads
  turned out it was a good choice. I guess the mind needs to be in a wrong state when
  dealing with pthreads.
- The program will now spawn the desired threads needed to handle the fifos, but thats it
  It will only handle the last thread spawned correct, which means there is still only one
  signature beeing updated. But this time it's the first fifo mentioned in the configuration file.
  The thing is, eventho I do call the pthread_create() with the function to monitor the fifo,
  the function itself never gets executed. (I wonder why), perhaps I can take a look at it 
  tomorrow, once I've been to the doctor.. 
- Never mind that, my deranged mind must've been mutating.. I just rewrote the signal handler,
  and now everything works perfect. Only drawback, is that the fifo never gets removed, once
  you've terminated the program. But it will spawn the needed threads, and it will monitor
  the desired fifos. 
- And due to this, I now have my 0.1.2 develop version released, this is time to celebrate.


* Sun Jan 6 2002 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- I thought I wanted to use this day, where I'm sick as a dog, to catch up on
  the missing documentation. Well actualy I wanted to program a bit, but my current
  state convinced my deranged mind, that it was only suited for documentation.
  So there you have it, the documentation has been updated.
- Had a look at the documentation for signal handling in pthreads, shudder, it's good
  I decided only to handle the documentation today. 


* Fri Dec 28 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Well time for the official development release(0.1.1).
- I experienced problems with the spec file, so I had to take drastic messures
  I even booted windows, and used a win editor to see if that solved it (it didn't)
  Ended up with the fact, that emacs is setting '\r\n' instead of the usual '\n', but 
  the use of pico solved it, apparently it can convert the carrige returns correct.


* Wed Dec 26 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- It's christmas, I wanted to have a version ready for it, but for some reason I couldn't
  find the time to finish the changes needed.
- Made a common Makefile, in order to forsee the restructuring of the file placements.
  It will also make it easier, when the conversion to a ./configure && make install
  make description will be made.
- Restructured the program, to create two different programs, sigit and sigitdb.
  The sigit is the actual signature changer, the sigitdb is a program which will _only_
  allow changes of the signature database. This however required a total rewrite of the 
  man pages, since I can't find the time they will be _extremely_ outdated for a while.


* Sat Oct 20 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Started on the rewriting of Sigit, where it should end up running in threads.
- Changed almost every structure ressembled in the package. Only the SIG structure and 
  COUNTER structure is the same as allways, this is due to the fact, that if I change
  those, the user will have to rebuild the data file, or the program will not be able 
  to work with any previus version of the data file.
- The changing of the structures, will make the old configuration file obsolete. 
  This is nessesary, how are you else gonna tell it, that there should be more fifos,
  than the standard one.. 
  This also involves a total rewrite of the read_config_file(), and in the same sence, 
  that function has changed name to read_config(). 
- Made a new form of debugging, since it is going to run in threads, you assign a debug
  file to every fifo, and any debug information will be placed in the debug file 
  assigned to the fifo. So from now on, the '-vv' argument will only make verbose/terminal
  ouput from the main thread. Any other info will be accessable from the debug files 
  specified.


* Sat Sep 15 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- This is the final 0.1.0 release.
- Made the last changes to pretty_printer().
- Now the debugging info's are uptodate, but be careful with using too many -v
  It will produce an awfull lot of output.
- There still seems to be a problem with empty signatures from time to time, 
  but not on as regular basis as last time. But now I think it's not going to 
  affect anyone, so I'll just let it stay in, as a small reminder.


* Mon Aug 13 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- The latest pre version in the 0.1.0 line, counting pre2 at the moment.
- Added a few more verbose outputs, to acommondate better debugging
- Made a small change to the 'sigit -e' routine, hopefully it will save time, and
  be less space consuming.
- Played with the seg_fault catching function, hope it isn't causing any unsuspected 
  problems.


* Thu Jul 12 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Getting pretty close to the 0.1 final.
- Hopefuly got rid of the "empty signature" bug which has been haunting moffe.
- Fixed a bug, also discovered by moffe, which gave a strange char at the end of the
  signature, if you were using exactly 72 chars in b_line and t_line.
 

* Tue May 29 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Starting slowly on version 0.1 with this pre1.
- Fixed a suspected bug, that Moffe has been having with the b_line and t_line setting.
- Started creating a function, which will catch any segmentation faults the program
  might have, and hopefully print out, what caused the error.
- Fixed a few missplaced logging() calls.


* Fri Mar 16 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- This is going to be the real 0.0.4 version.
- Fixed a small bug, which caused the program to segmentation fault, when you 
  specified your own sig_file setting in the configuration file.
- Made some changes to where the lock file is beeing created, instead of creating 
  it in /tmp, it will now be created in $HOME and named .Sigit-<USER>.lock. 
  This change was made, since I can't control what machine the program is started 
  on at UNI, and since the only thing thats shared throughout the whole system there 
  is $HOME, then I found this to be the only way, I could make sure the program gets 
  killed correctly.
- Got the program to work on HP-UX too.. It was a big/little endian problem, but a call 
  to htonl() and ntohl() solved it.


* Sun Mar 11 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Added a '-l <file>' flag, if you wanted the contence of the data file in a strict 
  text file.
- Added a '-u ident' flag, which will remove the signature that matches the ident 
  from the data file.


* Sat Mar 10 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- This is the pre2 release of version 0.0.4 made some changes to the prity_printer() 
  added a %T in order to have a time stamp in the preset or top and bottom line.
  changed the outcome of %U to be '<time stamp> up xdays hh:mm'.
- Added a %r to the signatures, if a line in the signature starts with it, it will be 
  right aligned according to the longest line found in the signature at that point, 
  if its the very first line, it will be places according to LINE_SIZE.
- Finished the logging() function to work as intended, it turned out there was an error
  in my version of vfprintf() and vsprintf(), don't know if it has something to do 
  with the version of glibc i'm running, made a fix to avoid it.
- Got the fifo part working like a charm. It turned out, that it would be easier to have
  it reread the configuration file on every run, since the user could have made changes 
  to it, while the program was locked by the fifo.
  Since the fifo is now working, the delay sleep() time isn't beeing used any more.
- Chaged the writing/reading of the data file, to avoid any big/little endian problems. 
  (Let's hope this will make it work on HP-UX systems)
- Tested the program with a data file containing 12.500 signatures for 3 hours, with a 
  new signature written every 3. sec. Looks to be running smooth, gave one hell of a 
  logfile tho. 


* Tue Mar 06 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made Sigit into a CVS controled program, which caused a few problems.
  Had to make a different file for the original signatures, since CVS likes
  to keep info in the <programname>.orig file, so all of a suddent it was erased.


* Mon Mar 05 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Hmm trying to prepare the 0.0.4 version to be strict ANSI C.
  And later on use it with some gzip support. But this alpha version of 0.0.4pre1 
  is giving me a hard time. Some of the arguments parsed to the functions will 
  look to be OK during every debugging info, yet no function calls with them seems 
  to work.. 
- This is merely a test version, not intended to be used practical in any way.
  It can't even run properly, so dont even try it, without having a copy of 
  0.0.3 around.


* Sun Feb 25 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- It is time to call this the official 0.0.3 stable release.
- Fixed a bug, which would cause the program only to write one line to the
  signature file, when a line in the desired signture was exactly 72chars
  the fix results in, signatures having intentionaly blank lines, where these 
  blanks won't be written to the fifo.
- Fixed a bug which would cause the program to abort without a warning, if
  you used: -avv where the 'vv' is mistaken to be the filename.


* Sat Feb 24 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Wondering if this should be the stable 0.0.3, but for now its 0.0.3pre4
  I'm not that sure about how stable it is, so it needs a bit more testing.
- Found a few debug info I hadn't removed befor releasing 0.0.3pre3
- Changed the verbose output, so if the program is run as a deamon
  it will syslog the output, instead of just denying output.
- Took a closer look at the prity_printer, and decided that it needs some more
  thinking, but the changes in that will have to wait till 0.0.3


* Fri Feb 23 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- The 0.0.3pre3 is on its way.. not long befor the 0.0.3 is final.
- Fixed a bug, which caused the program to give and endless loop if b_line
  was exactly 72 chars, and t_line was above 72 chars the fix results in 
  even lines above those length will be handlet with grace.. 
- Added a few more conversion chars, so it will take %H, %P and %V for 
  Homepage, Programname, and Version.
- Fixed a bug, which caused it to _not_ remove the temp file, if there was 
  an error while loading the editor for editing the signatures.


* Wed Feb 21 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- 0.0.3pre2 is finaly ready, I must admit 0.0.3pre1 was out too fast, the 
  rewriting of the prity_printer gave more bugs than was needed.
- Solved a few mismatch about the linking and unlinking of the fifo
  when an error occur.
- Brought the man pages up to date with the reason changes.
- Took care of the *required*?? Author fault in the spec file, I thought rpm-4 
  could handle all the settings which rpm-3 can, guess I was wrong. 
- suplied the prity_printer with some comments, in 2 month I cant remember 
  why it does what anyway.. 
- I finaly came up with a description in the spec file.
- Found a small bug in the add_sig function, which made it deny to write the
  very first sig to the data file, yet build the file correct.
- Made a few changes to the format, so I now have a chance to balance a data file
  if the size of the sig structure has changed, and the program is using an older 
  data file.. However this will require every one rebuild their data file from either 
  a sigit -e from the old version, or from the sigit.orig file.. or what ever file
  they are usign now.. 


* Tue Feb 20 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- The pre release 2 is on its way..
- Solved the bug in the new prity_printer, which caused it to partly 
  give segmentation fault, write error to the file, and wind up in an endless loop.
- After i realized, that most users might wanted to use the %M, %N, ...
  in the top line or the bottom line, so i added those into the part, 
  which checks for occurencies of those.


* Mon Feb 19 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Still working on the pre release of version 0.0.3
- changed the order in which the program decides what to do on the arguments 
  and flags parsed to the program.
- Fixed a small bug in the rutine to create the pid file and check for allready 
  running processes.
- Finished writing the man pages.
- Made the '-e' flag in the program start your $EDITOR in order to interactive 
  edit the signatures.
- Changed the '-r' flag to rebuild the database from a filename parsed with the flag.
  only thing is, this file must have the exact same structure, as the 'sigit.orig' file.
- changed the prity_printer, so it will work better with the presettings and _much_ 
  cleaner code.  It now takes %U in the preset, in order to display the uptime
  But for some odd reason it cant take the rest of the arguments to it, without 
  resulting in a segmentation fault. I think it has somethign todo with the utsname struct.


* Fri Feb 16 2001 Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Starting on vesion 0.0.3 still in it's pre release. 
- After recieving a patch for correcting any spelling errors, partialy in 
  the documentation aswell as in the signatures located in the sigit.orig 
  file I kinda got a jump start on this version. 
  Thanks Moffe <moffespam (at) amagerkollegiet (dot) dk>
     - Hope you finished your assignment, instead of using all your time
       to patch my program. 
- After some consideration I have placed the sigit executable in the
  '/usr/bin' dir instead of the previus '/usr/local/bin' to any users 
  of the previus versions, please remove the '/usr/local/bin/sigit' file
  manualy, since I didn't make an option in the uninstall settings to 
  correct this change
- Made a few changes to correct a Big/Little endian problem, when using 
  the program on the HP-UX architechture. (this needs some work too) 
- Added an extra man page, since i felt the documentation on howto create
  the sigitrc file should be kept for it self.
- Fixed a small bug in the unlinking of the fifo file.


* Mon Feb 5 2001  Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Huge upgrade from 0.0.1 to 0.0.2
- Finished the verbose output.
- Made the [-r] and [-e] flags work.
- Changed the programs main function, so it will run as a regular process
  if no arguments are given to the program call. 
  Else use [-d] to make it a deamon.
- Reduced the memory use by 33%  -- which resulted in having to build a 
  new data file. 
- Added a pid file checker.
- Made the spec file work.


* Wed Dec 20 2000  Kenneth 'Redhead' Nielsen <kn@redhead.dk>
- Made the first fragile version 0.0.1
- All the arguments havn't been implemented yet.
- There's no verbose output what so ever.
- The order, in which the program handle the arguments might change, 
  even the number of arguments the program can handle.
