/***************************************************************************
                          player_control.cpp  -  description
                             -------------------
    begin                : Fri Sep 21 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "player.h"

void Player::send_direct_note_on(int p_track,char p_note, char p_volume) {

        if (lock!=NULL) lock->grab();
	runner.event_External_NoteOn(p_track,p_note,p_volume);
        lock->release();
}
void Player::send_direct_note_off(int p_track,char p_note, char p_volume) {

        if (lock!=NULL) lock->grab();
	runner.event_External_NoteOff(p_track,p_note,p_volume);
        if (lock!=NULL) lock->release();

}

void Player::play_note_realtime(int p_track,int p_pattern,int p_column,int p_row) {

        if (lock!=NULL) lock->grab();
	parser.parse_note(p_track,p_pattern,p_column,p_row);
        if (lock!=NULL) lock->release();
}
void Player::play_row_realtime(int p_pattern,int p_row) {

        if (lock!=NULL) lock->grab();
	parser.parse_row(p_pattern,p_row);
        if (lock!=NULL) lock->release();
}
void Player::play(int p_mode=PLAY_SONG,int p_start=0,int p_row_start=0,int p_order_start=-1) {

        if (lock!=NULL) lock->grab();

//	if (data.parameters.mode!=PLAY_NOTHING) reset_internal();

//	if (play_pattern_start==-1) {
//
//		mode=PLAY_MODE_ORDERLIST;
//	}
	
	data.parameters.mode=p_mode;

	//play_parameters.reset();

	switch (data.parameters.mode) {

		case PLAY_PATTERN: {
			
			data.position.row=p_row_start;
			data.position.pattern=p_start;

		} break;
		case PLAY_SONG: {

			if (p_order_start>=0) {

				data.position.order=p_order_start;
			} else {

				data.position.order=song->get_next_order(-1);
			}

			data.position.row=p_row_start;

			if (data.position.order!=-1) {

				data.position.pattern=song->get_order(data.position.order);
			}

		} break;
	}

	if ((data.parameters.mode==PLAY_SONG) && (data.position.order==-1)) {

		reset_internal();
	} else {

		data.variables.rpq=song->speed.rpq;
		data.variables.tempo=song->speed.tempo;

		midiout->play_notify();
	}
	
	finished=false;

        if (lock!=NULL) lock->release();
}

void Player::stop() {

        if (lock!=NULL) lock->grab();
	stop_internal();
	finished=true;
        if (lock!=NULL) lock->release();
}

void Player::reset() {

        if (lock!=NULL) lock->grab();
	reset_internal();
	finished=true;	
        if (lock!=NULL) lock->release();
}

void Player::mute_track(int p_track) {
	int i;

	if (song->get_instrument(p_track)->mute) return; //already muted

        if (lock!=NULL) lock->grab();	

	song->get_instrument(p_track)->mute=true;
	//stop stuff first
        for (i=0;i<song->get_track_width(p_track);i++) runner.stop_channel(p_track,i);
	midiout->send_MIDI_control(runner.get_hw_device(p_track),runner.get_hw_channel(p_track),123,0);

        if (lock!=NULL) lock->release();
}

void Player::unmute_track(int p_track) {

        if (lock!=NULL) lock->grab();

	song->get_instrument(p_track)->mute=false;
	
        if (lock!=NULL) lock->release();
}

void Player::solo_track(int p_track) {
	
	int i,muted_tracks;

	muted_tracks=0;

	// Count the muted tracks besides the current one
	for (i=0;i<song->get_tracks();i++) {

		if ((i!=p_track) && (song->get_instrument(i)->mute)) muted_tracks++;
	}

	if ((muted_tracks==(song->get_tracks()-1)) && (!song->get_instrument(p_track)->mute)) {

		//[[UNMUTE ALL]]

		for (i=0;i<song->get_tracks();i++) unmute_track(i);
		
	} else {

		for (i=0;i<song->get_tracks();i++) {

			if (i==p_track) {

				unmute_track(i);
			} else {

				mute_track(i);
			}
		}
	}
}