#!/usr/bin/python2.3 -O
# maybe you need to change the above line

import os, sys, socket, string
from stat import *
import timeout_socket
import SocketServer

from utils import CRLF, TAB, quote_reply, strategies

import log
import debug

from databases import *

class BangDb:
    def __init__(self):
        self.info = "!"
        self.name = "!"

    def match(self, strat, word):
        matches = []
        for i in list_of_databases():
            r = databases[i].match(strat, word)
            if r:
                return r
        return []

    def define(self, word):
        matches = []
        for i in list_of_databases():
            r = databases[i].define(word)
            if r:
                return r
        return []

class StarDb:
    def __init__(self):
        self.info = "*"
        self.name = "*"
        
    def match(self, strat, word):
        matches = []
        for i in list_of_databases():
            r = databases[i].match(strat, word)
            matches = matches+r
        return matches

    def define(self, word):
        matches = []
        for i in list_of_databases():
            r = databases[i].define(word)
            matches = matches+r
        return matches

execfile("config.py")
execfile("config-dbs.py")



databases = {}
for i in dbases:
    databases[i.name] = i

def list_of_databases():
    return filter(lambda x: x not in ("!", "*"), databases.keys())


class Session:

    def __init__(self, rfile, wfile, client_address):
    
        self.rfile = rfile
        self.wfile = wfile
        self.client_address = client_address

        self.optionmime = 0
        self.reply("220 hello <> msg")
        
        self.cmddict = { #command, function, nr of arguments
            "QUIT"   : (self.cmd_quit, 0),
            "DEFINE" : (self.cmd_define, 2),
            "MATCH"  : (self.cmd_match, 3),
            "CLIENT" : (self.cmd_client, 1),
            "STATUS" : (self.cmd_status, 0),
            "SHOW"   : (self.cmd_show, 1),
            "HELP"   : (self.cmd_help, 0),
            "OPTION" : (self.cmd_option, 1),
            }

    def reply(self, x):
        debug("---> "+repr(x))
        #debug("---> "+str(x))
        try:
            self.wfile.write(x + CRLF)
            self.wfile.flush()
        except:
            debug('FAILED')
        
    def complete(self):
        self.reply("250 Command complete")

    def cmd_quit(self):
        self.reply("221 bye bye")
        raise "session_exit"

    def cmd_status(self):
        self.reply("210 I'm well thanks")

    def cmd_option(self, wh):
        wh = string.upper(wh)
        if wh=='MIME':
            self.optionmime = 1
            self.reply("250 MIME will be used")
        else:
            self.reply("500 I'be be damned if I knew what you want")

    def cmd_help(self):
        self.reply("113 help text follows")
        self.reply("help me")
        self.reply(".")
        self.complete()

    def cmd_define(self, db, word):
        if word[0]=='"':
            word = word[1:-1]
        if not databases.has_key(db):
            self.reply("550 Not here")
            return
        try:
            word = unicode(word, 'utf-8').lower()
        except UnicodeDecodeError:
            word = unicode(word, 'iso-8859-1').lower()
        word = word.encode('utf-8')
        dbi = databases[db]
        r = dbi.define(word)
        if not r:
            self.reply("552 Not here")
            return
        nod = len(r) # number of definitions
        self.reply("150 %i here you are" % nod)
        for i in r:
            db = i[0]
            self.reply('151 "%s" %s "%s"' % (word, db, databases[db].info))
            if self.optionmime: # a hack
                mimeheader = "Content-Type: text/plain; charset=utf8"+CRLF
                self.reply(quote_reply(mimeheader+i[1]))
            else:
                self.reply(quote_reply(i[1]))
            self.reply(".")
        self.complete()

    def cmd_match(self, db, strat, word):
        if word[0]=='"':
            word = word[1:-1]
        if not databases.has_key(db):
            self.reply("550 Not here")
            return
        try:
            word = unicode(word, 'utf-8').lower()
        except UnicodeDecodeError:
            word = unicode(word, 'iso-8859-1').lower()
        word = word.encode('utf-8')
        dbi = databases[db]
        r = dbi.match(strat, word)
        if not r:
            self.reply("552 Not here")
            return
        self.reply("152 %i here you are" % len(r))
        for i in r:
            db = i[0]
            self.reply('%s "%s"' %(db, i[1]))
        self.reply(".")
        self.complete()

    def cmd_client(self, text):
        self.reply("250 nice to meet you")
    
    def cmd_show(self, wh):
        what = string.upper(wh)
        if what in ('DB', 'DATABASES'):
            n = len(databases)
            #self.reply("554 No db available")
            self.reply("110 %i databases here" % n)
            for i in list_of_databases():
                d = databases[i]
                self.reply('%s "%s"' % (i, d.info))
            self.reply(".")
        elif what in ('STRAT', 'STRATEGIES'):
            #self.reply("555 No strategies available")
            nrs = len(strategies)
            self.reply("111 %i strategies here" % nrs)
            for i, v in strategies.items():
                self.reply('%s "%s"' % (i, v[1]))
            self.reply(".")
        elif what[:4]=='INFO':
            db = string.split(wh, None, 1)[1]
            #self.reply('550 Invalid database, use "SHOW DB" for list of databases')
            self.reply("112 database information follows")
            self.reply("this is db %s" % db)
            self.reply(".")
        elif what == 'SERVER':
            self.reply("114 server information follows")
            self.reply("serpento")
            self.reply(".")
        self.complete()
    

    # parses the command and eventually calls the appropriate routine
    def docmd(self, cmd):
        debug("<--- "+repr(cmd))
        # if the connection has broken... we have to shut down:
        if cmd == "":
            raise "session_exit"
        # filter suspicious chars first
        log.logr(self.client_address[0], string.rstrip(cmd))
        cmd2 = filter(lambda x: ord(x) >= 32, cmd)
        lcmd2 = string.split(cmd2, None, 1) or [""]
        command = string.upper(lcmd2[0])
        if self.cmddict.has_key(command):
            args = []
            nargs = self.cmddict[command][1]
            if nargs>0:
                if len(lcmd2)<=1:
                    self.reply("501 syntax error, illegal parameters")
                    return
                lcmd2 = string.lstrip(lcmd2[1])
                args = string.split(lcmd2, None, nargs-1)
        else:
            self.reply("500 I'd be be damned if I knew what you want")
            return

        c = cmd2
        try:
            self.cmddict[command][0](*args)
        except TypeError: # bad number of arguments
            self.reply("501 syntax error, illegal parameters")

    def loop(self):
        while 1:
            try:
                l = self.rfile.readline()
            except timeout_socket.Timeout:
                debug("timeout")
                break
            except socket.error: # but if anythin happened with control connection, go out
                break
            try:
                self.docmd(l)
            except "session_exit":
                break
                
        debug("Connection closed.")



def watchdog():
    while 1:
        time.sleep(2)
        cur_time = time.time()
        print sessions
        for i in range(len(sessions)):
            print sessions[i].ip
        print



# the main routine
# ----------------


class NoneClass:
    pass

class DummyLock:
    def acquire(self):
        pass
    def release(self):
        pass

try:
    import thread
    threading = 1
except:
    threading = 0

if threading:
    thlock = thread.allocate_lock()
else:
    thlock = DummyLock()


forking =  hasattr(os, "fork")

sessions = {}

t_socket = timeout_socket.timeout_socket

#test if we are running from inetd
inetd = 1
inetdsock = 0
try:
    inetdsock = socket.fromfd(sys.stdin.fileno(), socket.AF_INET, socket.SOCK_STREAM)
    inetdsock.getsockname()
except (socket.error, AttributeError):
    inetd = 0
    del inetdsock

log = log.Log(logfile)

d = debug.Debug(debuglevel)
debug = d.debug
log.log("Serpento started")




if inetd:
    client_addr = inetdsock.getpeername()
    session = Session(sys.stdin, sys.stdout, client_addr)
    session.loop()
    del session
    sys.exit(0)


if threading:
    mixin = SocketServer.ThreadingMixIn
elif forking:
    mixin = SocketServer.ForkingMixIn
else:
    mixin = NoneClass


class MyStreamRequestHandler(SocketServer.StreamRequestHandler):
    def finish(self):
        self.wfile.flush()
        self.wfile.close()
        self.rfile.close()
        self.request.close()

class TCPServer(mixin, SocketServer.TCPServer):
    def server_bind(self):
        """Called by constructor to bind the socket.
        """
        self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        self.socket.bind(self.server_address)

    def get_request(self):
        """Get the request and client address from the socket.
        """
        conn, adr = self.socket.accept()
        conn = t_socket(sock=conn, timeout=timeout)
        return conn, adr


class DictServer(MyStreamRequestHandler):
    def handle(self):
        session = Session(self.rfile, self.wfile, self.client_address)
        session.loop()
        del session



address = ('', port)
server = TCPServer(address, DictServer)


server.serve_forever()
