/*
 /  Author: Sam Rushing <rushing@nightmare.com>
 /  Hacked for Unix by A.M. Kuchling <amk1@bigfoot.com> 
 /  $Id: mmapmodule.c,v 2.24 2000/10/01 17:50:46 fdrake Exp $

 / mmapmodule.cpp -- map a view of a file into memory
 /
 / todo: need permission flags, perhaps a 'chsize' analog
 /   not all functions check range yet!!!
 /
 /
 / Note: This module currently only deals with 32-bit file
 /   sizes.
 /
 / This version of mmapmodule.c has been changed significantly
 / from the original mmapfile.c on which it was based.
 / The original version of mmapfile is maintained by Sam at
 / ftp://squirl.nightmare.com/pub/python/python-ext.
*/

/* this is just ripped header file, because we need to access
   mmap_object structure.
   
                     Radovan Garabik <garabik@melkor.dnp.fmph.uniba.sk>
*/

#ifndef MMAP_INCLUDED
#define MMAP_INCLUDED


#ifndef MS_WIN32
#define UNIX
#endif

#ifdef MS_WIN32
#include <windows.h>
#endif

#ifdef UNIX
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>

#ifndef MS_SYNC
/* This is missing e.g. on SunOS 4.1.4 */
#define MS_SYNC 0
#endif

#endif /* UNIX */

typedef struct {
	PyObject_HEAD
	char *	data;
	size_t	size;
	size_t	pos;

#ifdef MS_WIN32
	HANDLE	map_handle;
	HANDLE	file_handle;
	char *	tagname;
#endif

#ifdef UNIX
        int fd;
#endif
} mmap_object;

#endif

