 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALIGN_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AlignConfig

template <bool TTop , bool TLeft , bool TRight , bool TBottom , typename TSpec > class AlignConfig;       	// "projects/library/seqan/graph_align/graph_align_config.h"(52)

//____________________________________________________________________________
// _TraceBack

struct _TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(75)

//____________________________________________________________________________
// _Translate_Table_Byte_2_TraceBack

template <typename T > struct _Translate_Table_Byte_2_TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(38)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// TraceBack

typedef SimpleType<unsigned char, _TraceBack> TraceBack;       	// "projects/library/seqan/graph_align/graph_align_base.h"(76)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __myInitBottom

template <bool TTop, bool TLeft, bool TRight, typename TSpec> inline bool __myInitBottom(AlignConfig<TTop, TLeft, TRight, true, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(449)
template <bool TTop, bool TLeft, bool TRight, typename TSpec> inline bool __myInitBottom(AlignConfig<TTop, TLeft, TRight, false, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(456)

//____________________________________________________________________________
// __myInitLeft

template <bool TTop, bool TRight, bool TBottom, typename TSpec> inline bool __myInitLeft(AlignConfig<TTop, true, TRight, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(417)
template <bool TTop, bool TRight, bool TBottom, typename TSpec> inline bool __myInitLeft(AlignConfig<TTop, false, TRight, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(424)

//____________________________________________________________________________
// __myInitRight

template <bool TTop, bool TLeft, bool TBottom, typename TSpec> inline bool __myInitRight(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(433)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec> inline bool __myInitRight(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(440)

//____________________________________________________________________________
// __myInitTop

template <bool TLeft, bool TRight, bool TBottom, typename TSpec> inline bool __myInitTop(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(401)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec> inline bool __myInitTop(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(408)

//____________________________________________________________________________
// _align_banded_gotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TDiagonal, typename TAlignConfig> inline typename Value<TScore>::Type _align_banded_gotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, TDiagonal diagL, TDiagonal diagU, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_banded_gotoh.h"(146)

//____________________________________________________________________________
// _align_banded_gotoh_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TValPair, typename TIndexPair, typename TDiagonal> inline void _align_banded_gotoh_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TValPair const& overallMaxValue, TIndexPair const& overallMaxIndex, TDiagonal const diagL, TDiagonal const diagU);       	// "projects/library/seqan/graph_align/graph_align_banded_gotoh.h"(42)

//____________________________________________________________________________
// _align_banded_nw

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TDiagonal, typename TAlignConfig> inline typename Value<TScore>::Type _align_banded_nw(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, TDiagonal diagL, TDiagonal diagU, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(164)

//____________________________________________________________________________
// _align_banded_nw_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TValPair, typename TIndexPair, typename TDiagonal> inline void _align_banded_nw_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TValPair const& overallMaxValue, TIndexPair const& overallMaxIndex, TDiagonal const diagL, TDiagonal const diagU);       	// "projects/library/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(41)

//____________________________________________________________________________
// _align_gotoh

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_gotoh(TTrace& trace, TStringSet const& str, TScore const & sc, TValPair& overallMaxValue, TIndexPair& overallMaxIndex, typename Value<TTrace>::Type& initialDir, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(151)

//____________________________________________________________________________
// _align_gotoh_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair, typename TVal> inline void _align_gotoh_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex, TVal const initialDir);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(40)

//____________________________________________________________________________
// _align_hirschberg

template <typename TTrace, typename TStringSet, typename TScoreValue, typename TSpec> TScoreValue _align_hirschberg(TTrace& trace, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(122)

//____________________________________________________________________________
// _align_hirschberg_trace

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTrace> void _align_hirschberg_trace(TAlign& align, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTrace& trace);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(41)

//____________________________________________________________________________
// _align_needleman_wunsch

template <typename TTrace, typename TStringSet, typename TScore, typename TValPair, typename TIndexPair, typename TAlignConfig> inline typename Value<TScore>::Type _align_needleman_wunsch(TTrace & trace, TStringSet const & str, TScore const & _sc, TValPair & overallMaxValue, TIndexPair & overallMaxIndex, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(120)

//____________________________________________________________________________
// _align_needleman_wunsch_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TIndexPair> void _align_needleman_wunsch_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TIndexPair const& overallMaxIndex);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(39)

//____________________________________________________________________________
// _align_smith_waterman

template <typename TTrace, typename TStringSet, typename TScore, typename TIndexPair, typename TForbidden> inline typename Value<TScore>::Type _align_smith_waterman(TTrace& trace, TStringSet const& str, TScore const & sc, typename Value<TTrace>::Type& initialDir, TIndexPair& indexPair, TForbidden& forbidden);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(200)

//____________________________________________________________________________
// _align_smith_waterman_trace

template <typename TAlign, typename TStringSet, typename TTrace, typename TVal, typename TIndexPair, typename TForbidden> inline void _align_smith_waterman_trace(TAlign& align, TStringSet const& str, TTrace const& trace, TVal const initialDir, TIndexPair const& indexPair, TForbidden& forbidden);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(90)

//____________________________________________________________________________
// _align_trace_print

template <typename TFile, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(TFile& file, TStringSet const& str, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(99)
template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet2, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TStringSet2 const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(152)
template <typename TFragment, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<TFragment>& matches, TStringSet const&, TId const id1, TPos const pos1, TId const id2, TPos const pos2, TPos const seqLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(178)
template <typename TVertexDescriptor, typename TSpec, typename TStringSet, typename TId, typename TPos, typename TTraceValue> inline void _align_trace_print(String<String<TVertexDescriptor, TSpec> >& nodeString, TStringSet const& str, TId const, TPos const pos1, TId const, TPos const pos2, TPos const segLen, TTraceValue const tv);       	// "projects/library/seqan/graph_align/graph_align_base.h"(198)

//____________________________________________________________________________
// _globalAlignment

template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(273)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, Gotoh);       	// "projects/library/seqan/graph_align/graph_align_gotoh.h"(300)
template <typename TAlign, typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(485)
template <typename TStringSet, typename TScore, typename TSpec> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, AlignConfig<false, false, false, false, TSpec> const, Hirschberg);       	// "projects/library/seqan/graph_align/graph_align_hirschberg.h"(508)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(216)
template <typename TStringSet, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, NeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_needleman_wunsch.h"(241)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_banded_gotoh.h"(290)
template <typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_banded_gotoh.h"(319)
template <typename TAlign, typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TAlign& align, TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(270)
template <typename TStringSet, typename TScore, typename TAlignConfig, typename TDiagonal> inline typename Value<TScore>::Type _globalAlignment(TStringSet const& str, TScore const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_banded_needleman_wunsch.h"(299)

//____________________________________________________________________________
// _initFirstColumn

template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, false, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph_align/graph_align_config.h"(162)
template <bool TTop, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstColumn(AlignConfig<TTop, true, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(174)

//____________________________________________________________________________
// _initFirstRow

template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<false, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const cost);       	// "projects/library/seqan/graph_align/graph_align_config.h"(186)
template <bool TLeft, bool TRight, bool TBottom, typename TSpec, typename TElement, typename TCost> inline void _initFirstRow(AlignConfig<true, TLeft, TRight, TBottom, TSpec> const, TElement& element, TCost const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(198)

//____________________________________________________________________________
// _isClumping

template <typename TSpec, typename TSize> inline bool _isClumping(String<bool, TSpec> const& forbidden, TSize row, TSize col, TSize len2);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(64)
template <typename TSize> inline bool _isClumping(Nothing&, TSize, TSize, TSize);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(76)

//____________________________________________________________________________
// _lastColumn

template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _lastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1&, TColumn const& column);       	// "projects/library/seqan/graph_align/graph_align_config.h"(245)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TColumn> inline void _lastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TColumn const& column);       	// "projects/library/seqan/graph_align/graph_align_config.h"(258)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastColumn(AlignConfig<TTop, TLeft, false, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "projects/library/seqan/graph_align/graph_align_config.h"(345)
template <bool TTop, bool TLeft, bool TBottom, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastColumn(AlignConfig<TTop, TLeft, true, TBottom, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "projects/library/seqan/graph_align/graph_align_config.h"(360)

//____________________________________________________________________________
// _lastRow

template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1&, TIndex1&, TValue2 const, TIndex2 const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(215)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const index);       	// "projects/library/seqan/graph_align/graph_align_config.h"(229)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, false, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "projects/library/seqan/graph_align/graph_align_config.h"(375)
template <bool TTop, bool TLeft, bool TRight, typename TSpec, typename TValue1, typename TIndex1, typename TValue2, typename TIndex2> inline void _lastRow(AlignConfig<TTop, TLeft, TRight, true, TSpec> const, TValue1& maxValue, TIndex1& maxIndex, TValue2 const val, TIndex2 const row, TIndex2 const col);       	// "projects/library/seqan/graph_align/graph_align_config.h"(390)

//____________________________________________________________________________
// _localAlignment

template <typename TAlign, typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(333)
template <typename TStringSet, typename TScore> inline typename Value<TScore>::Type _localAlignment(TStringSet const& str, TScore const& sc, SmithWaterman);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(361)
template <typename TAlign, typename TStringSet, typename TForbidden, typename TScore> inline typename Value<TScore>::Type _localAlignment(TAlign& align, TStringSet& str, TForbidden& forbidden, TScore const& sc, SmithWatermanClump);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_clump.h"(41)
template <typename TString, typename TMatches, typename TScores, typename TScore, typename TSize1> inline void _localAlignment(StringSet<TString, Dependent<> > const& str, TMatches& matches, TScores& scores, TScore const& sc, TSize1 numAlignments, SmithWatermanClump);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman_clump.h"(82)

//____________________________________________________________________________
// _maxOfAlignment

template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, false, false, TSpec> const, TValue& maxValue, TIndex&, TSize const, TSize const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(283)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, true, false, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const len1, TSize const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(297)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, false, true, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const, TSize const len2);       	// "projects/library/seqan/graph_align/graph_align_config.h"(312)
template <typename TScoreValue, bool TTop, bool TLeft, typename TSpec, typename TValue, typename TIndex, typename TSize> inline TScoreValue _maxOfAlignment(AlignConfig<TTop, TLeft, true, true, TSpec> const, TValue& maxValue, TIndex& maxIndex, TSize const len1, TSize const len2);       	// "projects/library/seqan/graph_align/graph_align_config.h"(327)

//____________________________________________________________________________
// _pairWiseSumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TAlignConfig> inline typename Value<TScore>::Type _pairWiseSumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& sc, TAlignConfig const);       	// "projects/library/seqan/graph_align/graph_align_config.h"(468)

//____________________________________________________________________________
// _setForbiddenCell

template <typename TSpec, typename TSize> inline void _setForbiddenCell(String<bool, TSpec>& forbidden, TSize len1, TSize len2, TSize numRows);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(41)
template <typename TSize> inline void _setForbiddenCell(Nothing&, TSize, TSize, TSize);       	// "projects/library/seqan/graph_align/graph_align_smith_waterman.h"(53)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(65)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(79)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(91)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(104)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(116)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TTag> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(130)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(146)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(161)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(176)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(192)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedNeedlemanWunsch);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(208)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(224)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TDiagonal> inline TScoreValue globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(239)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(254)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(270)
template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TAlignConfig, typename TDiagonal> inline TScoreValue globalAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TAlignConfig const, TDiagonal diag1, TDiagonal diag2, BandedGotoh);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(286)
template <typename TStringSet, typename TCargo, typename TSpec> inline int globalAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Lcs);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(297)

//____________________________________________________________________________
// localAlignment

template <typename TAlign, typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TAlign& file, TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(330)
template <typename TStringSet, typename TScoreValue, typename TSpec, typename TTag> inline TScoreValue localAlignment(TStringSet const& str, Score<TScoreValue, TSpec> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(341)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScoreValue, typename TSpec2, typename TTag> inline TScoreValue localAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, Score<TScoreValue, TSpec2> const& sc, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(353)

//____________________________________________________________________________
// multiLocalAlignment

template <typename TString, typename TMatches, typename TScores, typename TScoreValue, typename TSpec2, typename TSize, typename TTag> inline void multiLocalAlignment(StringSet<TString, Dependent<> > const& str, TMatches& matches, TScores& scores, Score<TScoreValue, TSpec2> const& sc, TSize numAlignments, TTag);       	// "projects/library/seqan/graph_align/graph_align_interface.h"(391)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

